_G.clearColor = { red = 1, green = 1, blue = 1 }

time = 0


local model = {
	fs = "shellshading",
	uniforms = {
		directionalLight = { 1, 1, 0 },
		intensity = 0.7,
		ambientLight = 0.5,
		threshold = 5,
		shadowTexture = "pencil_shading_texture",
		dustTexture = "dust_particles_texture",
		shadowTextureOffset = {0, 0 },--{ function() return time / 50 end, function() return time / 50 end },--{ function() return math.random() end, function() return math.random() end }
		dustTextureOffset = { function() return math.random() end, function() return math.random() end },
	}
}

local shapeColor = 0
local getShapeColor = function()
	shapeColor = shapeColor + 1
	return { shapeColor, 0, 0, 1 }
end

local shape = {
	fs = "pn",
	uniforms = {
		directionalLight = { 1, 1, 0},
		intensity = 0.8,
		ambientLight = 1,
		color = getShapeColor,
	}
}

renderTextureTargets = {
	effect1 = { width = config.width * 2, height = config.height * 2 },
	effect2 = { width = config.width, height = config.height },
}

local loop = function() while true do shapeColor = 0; coroutine.yield(); end end

print("Loaded game.lua")

_G.world = {
	update = coroutine.create(loop),
	{
		instance{shape, model = "Flowers_Camera_Squishedsphere", scale = 0.1, layer = "effect1", },
		instance{model, model = "Flowers_Camera_Squishedsphere", scale = 0.1, },
		rotationY = function() return time * 10 end
	},
	{
		texture = "effect1",
		layer = "outlines",
		fs = "outlines",
		width = config.width * 2,
		height = config.height * 2,
		uniforms = {
			color = {0, 0, 0, 1},
			textureWidth = config.width * 2,
			textureHeight = config.height * 2,
			sampleDistance = 2,
		}
	},
	{
		{ camera = { projection = "perspective", fov = 65, layer = "effect1", target = "effect1" }, z = 15, y = 3 },
		{ camera = { projection = "perspective", fov = 65 }, z = 15, y = 3 },
		x = function() return math.cos(time) * 1 end,
		y = function() return math.sin(time) * 1 end,
	},
	{ camera = { width = config.width * 2, height = config.height * 2, fit = "", layer = "outlines" } },
}

--[[
local effectSize = 256

renderTextureTargets = {
	effect1 = { size = effectSize },
	effect2 = { size = effectSize },
	effect3 = { size = effectSize * 2 },
}

local lightPositionX = function()
	return math.cos(time * 0.5) * 0.25 + 0.5
end

local lightPositionY = function()
	return math.cos(time * 0.3) * 0.1 + 0.3
end

radialBlurStep = {
	texture = "effect1",
	width = effectSize,
	height = effectSize,
	layer = "effect1",
	fs = "radial_blur",
	uniforms = {
		size = effectSize,
		source = { lightPositionX, lightPositionY },
		density = 0.99,
		samples = 400,
		mask = "effect3",
	},
	camera = { width = effectSize, height = effectSize, fit = "", layer = "effect1" }
}


time = 0

local object = {
	model = "Axis",
	layer = "3d",
--	rotationY = function() return time * 50 end,
--	rotationX = function() return time * 50 end,
	uniforms = {
		directionalLight = { 1, 0, 0},
		intensity = 0.8,
		color = { 1, 0.5, 1, 1 },
		ambientLight = 0.6,
	}
}

local makeFlower = function(i)
	return { instance{ object, scale = 1, model = "animated_flowers_02", scale = 0.5 } }
end

_G.world = {
	{
		{
			y = -4,
			{ instance{ model, model = "Flower02", scale = 0.1, y = -4, x =  0, z = -2, rotationX =  -5, rotationZ = -10 } },
			{ instance{ model, model = "Flower02", scale = 0.1, y = -5.2, x = -6, z = -3, rotationX =  -5, rotationZ = -10 } },
			{ instance{ model, model = "Flower02", scale = 0.1, y = -5.2, x =  6, z = -3, rotationX =  -5, rotationZ = -10 } },
			{ instance{ model, model = "Flower02", scale = 0.1, y = -4.0, x =  3, z = -6, rotationX = -25, rotationZ =   0 } },
			{ instance{ model, model = "Flower02", scale = 0.1, y = -4.0, x = -3, z = -6, rotationX =   0, rotationZ =   0 } },
			{ instance{ model, model = "Flower02", scale = 0.1, y = -3.5, x =  0, z = -8, rotationX =   0, rotationZ =   0 } },
			{ instance{ model, model = "sphere", scale = 1, scaleX = 14, scaleZ = 14, y = -7, z = -6, uniforms_color = { 135/255, 203/255, 76/255, 1 } } },
		},
		{
			y = -4,
			{ instance{ model, layer = "radial-blur-2", fs = "black", model = "Flower02", scale = 0.1, y = -4, x =  0, z = -2, rotationX =  -5, rotationZ = -10 } },
			{ instance{ model, layer = "radial-blur-2", fs = "black", model = "Flower02", scale = 0.1, y = -5.2, x = -6, z = -3, rotationX =  -5, rotationZ = -10 } },
			{ instance{ model, layer = "radial-blur-2", fs = "black", model = "Flower02", scale = 0.1, y = -5.2, x =  6, z = -3, rotationX =  -5, rotationZ = -10 } },
			{ instance{ model, layer = "radial-blur-2", fs = "black", model = "Flower02", scale = 0.1, y = -4.0, x =  3, z = -6, rotationX = -25, rotationZ =   0 } },
			{ instance{ model, layer = "radial-blur-2", fs = "black", model = "Flower02", scale = 0.1, y = -4.0, x = -3, z = -6, rotationX =   0, rotationZ =   0 } },
			{ instance{ model, layer = "radial-blur-2", fs = "black", model = "Flower02", scale = 0.1, y = -3.5, x =  0, z = -8, rotationX =   0, rotationZ =   0 } },
			{ instance{ model, layer = "radial-blur-2", fs = "black", model = "sphere", scale = 1, scaleX = 14, scaleZ = 14, y = -7, z = -6, uniforms_color = { 135/255, 203/255, 76/255, 1 } } },
		},
		{ camera = { projection = "perspective", layer = "radial-blur-2", fov = 65, target = "effect3" }, z = 9 },
		{
			{ camera = { projection = "ortho", fit = "none", layer = "radial-blur-1", width = 512, height = 512, target = "effect1", clearTarget = true } },
			{ texture = "light", layer = "radial-blur-1", width = 32, height = 32, y = function() return lightPositionY() * 512 - 256 end, x = function() return lightPositionX() * 512 - 256 end, scale = 10 },
		},
		instance{ radialBlurStep, texture = "effect1", layer = "effect1", camera_layer = "effect1", camera_target = "effect2" },
		{ camera = { projection = "perspective", layer = "3d", fov = 65 }, z = 9 },
		{ 
			texture = "effect2",
			width = effectSize,
			height = effectSize,
			camera = { width = effectSize, height = effectSize, fit = "" }
		},
	}
}
]]

