local bgColor = { 1.0, 1.0, 1.0 }

_G.clearColor = { red = bgColor[1], green = bgColor[2], blue = bgColor[3] }
--_G.clearColor = { red = 0.0, green = 0.0, blue = 0.0 }

_G.time = 0

local particles = {
	particles = {
		sprites = { "Swallow-in-flight_1", "Swallow-in-flight_2", "Swallow-in-flight_3", "Swallow-in-flight_4" },
		frequency = 60,
		emit = function(self, index)
			local dir = math.random() * 3.141593 / 2
			local startOffsetX = math.random() * 100
			local startOffsetY = math.random() * 100
			local dist = math.random() * 200 + 1000
			local shouldComeCloser = false --math.random() < 0.02
			return {
				lifeTime = shouldComeCloser and 3 or 4,
				sprite = function(i) 
					local modifiedI = i * 40
					if math.floor(modifiedI / 4) % 2 == 0 then return modifiedI % 4 else return 4 - (modifiedI % 4) end 
				end,
				x = function(i) return math.log(i + 1) * dist + startOffsetX end,
				y = function(i) return i * 700 * math.sin(dir) + math.pow(i, 4) * 100 + startOffsetY end,
				scale = function(i) if shouldComeCloser then return 0.7 + i * 2 else return 0.7 - i * 0.7 + 0.1 end end,
				rotation = dir / 5,
			} 
		end,
	},
}


_G.world = {
	instance{particles, x = -500},
	{ camera = { } },
}