import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    id: vignette
    property string name: "vignette"
    effectName: "Vignette"
    enabled: sync(name+".ON")

    property real posX: 0.0
    property real posY: 0.0

    Blit {
        textureRT: "screenBuffer"
        blitRT: 0
    }
    Texture {
        textureUnit: 0
        textureRT: "screenBuffer"
        textureWrap: "clamp"
    }
    Shader {
        file: (sync(name+".realSpectrum") > 0.5) ? "vignetteReal" : "vignette"
        ShaderParam {
            paramName: "g_vignette"
            paramValue: sync(name+".strength")
        }

        ShaderParam {
            paramName: "g_vignetteRealSpecSpacing"
            paramValue: sync(name+".realSpecSpacing")+1.0
        }
        ShaderParam {
            paramName: "g_radius"
            paramValue: sync(name+".radius")
        }
        ShaderParam {
            paramName: "g_distortRadius"
            paramValue: sync(name+".distortRadius")
        }
        ShaderParam {
            paramName: "g_noise"
            paramValue: sync(name+".noise")
        }
        ShaderParam {
            paramName: "g_posX"
            paramValue: sync(name+".posX")+vignette.posX
        }
        ShaderParam {
            paramName: "g_posY"
            paramValue: sync(name+".posY")+vignette.posY
        }
        ShaderParam {
            paramName: "g_aspect"
            paramValue: sync(name+".aspect")
        }
        ShaderParam {
            paramName: "g_scale"
            paramValue: sync(name+".scale")
        }

        ShaderParam {
            paramName: "g_edgeChroma"
            paramValue: sync(name+".chroma")
        }
        ShaderParam {
            paramName: "g_edgeChromaHueFreq"
            paramValue: sync(name+".chroma.hueFreq")
        }
        ShaderParam {
            paramName: "g_edgeChromaHueOfs"
            paramValue: sync(name+".chroma.hueOfs")
        }
        ShaderParam {
            paramName: "g_specWeight"
            paramValue: sync(name+".chroma.specWeight")
        }
        ShaderParam {
            paramName: "g_origWeight"
            paramValue: sync(name+".chroma.origWeight")
        }

        ShaderParam {
            paramName: "g_edgeChromaClearRadius"
            paramValue: sync(name+".chroma.clearRad")
        }

        ShaderParam {
            paramName: "g_edgeChromaDistortX"
            paramValue: sync(name+".chroma.distX")
        }
        ShaderParam {
            paramName: "g_edgeChromaDistortY"
            paramValue: sync(name+".chroma.distY")
        }
        ShaderParam {
            paramName: "g_edgeChromaDistortOfsX"
            paramValue: sync(name+".chroma.distOfsX")
        }
        ShaderParam {
            paramName: "g_edgeChromaDistortOfsY"
            paramValue: sync(name+".chroma.distOfsY")
        }
        ShaderParam {
            paramName: "g_edgeChromaDistortFreqX"
            paramValue: sync(name+".chroma.distFreqX")
        }
        ShaderParam {
            paramName: "g_edgeChromaDistortFreqY"
            paramValue: sync(name+".chroma.distFreqY")
        }
        ShaderParam {
            paramName: "g_fadeOut"
            paramValue: sync(name+".fadeOut")
        }
    }
    DrawVB {
        type: "quad"
        depthTest: false
        depthWrite: false
    }
}
