import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    id: blur
    property string name: "glow"
    effectName: "BlurGlow"
    enabled: sync(name+".ON")
    property string shader: "blur"

    property real posX: 0.0
    property real posY: 0.0
    Texture {
        textureUnit: 0
        textureRT: "screenBuffer"
        textureWrap: "clamp"
    }
    Texture {
        textureUnit: 1
        textureRT: "depth"
    }

    Blit {
        textureRT: "screenBuffer"
        blitRT: 0
    }

    Shader {
        file: "fx/_SharedQML/glowThr"
    }

    DrawVB {
        ShaderParam {
            paramName: "flip"
            paramValue: 0.0
        }
        ShaderParam { paramName: "g_thr"; paramValue: sync(name+".threshold") }
        ShaderParam { paramName: "g_amp"; paramValue: sync(name+".amp") }
        ShaderParam { paramName: "g_pow"; paramValue: sync(name+".pow") }
        type: "quad"
        depthTest: false
        depthWrite: false
    }


    Blit {
        textureRT: "screenBuffer1"
        blitRT: 0
    }


    Repeater {
        model: sync(name+".blurLoops")
        delegate: Group {
            Blit {
                textureRT: "screenBuffer"
                blitRT: 0
            }
            Blit {
                textureRT: "screenBuffer"+index
                blitRT: 0
            }
            Shader {
                file: shader
                ShaderParam {
                    paramName: "g_blurStrength"
                    property real strengthAddPerLoop: sync(name+".strength.addPerLoop")
                    paramValue: sync(name+".strength")*(1.0+index*strengthAddPerLoop)
                }
            }
            DrawVB {
                type: "quad"
                depthTest: false
                depthWrite: false
                drawBuffers: 1
            }
        }
    }


//    Blit {
//        textureRT: "colorBuffer"
//    }
//    Texture {
//        textureUnit: 0
//        textureRT: "colorBuffer"
//    }
//    Texture {
//        textureUnit: 1
//        textureRT: "screenBuffer2"
//    }

//    Shader {
//        file: "fx/_SharedQML/overlayAdd"
//    }

//    DrawVB {
//        ShaderParam {
//            paramName: "flip"
//            paramValue: 0.0
//        }
//        ShaderParam {
//            paramName: "overlayAlpha"
//            paramValue: 0.25
//        }
//        ShaderParam {
//            paramName: "g_overlayScale"
//            paramValue: 1.0
//        }
//        ShaderParam {
//            paramName: "g_posX"
//            paramValue: 0.0
//        }
//        ShaderParam {
//            paramName: "g_posY"
//            paramValue: 0.0
//        }

//        type: "quad"
//        depthTest: false
//        depthWrite: false
//    }



}
