import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    id: blur
    property string name: "blur"
    effectName: "Blur"
    enabled: sync(name+".ON")
    property string shader: "blur"

    property string textureWrap: "clamp"

    property real posX: 0.0
    property real posY: 0.0

    Repeater {
        model: sync(name+".blurLoops")
        delegate: Group {
            Blit {
                textureRT: index===0 ? "screenBuffer" : "screenBuffer"
                blitRT: 0
            }
            Texture {
                textureUnit: 0
                textureRT: index===0 ? "screenBuffer" : "screenBuffer"
                textureWrap: blur.textureWrap
            }

            Shader {
                file: shader
                ShaderParam {
                    paramName: "g_blurStrength"
                    property real strengthAddPerLoop: sync(name+".strength.addPerLoop")
                    paramValue: sync(name+".strength")*(1.0+index*strengthAddPerLoop)
                }
                ShaderParam { paramName: "g_screenSize"; paramValue: sync(name+".screenSize") }
                ShaderParam { paramName: "g_readSize"; paramValue: index===0 ? 1.0 : sync(name+".screenSize") }
                // ShaderParam { paramName: "g_readSize"; paramValue: index===0 ? 1.0 : 1.0 }
            }
            DrawVB {
                type: "quad"
                depthTest: false
                depthWrite: false
                blendMode: "off"
                drawBuffers: 1
            }


        }
    }
    Blit {
        textureRT: "screenBuffer"
        blitRT: 0
    }

    // mix original and result
    Shader {
        file: "fx/_SharedQML/drawRt"
    }
    Texture {
        textureUnit: 0
        textureRT: "screenBuffer"
    }
    DrawVB {
        ShaderParam {
            paramName: "flip"
            paramValue: 0.0
        }
        ShaderParam {
            paramName: "overlayAlpha"
            paramValue: 1.0
        }
        ShaderParam {
            paramName: "g_origAmount"
            paramValue: 1.0
        }
        ShaderParam { paramName: "g_overlayScale"; paramValue: sync(name+".screenSize") }
        type: "quad"
        depthTest: false
        depthWrite: false
        blendMode: "off"
        drawBuffers: 1
    }


}
