import QtQuick 2.2
import QtQuick.Window 2.2

import AdaptDemoSystem 1.0

Scene {
    property string name: "skene"
    property string sceneName: ""
    property string sceneDir: "fx\\"+sceneName+"\\"
    property bool bSceneEnabled: sync("ON")

    onSetSceneName: {
        sceneName = sn;
        name = sn;
    }

    function getSceneDir() {
        return sceneDir
    }

    function sync(track) {
        if (sceneName == "") {
           // console.log("ERROR: specify \"sceneName\" for RocketScene");
            // not yet finished initializing the skenes...
            return 0.0;
        } else {
            return syncRocketRoot(sceneName+"."+track)
       //     return 1.0;
        }
    }

    sceneEnabled: bSceneEnabled
    enabled: bSceneEnabled
    visible: bSceneEnabled

}

