import QtQuick 2.3
import QtGraphicalEffects 1.0
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene {
    property bool bDebugTexts: true
    //property bool bDebugTexts: false

    Camera {
        property string name: "camera"
        x: sync(name + ".x")
        y: sync(name + ".y")
        z: sync(name + ".z")
        lookAtX: sync(name + ".lookAtX")
        lookAtY: sync(name + ".lookAtY")
        lookAtZ: sync(name + ".lookAtZ")
        upX: sync("camera.upX")
        upY: sync("camera.upY")
        upZ: sync("camera.upZ")
        yawLA: sync("camera.yawLA")
        pitchLA: sync("camera.pitchLA")
    }

    property real t: rocket.time
    Timer {
        interval: 5
        running: true
        repeat: true
        onTriggered: {
            t = rocket.time;
        }
    }

    property string shaderVaryings: "
            vec3 posG;
            vec2 uvG;
            vec3 velG;
            float ageG;
            float recG;
            float ageSplitG;
            vec4 posInitG;"



    TextureImage {
        textureUnit: 1
        file: "../../images/_SK57414_normal.png"
    }
    Texture {
        textureUnit: 2
        textureItem: kuvasEnv
        Image {
            id: kuvasEnv
            visible: false
            source: "../../images/area_lights.jpg"
        }
    }

    Texture {
        textureUnit: 3
        //file: "../../images/StarDust1.jpg"
        //file: "../../images/aalto.png"
        // file: "../../images/PinkMedusa.png"
        // textureRT: "prev"
        textureRT: "prev"
    }
    Texture {
        textureUnit: 4
        textureRT: "prevBlur"
        textureWrap: "repeat"
    }

    TextureImage {
        textureUnit: 0
        //file: "../../images/_SK57414.png"
        //file: (sync("bgTexture") === 0) ? "../../images/PinkMedusa.png" : "../../images/noiseb1.png"
        //file: "../../images/noiseb1.png"
        file: "../../images/kivitex1s.png"
    }
    Shader { file: "smLuola" }
    DrawMesh {
        Clear { cR: 0.0; cG: 0.0; cB: 0.0; }
        property string name: "mesh2"
        //  file: "mesh/Drill002.dae"
        file: "mesh/halli.obj"
        //file: "mesh/ball5000.x"
        //file: "mesh/400x400.obj"
        //file: "mesh/Cave.dae"
        Pos { x: 0.0; y: 0.0; z: 0.0; }
        //  Rot { d: 180; ax: 1.0; ay: 0.0; az: 0.0 }
        Sca { s: 4.50; x: 1.0; y: 1.0; z: 1.0 }
        ShaderParam { paramName: "g_uvScale"; paramValue: 1.0}
        ShaderParam { paramName: "g_texBrightness"; paramValue: 0.05 }
        ShaderParam { paramName: "g_prevAmount"; paramValue: 0.00 }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurFeed") }
        blendMode: "off"
        depthTest: true
        depthWrite: true
    }


    TextureImage {
        textureUnit: 0
        file: "../../images/_SK57414.png"
        //file: "../../images/noiseb1.png"
        //file: "../../images/kivitex1s.png"
    }
    Shader { file: "smPlastic" }
    DrawMesh {
      //  Clear { cR: 0.0; cG: 0.0; cB: 0.0; }
        property string name: "meshZoom"
        file: "mesh/puppet.dae"
        Pos { x: 0.0; y: 1.0; z: 0.0; }
        Rot { d: -90; ax: 1.0; ay: 0.0; az: 0.0 }
        Sca { s: 5.50; x: 1.0; y: 1.0; z: 1.0 }
        ShaderParam { paramName: "g_uvScale"; paramValue: 1.0}
        ShaderParam { paramName: "g_texBrightness"; paramValue: 0.0150 }
        ShaderParam { paramName: "g_prevAmount"; paramValue: 0.00 }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurFeed") }
        blendMode: "off"
        depthTest: true
        depthWrite: true

        SavePoint { target: "cen"; x: 0.0; y: 0.0; z: 0.0; }

    }



    Blit { // depth & normals for lights & reflections
        textureRT: "depth"
        blitRT: 1
    }

    /// From this point on, these "postprocs" should be pretty same for each skene,
    /// enabled from rocket if needed/used...

    Reflect { }
    Group {
        enabled: sync("prevBlurStore.ON")
        /// Previous frame blur feedback lights'n'magix
        Blit { textureRT: "prev" }
        Blur { enabled: sync("prevBlurStore.ON"); textureWrap: "clamp" }
        Blit { textureRT: "prevBlur" }
        Texture {
            textureUnit: 0
            textureRT: "prev"
        }
        Shader {
            file: "drawRt"
        }
        DrawVB {
            type: "quad"
            depthTest: false
            depthWrite: false
            ShaderParam {
                paramName: "flip"
                paramValue: 1.0
            }
            blendMode: "off"
        }

    }
    GodRay {
        godRayX: getSavePointX2D("cen")
        godRayY: getSavePointY2D("cen")
    }
    Tonemap { }
    Glow { }
    Vignette { }
    Shader { file: "smCoords" }
    Coords { }

    Item {
        visible: bDebugTexts
        enabled: bDebugTexts
        id: infoText
        layer.enabled: true
        width: 1280
        height: 720
        FastBlur {
            anchors.fill: texts
            source: texts
            radius: 32
        }
        Item {
            opacity: 1.0
            id: texts
            anchors.fill: parent
            Column {
                anchors.bottom: parent.bottom
                anchors.left: parent.left
                ShadowText {
                    id: particleCountText
                    text:"particleCount: 0"
                    // pixelSize: 32
                }
            }
        }
    }
    DrawRT {
        visible: bDebugTexts
        enabled: bDebugTexts
        textureItem: infoText
        flip: false
    }

}
