import QtQuick 2.3
import QtGraphicalEffects 1.0
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene {
    //property bool bDebugTexts: true
    property bool bDebugTexts: false

    Camera {
        property string name: "camera"
        x: sync(name + ".x")
        y: sync(name + ".y")
        z: sync(name + ".z")
        lookAtX: sync(name + ".lookAtX")
        lookAtY: sync(name + ".lookAtY")
        lookAtZ: sync(name + ".lookAtZ")
        upX: sync("camera.upX")
        upY: sync("camera.upY")
        upZ: sync("camera.upZ")
        yawLA: sync("camera.yawLA")
        pitchLA: sync("camera.pitchLA")
    }

    property real t: rocket.time
    Timer {
        interval: 5
        running: true
        repeat: true
        onTriggered: {
            t = rocket.time;
        }
    }

    property string shaderVaryings: "
            vec3 posG;
            vec2 uvG;
            vec3 velG;
            float ageG;
            float recG;
            float ageSplitG;
            vec4 posInitG;"



    TextureImage {
        textureUnit: 1
        file: "../../images/_SK57414_normal.png"
    }
    Texture {
        textureUnit: 2
        textureItem: kuvasEnv
        Image {
            id: kuvasEnv
            visible: false
            source: "../../images/area_lights.jpg"
        }
    }

    Texture {
        textureUnit: 3
        //file: "../../images/StarDust1.jpg"
        //file: "../../images/aalto.png"
        // file: "../../images/PinkMedusa.png"
        // textureRT: "prev"
        textureRT: "prev"
    }
    Texture {
        textureUnit: 4
        textureRT: "prevBlur"
        textureWrap: "repeat"
    }

    TextureImage {
        textureUnit: 0
        //file: "../../images/_SK57414.png"
        //file: (sync("bgTexture") === 0) ? "../../images/PinkMedusa.png" : "../../images/noiseb1.png"
       // file: "../../images/noiseb1.png"
        file: "../../images/meteor.png"
    }
    Shader { file: "smLuola" }
    DrawMesh {
        Clear { cR: 0.0; cG: 0.0; cB: 0.0; }
        property string name: "skullship"
        // file: "mesh/skullship6.lwo"
        file: "mesh/puppet_jump.dae"
        // file: "mesh/kolkkus.x"

        property real puppetHeilunta: sync("puppet.heilunta")

        Pos { x: 1.0; y: -3.0+sync("puppet.y"); z: -0.220+sync("puppet.z"); }
        Rot { d: 180+Math.sin(time()*0.62)*parent.puppetHeilunta; ax: 1.0; ay: 0.50; az: 0.0 }
        Rot { d: 0+Math.sin(time()*0.42)*parent.puppetHeilunta; ax: 1.0; ay: 1.50; az: 0.50 }
        Rot { d: 150.0+sync("puppet.rotX"); ax: 1.0; ay: 0.0; az: 0.0 }
        Rot { d: 40.0+sync("puppet.rotY"); ax: 0.0; ay: 1.0; az: 0.0 }
        Rot { d: 0.0+sync("puppet.rot"); ax: 0.0; ay: 0.0; az: 1.0 }
        Sca { s: 0.50; x: 1.0; y: 1.0; z: 1.0 }
        ShaderParam { paramName: "g_uvScale"; paramValue: 0.520}
        ShaderParam { paramName: "g_texBrightness"; paramValue: 0.005 }
        ShaderParam { paramName: "g_prevAmount"; paramValue: 0.025 }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurFeed") }
        ShaderParam { paramName: "g_genUv"; paramValue: 1.0 }
        blendMode: "add"
        depthTest: true
        depthWrite: true

        smoothNormals: true
        flipNormals: true
    }


    TextureImage {
        textureUnit: 0
        //file: "../../images/_SK57414.png"
        //file: (sync("bgTexture") === 0) ? "../../images/PinkMedusa.png" : "../../images/noiseb1.png"
        //file: "../../images/noiseb1.png"
        file: "../../images/meteor.png"
    }
    DrawMesh {
        //  Clear { cR: 0.0; cG: 0.0; cB: 0.0; }
        property string name: "skullship"
        file: "mesh/skullship6.lwo"
        // file: "mesh/puppet_jump.dae"

        property real heilunta: sync("skullship.heilunta")
        Pos { x: 0.0; y: sync("skullship.y"); z: 0.0; }
        Rot { d: 180+Math.sin(time()*0.62)*20.0*parent.heilunta; ax: 1.0; ay: 0.50; az: 0.0 }
        Rot { d: 0+Math.sin(time()*0.42)*15.0*parent.heilunta; ax: 1.0; ay: 1.50; az: 0.50 }
        Rot { d: 110.0; ax: 1.0; ay: 0.0; az: 0.0 }
        Rot { d: 40.0; ax: 0.0; ay: 1.0; az: 0.0 }
        Sca { s: 1.50; x: 1.0; y: 1.0; z: 1.0 }
        ShaderParam { paramName: "g_uvScale"; paramValue: 1.10}
        ShaderParam { paramName: "g_texBrightness"; paramValue: 0.005 }
        ShaderParam { paramName: "g_prevAmount"; paramValue: 0.005 }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurFeed") }
        ShaderParam { paramName: "g_genUv"; paramValue: 1.0 }
        blendMode: "add"
        depthTest: true
        depthWrite: true

        // smoothNormals: true
        flipNormals: true
    }


    TextureImage {
        textureUnit: 0
        //file: "../../images/dust2.png"
        file: "../../images/siniku5.png"
        //file: "../../images/noiseb1.png"
        //file: "../../images/kivitex1s.png"
    }
    TextureImage {
        textureUnit: 2
        //file: "../../images/dust2.png"
        //file: "../../images/noiseb1.png"
        //file: "../../images/pinkmedusa.png"
        file: "../../images/siniku4.png"
    }


    Shader { file: "smTunnel" }
    DrawMesh {
        //   Clear { cR: 0.0; cG: 0.0; cB: 0.0; }
        property string name: "meshZoom"
        //file: "mesh/tc.dae"
        file: "mesh/ball5000.x"
        Pos { x: 0.0; y: 1.0; z: 0.0; }
        Rot { d: 0; ax: 0.0; ay: 1.0; az: 0.0 }
        Sca { s: 9.0; x: 10.0; y: 100.0; z: 10.0 }
        ShaderParam { paramName: "g_uvScale"; paramValue: 0.5}
        ShaderParam { paramName: "g_texBrightness"; paramValue: 0.70 }
        ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: 0.1 }
        ShaderParam { paramName: "g_genUv"; paramValue: 1.0 }
        ShaderParam { paramName: "g_uvOfsY"; paramValue: time()*0.136346 }
        blendMode: "off"
        depthTest: true
        depthWrite: true

        cull: true
        cullBack: false
        flipNormals: true

        SavePoint { target: "cen"; x: 0.0; y: 0.0; z: 0.0; }

    }




    Group {
        property string name: "emitWaterPart"
        enabled: sync("waterPart.ON")

        RenderTarget {
            RenderTargetLayer {
                textureRT: "emittedPartPos"
                format: "RGBA16F"
                width: 1280*maxEmitLayers
                height: 720*maxEmitLayers
            }
        }
        ShaderAtomicCounter { property string name: "sac1"; clear: true }
        Texture { textureUnit: 0; imageUnit: 0; textureRT: "emittedPartPos" }
        Shader { file: sceneDir+"smEmitter" }

        TextureImage {
            textureUnit: 0
            file: "../../images/gas1.png"
        }
        DrawMesh {
            property string name: "mesh2"
            //file: "mesh/ball5000.x"
            file: "mesh/skullship6_emitter.lwo"
            //file: "mesh/cube.x"
            //file: "mesh/adaptlogo.obj"
            depthTest: true
            depthWrite: true
            blendMode: "off"

            // Shader params for particle emitting
            ShaderParam { paramName: "g_emitPercent"; paramValue: sync("waterPart.g_emitPercent"); }

            // Shader params for mesh surface
            ShaderParam { paramName: "g_uvScale"; paramValue: 0.20 }
            ShaderParam { paramName: "g_texBrightness"; paramValue: 0.0 }
            ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
            ShaderParam { paramName: "g_prevBlurAmount"; paramValue: 0.0 }

            //  property string num: index+1
            property real heilunta: sync("skullship.heilunta")
            Pos { x: 0.0; y: sync("skullship.y"); z: 0.0; }
            Rot { d: 180+Math.sin(time()*0.62)*20.0*parent.heilunta; ax: 1.0; ay: 0.50; az: 0.0 }
            Rot { d: 0+Math.sin(time()*0.42)*15.0*parent.heilunta; ax: 1.0; ay: 1.50; az: 0.50 }
            Rot { d: 110.0; ax: 1.0; ay: 0.0; az: 0.0 }
            Rot { d: 40.0; ax: 0.0; ay: 1.0; az: 0.0 }
            Sca { s: 1.50; x: 1.0; y: 1.0; z: 1.0 }
        }
    }

    ShaderAtomicCounter { property string name: "sac1" }
    Texture { textureUnit: 0; imageUnit: 0; textureRT: "emittedPartPos" }
    WaterPartikles { id: wp; name: "waterPart"; drawEnabled: sync(name+".drawEnabled") }

    property int totalParticleCount: wp.particleCount // + wp2.particleCount

    onTotalParticleCountChanged: {
        particleCountText.text = "particles: "+totalParticleCount
    }

    DustPartikles {
        id: dp
        name: "dustPart"
        // emitMesh: "mesh/ea_cube.obj"
        // emitMesh: "mesh/kolkkus.x"
        emitMesh: "mesh/poinzos2.lwo"
        drawBlendMode: "normal"
       // partTexture: "../../images/particles_64_2048.png"
        partTexture: "../../images/partik.png"
    }



    Blit { // depth & normals for lights & reflections
        textureRT: "depth"
        blitRT: 1
    }

    /// From this point on, these "postprocs" should be pretty same for each skene,
    /// enabled from rocket if needed/used...

    Reflect { }
    Group {
        enabled: sync("prevBlurStore.ON")
        /// Previous frame blur feedback lights'n'magix
        Blit { textureRT: "prev" }
        Blur { enabled: sync("prevBlurStore.ON"); textureWrap: "clamp" }
        Blit { textureRT: "prevBlur" }
        Texture {
            textureUnit: 0
            textureRT: "prev"
        }
        Shader {
            file: "drawRt"
        }
        DrawVB {
            type: "quad"
            depthTest: false
            depthWrite: false
            ShaderParam {
                paramName: "flip"
                paramValue: 1.0
            }
            blendMode: "off"
        }

    }
    GodRay {
        godRayX: getSavePointX2D("cen")
        godRayY: getSavePointY2D("cen")
    }
    Tonemap { }
    Glow { }
    Vignette { }

    Blit { textureRT: "frame_D_diver"; blitRT: 0; }

    DrawOverlayMul {
        property string name: "ovl_B_zoomering"
        enabled: sync(name+".ON")
        overlayScale: sync(name+".scale")
        overlayAlpha: sync(name+".alpha")
        posX: sync(name+".posX")
        posY: sync(name+".posY")
        textureRT: "frame_B_zoomering"
        flip: true
    }


    Shader { file: "smCoords" }
    Coords { }

    Item {
        visible: bDebugTexts
        enabled: bDebugTexts
        id: infoText
        layer.enabled: true
        width: 1280
        height: 720
        FastBlur {
            anchors.fill: texts
            source: texts
            radius: 32
        }
        Item {
            opacity: 1.0
            id: texts
            anchors.fill: parent
            Column {
                anchors.bottom: parent.bottom
                anchors.left: parent.left
                ShadowText {
                    id: particleCountText
                    text:"particleCount: 0"
                    // pixelSize: 32
                }
            }
        }
    }
    DrawRT {
        visible: bDebugTexts
        enabled: bDebugTexts
        textureItem: infoText
        flip: false
    }

}
