import QtQuick 2.3
import QtGraphicalEffects 1.0
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene {
    //property bool bDebugTexts: true
    property bool bDebugTexts: false

    Camera {
        property string name: "camera"
        x: sync(name + ".x")
        y: sync(name + ".y")
        z: sync(name + ".z")
        lookAtX: sync(name + ".lookAtX")
        lookAtY: sync(name + ".lookAtY")
        lookAtZ: sync(name + ".lookAtZ")
        upX: sync("camera.upX")
        upY: sync("camera.upY")
        upZ: sync("camera.upZ")
        yawLA: sync("camera.yawLA")
        pitchLA: sync("camera.pitchLA")
    }

    TextureImage {
        textureUnit: 1
        file: "../../images/_SK57414_normal.png"
    }
    Texture {
        textureUnit: 2
        textureItem: kuvasEnv
        Image {
            id: kuvasEnv
            visible: false
            source: "../../images/area_lights.jpg"
        }
    }

    Texture {
        textureUnit: 3
        //file: "../../images/StarDust1.jpg"
        //file: "../../images/aalto.png"
        // file: "../../images/PinkMedusa.png"
        // textureRT: "prev"
        textureRT: "prev"
    }
    Texture {
        textureUnit: 4
        textureRT: "prevBlur"
        textureWrap: "repeat"
    }

    TextureImage {
        textureUnit: 0
        //file: "../../images/_SK57414.png"
        //file: (sync("bgTexture") === 0) ? "../../images/PinkMedusa.png" : "../../images/noiseb1.png"
        file: "../../images/noiseb1.png"
        //file: "../../images/kivitex1s.png"
        //file: "../../images/gas1.png"
    }
    TextureImage {
        textureUnit: 1
        file: "../../images/lione3.png"
    }
    Shader { file: "smLuola" }
    DrawMesh {
        Clear { cR: 0.0; cG: 0.0; cB: 0.0; }
        property string name: "mesh2"
        //  file: "mesh/Drill002.dae"
        //file: "mesh/halli.obj"
        //file: "mesh/cube.x"
        //file: "mesh/lootikhe5.lwo"
        //file: "mesh/400x400.obj"
        file: "mesh/Cave.dae"
        Pos { x: 0.0; y: 0.0; z: 0.0; }
        Rot { d: -45; ax: 0.0; ay: 1.0; az: 0.0 }
        Sca { s: 80.00; }
        ShaderParam { paramName: "g_uvScale"; paramValue: 0.5}
        ShaderParam { paramName: "g_texBrightness"; paramValue: 0.2 }
        ShaderParam { paramName: "g_prevAmount"; paramValue: 0.00 }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: 0.02 }
        ShaderParam { paramName: "g_genUv"; paramValue: 1.0 }

        blendMode: "off"
        depthTest: true
        depthWrite: true

        SavePoint { target: "cen"; x: 4.0; y: -1.0; z: 8.0; }
    }

    TextureImage {
        textureUnit: 0
        //file: "../../images/_SK57414.png"
        //file: (sync("bgTexture") === 0) ? "../../images/PinkMedusa.png" : "../../images/noiseb1.png"
        //file: "../../images/noiseb1.png"
        //file: "../../images/kivitex1s.png"
        file: "../../images/meteor_b.png"
    }
    Shader { file: "smLuola" }
    DrawMesh {
      //  Clear { cR: 0.00; cG: 0.00; cB: 0.0; }
        property string name: "mesh2"
        //  file: "mesh/Drill002.dae"
        //file: "mesh/halli.obj"
        file: "mesh/cube.x"
        //file: "mesh/ball5000.x"
        //file: "mesh/400x400.obj"
        //file: "mesh/Cave.dae"

        smoothNormals: true
        flipNormals: false


        Pos { x: 0.0; y: -4.0; z: 0.0; }
        //  Rot { d: 180; ax: 1.0; ay: 0.0; az: 0.0 }
        Sca { s: 1.0; x: 200.0; y: 0.10; z: 200.0 }
        ShaderParam { paramName: "g_uvScale"; paramValue: 1.0}
        ShaderParam { paramName: "g_texBrightness"; paramValue: 0.002 }
        ShaderParam { paramName: "g_prevAmount"; paramValue: 0.00 }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: 0.0*sync("prevBlurFeed") }
        ShaderParam { paramName: "g_genUv"; paramValue: 0.0 }
        blendMode: "off"
        depthTest: true
        depthWrite: true
    }

    property string textOrigTexture: "../../images/noiseb1.png"
    property real textOrigUvScale: 0.0

//    property string surfCubeTex: "../../images/gas4.png"
    property string surfCubeTex: "../../images/PinkMedusa_black.png"
    property real surfCubeUvScale: 0.20

    Group {
        property string name: "deepr"
        enabled: sync(name+".ON")

        property string surfMesh: "box1m.lwo"
        property string font: "fonts/tech"

        CubeSurfer {
            posX: sync("deepr_de.posX")
            posY: sync("deepr_de.posY")
            posZ: sync("deepr_de.posZ")
            sca: sync("deepr_de.sca")
            surfMesh: parent.surfMesh
            origUvScale: textOrigUvScale; origGenUvs: 1.0; origTexture: textOrigTexture
            surfCubeUvSca: surfCubeUvScale; surfCubeTexture: surfCubeTex;

            mesh: parent.font+"_de.dae"
            rot: 90.0; cenX: 0.0; cenY: 0.0
            emitMeshScaleZ: 10.0; emitMeshScale: 0.30
            maxInstanceCount: 4000
        }

        CubeSurfer {
            posX: sync("deepr_e.posX")
            posY: sync("deepr_e.posY")
            posZ: sync("deepr_e.posZ")
            sca: sync("deepr_e.sca")
            surfMesh: parent.surfMesh
            origUvScale: textOrigUvScale; origGenUvs: 1.0; origTexture: textOrigTexture
            surfCubeUvSca: surfCubeUvScale; surfCubeTexture: surfCubeTex;

            mesh: parent.font+"_e.dae"
            rot: 90.0; cenX: 0.0; cenY: 0.0
            emitMeshScaleZ: 10.0; emitMeshScale: 0.30
        }

        CubeSurfer {
            posX: sync("deepr_pr.posX")
            posY: sync("deepr_pr.posY")
            posZ: sync("deepr_pr.posZ")
            sca: sync("deepr_pr.sca")
            surfMesh: parent.surfMesh
            origUvScale: textOrigUvScale; origGenUvs: 1.0; origTexture: textOrigTexture
            surfCubeUvSca: surfCubeUvScale; surfCubeTexture: surfCubeTex;

            mesh: parent.font+"_pr.dae"
            rot: 90.0; cenX: 0.0; cenY: 0.0
            emitMeshScaleZ: 10.0; emitMeshScale: 0.30
        }
    }

    Group {
        property string name: "mistral"
        enabled: sync(name+".ON")

        //property string surfMesh: "octa5.lwo"
        property string surfMesh: "box1m.lwo"
        property string font: "fonts/tech"

        CubeSurfer {
            posX: sync("mist_mis.posX")
            posY: sync("mist_mis.posY")
            posZ: sync("mist_mis.posZ")
            sca: sync("mist_mis.sca")
            surfMesh: parent.surfMesh
            origUvScale: textOrigUvScale; origGenUvs: 1.0; origTexture: textOrigTexture
            surfCubeUvSca: surfCubeUvScale; surfCubeTexture: surfCubeTex;

            mesh: parent.font+"_mis.dae"
            rot: 90.0; cenX: 0.0; cenY: 0.0
            maxInstanceCount: 4000
            emitMeshScaleZ: 10.0; emitMeshScale: 0.30
        }

        CubeSurfer {
            posX: sync("mist_t.posX")
            posY: sync("mist_t.posY")
            posZ: sync("mist_t.posZ")
            sca: sync("mist_t.sca")
            surfMesh: parent.surfMesh
            origUvScale: textOrigUvScale; origGenUvs: 1.0; origTexture: textOrigTexture
            surfCubeUvSca: surfCubeUvScale; surfCubeTexture: surfCubeTex;

            mesh: parent.font+"_t.dae"
            rot: 90.0; cenX: 0.0; cenY: 0.0
            maxInstanceCount: 2000
            emitMeshScaleZ: 10.0; emitMeshScale: 0.30
        }

        CubeSurfer {
            posX: sync("mist_ral.posX")
            posY: sync("mist_ral.posY")
            posZ: sync("mist_ral.posZ")
            sca: sync("mist_ral.sca")
            surfMesh: parent.surfMesh
            origUvScale: textOrigUvScale; origGenUvs: 1.0; origTexture: textOrigTexture
            surfCubeUvSca: surfCubeUvScale; surfCubeTexture: surfCubeTex;

            mesh: parent.font+"_ral.dae"
            rot: 90.0; cenX: 0.0; cenY: 0.0
            maxInstanceCount: 2000
           emitMeshScaleZ: 10.0; emitMeshScale: 0.30
        }
    }

    property string fontPath: "founzo\\"


    Group {
        property string name: "felor"
        enabled: sync(name+".ON")

        property string surfMesh: "box1m.lwo"
        property string font: "fonts/tech"

        CubeSurfer {
            posX: sync("felor_fe.posX")-0.0
            posY: sync("felor_fe.posY")
            posZ: sync("felor_fe.posZ")
            sca: sync("felor_fe.sca")
            surfMesh: parent.surfMesh
            origUvScale: textOrigUvScale; origGenUvs: 1.0; origTexture: textOrigTexture
            surfCubeUvSca: surfCubeUvScale; surfCubeTexture: surfCubeTex;

            mesh: parent.font+"_fe.dae"
            rot: 90.0; cenX: 0.0; cenY: 0.0
            maxInstanceCount: 2000
            emitMeshScaleZ: 10.0
            emitMeshScale: 0.30
        }

        CubeSurfer {
            posX: sync("felor_l.posX")
            posY: sync("felor_l.posY")
            posZ: sync("felor_l.posZ")
            sca: sync("felor_l.sca")
            surfMesh: parent.surfMesh
            origUvScale: textOrigUvScale; origGenUvs: 1.0; origTexture: textOrigTexture
            surfCubeUvSca: surfCubeUvScale; surfCubeTexture: surfCubeTex;

            mesh: parent.font+"_l.dae"
            rot: 90.0; cenX: 0.0; cenY: 0.0
            maxInstanceCount: 2000
            emitMeshScaleZ: 10.0
            emitMeshScale: 0.30
        }

        CubeSurfer {
            posX: sync("felor_or.posX")+0.0
            posY: sync("felor_or.posY")
            posZ: sync("felor_or.posZ")
            sca: sync("felor_or.sca")
            surfMesh: parent.surfMesh
            origUvScale: textOrigUvScale; origGenUvs: 1.0; origTexture: textOrigTexture
            surfCubeUvSca: surfCubeUvScale; surfCubeTexture: surfCubeTex;

            mesh: parent.font+"_or.dae"
            rot: 90.0; cenX: 0.0; cenY: 0.0
            maxInstanceCount: 2000
            emitMeshScaleZ: 10.0
            emitMeshScale: 0.30
        }
    }


    Group {
        property string name: "minomus"
        enabled: sync(name+".ON")

        property string surfMesh: "box1m.lwo"
        property string font: "fonts/tech"

        CubeSurfer {
            posX: sync("minomus_min.posX")-0.0
            posY: sync("minomus_min.posY")
            posZ: sync("minomus_min.posZ")
            sca: sync("minomus_min.sca")
            surfMesh: parent.surfMesh
            origUvScale: textOrigUvScale; origGenUvs: 1.0; origTexture: textOrigTexture
            surfCubeUvSca: surfCubeUvScale; surfCubeTexture: surfCubeTex;

            mesh: parent.font+"_min.dae"
            rot: 90.0; cenX: 0.0; cenY: 0.0
            maxInstanceCount: 4000
            emitMeshScaleZ: 10.0
            emitMeshScale: 0.30
        }

        CubeSurfer {
            posX: sync("minomus_o.posX")
            posY: sync("minomus_o.posY")
            posZ: sync("minomus_o.posZ")
            sca: sync("minomus_o.sca")
            surfMesh: parent.surfMesh
            mesh: parent.font+"_o.dae"
            rot: 90.0; cenX: 0.0; cenY: 0.0
            maxInstanceCount: 2000
            emitMeshScaleZ: 10.0
            emitMeshScale: 0.30
        }

        CubeSurfer {
            posX: sync("minomus_mus.posX")-0.0
            posY: sync("minomus_mus.posY")
            posZ: sync("minomus_mus.posZ")
            sca: sync("minomus_mus.sca")
            surfMesh: parent.surfMesh
            origUvScale: textOrigUvScale; origGenUvs: 1.0; origTexture: textOrigTexture
            surfCubeUvSca: surfCubeUvScale; surfCubeTexture: surfCubeTex;

            mesh: parent.font+"_mus.dae"
            rot: 90.0; cenX: 0.0; cenY: 0.0
            maxInstanceCount: 4000
            emitMeshScaleZ: 10.0
            emitMeshScale: 0.30
        }

    }

    Group {
        property string name: "legend"
        enabled: sync(name+".ON")

        property string surfMesh: "box1m.lwo"
        property string font: "fonts/tech"

        CubeSurfer {
            posX: sync("legend_le.posX")-0.0
            posY: sync("legend_le.posY")
            posZ: sync("legend_le.posZ")
            sca: sync("legend_le.sca")
            surfMesh: parent.surfMesh
            origUvScale: textOrigUvScale; origGenUvs: 1.0; origTexture: textOrigTexture
            surfCubeUvSca: surfCubeUvScale; surfCubeTexture: surfCubeTex;

            mesh: parent.font+"_le.dae"
            rot: 90.0; cenX: 0.0; cenY: 0.0
            maxInstanceCount: 2000
            emitMeshScaleZ: 10.0
            emitMeshScale: 0.30        }
        CubeSurfer {
            posX: sync("legend_ge.posX")-0.0
            posY: sync("legend_ge.posY")
            posZ: sync("legend_ge.posZ")
            sca: sync("legend_ge.sca")
            surfMesh: parent.surfMesh
            origUvScale: textOrigUvScale; origGenUvs: 1.0; origTexture: textOrigTexture
            surfCubeUvSca: surfCubeUvScale; surfCubeTexture: surfCubeTex;

            mesh: parent.font+"_ge.dae"
            rot: 90.0; cenX: 0.0; cenY: 0.0
            maxInstanceCount: 2000
            emitMeshScaleZ: 10.0
            emitMeshScale: 0.30
        }
        CubeSurfer {
            posX: sync("legend_nd.posX")-0.0
            posY: sync("legend_nd.posY")
            posZ: sync("legend_nd.posZ")
            sca: sync("legend_nd.sca")
            surfMesh: parent.surfMesh
            origUvScale: textOrigUvScale; origGenUvs: 1.0; origTexture: textOrigTexture
            surfCubeUvSca: surfCubeUvScale; surfCubeTexture: surfCubeTex;

            mesh: parent.font+"_nd.dae"
            rot: 90.0; cenX: 0.0; cenY: 0.0
            maxInstanceCount: 2000
            emitMeshScaleZ: 10.0
            emitMeshScale: 0.30        }
    }

    Group {
        property string name: "basscadet"
        enabled: sync(name+".ON")

        property string surfMesh: "box1m.lwo"
        property string font: "fonts/tech"

        CubeSurfer {
            posX: sync("basscadet_bass.posX")+0.0
            posY: sync("basscadet_bass.posY")
            posZ: sync("basscadet_bass.posZ")
            sca: sync("basscadet_bass.sca")
            surfMesh: parent.surfMesh
            origUvScale: textOrigUvScale; origGenUvs: 1.0; origTexture: textOrigTexture
            surfCubeUvSca: surfCubeUvScale; surfCubeTexture: surfCubeTex;

            mesh: parent.font+"_bass.dae"
            rot: 90.0; cenX: 0.0; cenY: 0.0
            maxInstanceCount: 6000
            emitMeshScaleZ: 10.0
            emitMeshScale: 0.30
        }

        CubeSurfer {
            posX: sync("basscadet_c.posX")+0.0
            posY: sync("basscadet_c.posY")
            posZ: sync("basscadet_c.posZ")
            sca: sync("basscadet_c.sca")
            surfMesh: parent.surfMesh
            origUvScale: textOrigUvScale; origGenUvs: 1.0; origTexture: textOrigTexture
            surfCubeUvSca: surfCubeUvScale; surfCubeTexture: surfCubeTex;

            mesh: parent.font+"_c.dae"
            rot: 90.0; cenX: 0.0; cenY: 0.0
            maxInstanceCount: 2000
            emitMeshScaleZ: 10.0
            emitMeshScale: 0.30
        }

        CubeSurfer {
            posX: sync("basscadet_adet.posX")+0.0
            posY: sync("basscadet_adet.posY")
            posZ: sync("basscadet_adet.posZ")
            sca: sync("basscadet_adet.sca")
            surfMesh: parent.surfMesh
            origUvScale: textOrigUvScale; origGenUvs: 1.0; origTexture: textOrigTexture
            surfCubeUvSca: surfCubeUvScale; surfCubeTexture: surfCubeTex;

            mesh: parent.font+"_adet.dae"
            rot: 90.0; cenX: 0.0; cenY: 0.0
            maxInstanceCount: 4000
            emitMeshScaleZ: 10.0
            emitMeshScale: 0.30
        }
    }


    Group {
        property string name: "adapt"
        enabled: sync(name+".ON")

        property string surfMesh: "adaptlogo.obj"

        CubeSurfer {
            posX: sync("adapt.posX")
            posY: sync("adapt.posY")
            posZ: sync("adapt.posZ")
            sca: sync("adapt.sca")
            mesh: "adaptlogo.obj"
            surfMesh: parent.surfMesh
            origUvScale: textOrigUvScale; origGenUvs: 1.0; origTexture: textOrigTexture
            surfCubeUvSca: surfCubeUvScale; surfCubeTexture: surfCubeTex;

            emitMeshScale: 0.3
            maxInstanceCount: 6000
        }
    }

//    Blit {
//        textureRT: "depth"; blitRT: 1;
//    }
//    BlurDepth {
//    }

    DustPartikles {
        id: dp
        name: "dustPart"
        emitMesh: "mesh/ea_cube.obj"
        // emitMesh: "mesh/kolkkus.x"
        //emitMesh: "mesh/poinzos2.lwo"
        drawBlendMode: "add"
        partTexture: "../../images/particles_64_2048.png"
       // partTexture: "../../images/partik.png"
    }


//    //// ABOUT default end definitions of each skene begin here ...


    Blit { // depth & normals for lights & reflections
        textureRT: "depth"
        blitRT: 1
    }

    /// From this point on, these "postprocs" should be pretty same for each skene,
    /// enabled from rocket if needed/used...

    Reflect { }
    Group {
        enabled: sync("prevBlurStore.ON")
        /// Previous frame blur feedback lights'n'magix
        Blit { textureRT: "prev" }
        Blur { enabled: sync("prevBlurStore.ON"); textureWrap: "clamp" }
        Blit { textureRT: "prevBlur" }
        Texture {
            textureUnit: 0
            textureRT: "prev"
        }
        Shader {
            file: "drawRt"
        }
        DrawVB {
            type: "quad"
            depthTest: false
            depthWrite: false
            ShaderParam {
                paramName: "flip"
                paramValue: 1.0
            }
            blendMode: "off"
        }

    }
    GodRay {
        godRayX: getSavePointX2D("cen")
        godRayY: getSavePointY2D("cen")
    }
    Tonemap { }
    Glow { }



    Vignette { }

    Blit { textureRT: "frame_C_crediz"; blitRT: 0; }


    DrawOverlayMul {
        property string name: "ovl_B_zoomering"
        enabled: sync(name+".ON")
        overlayScale: sync(name+".scale")
        overlayAlpha: sync(name+".alpha")
        posX: sync(name+".posX")
        posY: sync(name+".posY")
        textureRT: "frame_E_lightwaves"
        flip: true
    }



    Shader { file: "smCoords" }
    Coords { }

    Item {
        visible: bDebugTexts
        enabled: bDebugTexts
        id: infoText
        layer.enabled: true
        width: windowWidth
        height: windowHeight
        FastBlur {
            anchors.fill: texts
            source: texts
            radius: 32
        }
        Item {
            opacity: 1.0
            id: texts
            anchors.fill: parent
            Column {
                anchors.bottom: parent.bottom
                anchors.left: parent.left
               // width: particleCountText.width
                ShadowText {
                    ofsY: sync("endText.posY")
                    id: particleCountText
                    // wrapMode: Text.WordWrap
                    text:"
<center>
             :<br>
             :       A D A P T<br>
             :          -=-<br>
             :     Assembly 2016<br>
             :<br>
             .<br>
<br>

                                 \" liquiXion: the demo man \"<br>
<br><br>
      -=- deepr -=- mistral -=- felor -=-<br>-=- minomus -=- legend -=- basscadet -=-<br>
<bR>
     <b>adapt 10 years anniversary celebration</b><br><br>
          made using adapted GNU Rocket, OpenGL 4.3, QT/QML Scripting, love, rodeo and coffee.<br>
<br>
<b>Greetings</b><br>  Accession - Ananasmurska - Avaruus - Byterapers - Brainstorm - CNCD - Complex - Damones - DCS - Dekadence - DSS - Epoch - Evoflash - FIT - G-cluster - GIN - glxblt - HBC - Jac - JML - K2 - Kewlers - Ksylitol - Matt Current - MFX - NPLI - Odelay - Offence - OOBC - Optimus - Moomi - Parallax - Paraguay - Peisik - Pistoke - Pixheli - pksu - Portal Process - Prismbeings - promille deZign - Roisto - SQNY - Syntesthetics - Tekotuotanto - TPOLM - Traction - Bilotrip - Trilobit - TRSI - Twisted <br>And all we met at the Assembly and all we have unintentionally forgotten.<br>
<br>
Special love for our lovely wives, dogs, girls, cats and boys!!!<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
demos<br>
from adapt<br>
with love<br>
&lt;3<br>
<br>
2006-2016<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
adapt 2016 production<br><br>
<b>liquiXion: the demo man</b><br>
</center>
"
                    pixelSize: 36*(windowWidth/1280.0)
                }
            }
        }
    }
    DrawRT {
        visible: sync("endTexts.ON") > 0.5
        enabled: sync("endTexts.ON") > 0.5
        textureItem: infoText
        flip: false
    }


//    Item {
//    //    visible: sync("endTexts.ON") > 0.5
//    //    enabled: sync("endTexts.ON") > 0.5
//        id: endText
//        layer.enabled: true
//        width: 1280
//        height: 720
//        FastBlur {
//            anchors.fill: textsEnd
//            source: textsEnd
//            radius: 32
//        }
//        Item {
//            opacity: 1.0
//            id: textsEnd
//            anchors.fill: parent
//            Column {
//                anchors.bottom: parent.bottom
//                anchors.left: parent.left
//                ShadowText {
//                    id: endScrollText
//                    ofsY: sync("endText.posY")
//                    property string text:"jorma"
//                    property string textJJ:"
//                           _   ___o_
//                                  :/// /
//                                  :
//                         ________ :         ________        ___________
//                       __\___   /_: _____ __\___   /_ ______\  _   _  /
//                      /     _    /__\__  \     _    /_\_    /__/   /__\
//                     /      /  _/     /   \    /  _/   /     //   /
//            -- ------\_________\     /    /_______\   /_____//____\-tR!------>
//                              /__________/      /______\
//                                  .
//                                  :
//                                  :       A D A P T
//                                  :          -=-
//                                  :     Assembly 2016
//                                  :
//                                  .

//                                        \" liquiXion: the demo man \"

//             -=- deepr -=- mistral -=- felor -=- minomus -=- legend -=- basscadet -=-

//            You have seen the special <b>adapt 10 years</b> anniversary celebration demo.

//                 Using Adapted GNU Rocket, (Kusma, deepr will send you teh mods!)
//                                 OpenGL 4.3, QT/QML Scripting.



//Greetings to: Accession - Ananasmurska - Avaruus - Byterapers - Brainstorm - CNCD - Complex - Damones - DCS - Dekadence - DSS - FIT - G-Cluster - GIN - HBC - JML - K2 - Kewlers - Ksylitol - Matt Current - MFX - NPLI - Odelay - Parallax - Paraguay - Peisik - Pixheli - pksu - Portal Process - promille deZign - Roisto - SQNY - Syntesthetics - TPOLM - Traction - Bilotrip - Trilobit - TRSI - Twisted - And all we met at the Assembly and all we have forgotten.

//                 Special love for our lovely wives, dogs, girls, cats and boys!!!

//                 Onx kaikki hyvin? näkyyks peruukki?



//"
//                    //pixelSize: 44
//                }
//            }
//        }
//    }
//    DrawRT {
//        visible: sync("endTexts.ON") > 0.5
//        enabled: sync("endTexts.ON") > 0.5
//        textureItem: endText
//        flip: false
//    }


}
