import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0


Group {
    id: waterPartikles
    property string name: "waterPart"
    property string forceName: "waterForce"
    property int particleCount: 0
    property bool drawEnabled: true

    property int maxParticles: 500*500
    property int drawParticles: 10

    enabled: sync(name+".ON")

    Blit {
        enabled: drawEnabled
        textureRT: "bg"
        blitRT: 0
    }

    PartSim {
        name: waterPartikles.name
        forceName: waterPartikles.forceName
        simShader: "simPart"
        //drawShader: "partBalls"
        //drawBlendMode: "off"
        drawEnabled: waterPartikles.drawEnabled
        drawShader: "partWater"
        drawBlendMode: "add"

        onParticleCountChanged: {
            waterPartikles.particleCount = particleCount;
        }

        // max particles count is gridDimension*gridDimension
        // CHANGE PROPOSAL: make a new parameter maxPoints instead...
        gridDimension: Math.sqrt(maxParticles)

        // This is actually the number of points drawn for the first frame
        // of the simulation (or when reset).
        // As after that, the simulation will continue with own number of particles
        // as some particles might die and others might emit new ones...
        // CHANGE PROPOSAL: because of the above explanation, change this variable name to
        // initNumPoints instead ...
        drawNumPoints: drawParticles

        partSize: sync(name+".partSize")
        //  partEmitShapeImage: "../../images/black.png"
        //partEmitShapeImage: "../../images/PinkMedusa.png"
    }

    Group {
        enabled: waterPartikles.drawEnabled
        Blit {
            textureRT: "prevFrame"
        }
        Blit {
            textureRT: "prevFrame2"
            blitRT: 1
        }
        Texture {
            textureUnit: 0
            textureRT: "prevFrame"
        }
        Texture {
            textureUnit: 1
            textureRT: "bg"
            //textureRT: "depth"
        }
        Texture {
            textureUnit: 2
            textureRT: "prevFrame2"
        }
        Shader {
            //file: sceneDir+"mixBalls"
            file: sceneDir+"mixWater"
        }
        DrawVB {
            ShaderParam {
                paramName: "flip"
                paramValue: 0.0
            }
            ShaderParam {
                paramName: "g_bgAmount"; paramValue: sync(waterPartikles.name+".bgAmount")
            }
            ShaderParam {
                paramName: "g_lightAmount"; paramValue: sync(waterPartikles.name+".lightAmount")
            }
            ShaderParam {
                paramName: "g_waterClip"; paramValue: sync(waterPartikles.name+".waterClip")
            }
            ShaderParam {
                paramName: "g_bumpStrength"; paramValue: sync(waterPartikles.name+".bumpStrength")
            }
            type: "quad"
            depthTest: false
            depthWrite: false
            drawBuffers: 2
        }
    }
}

