import QtQuick 2.3
import QtGraphicalEffects 1.0
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene {
    //property bool bDebugTexts: true
    property bool bDebugTexts: false

    Camera {
        property string name: "camera"
        x: sync(name + ".x")
        y: sync(name + ".y")
        z: sync(name + ".z")
        lookAtX: sync(name + ".lookAtX")
        lookAtY: sync(name + ".lookAtY")
        lookAtZ: sync(name + ".lookAtZ")
        upX: sync("camera.upX")
        upY: sync("camera.upY")
        upZ: sync("camera.upZ")
        yawLA: sync("camera.yawLA")
        pitchLA: sync("camera.pitchLA")
    }

    property real t: rocket.time
    Timer {
        interval: 5
        running: true
        repeat: true
        onTriggered: {
            t = rocket.time;
        }
    }

    property string shaderVaryings: "
            vec3 posG;
            vec2 uvG;
            vec3 velG;
            float ageG;
            float recG;
            float ageSplitG;
            vec4 posInitG;"

    TextureImage {
        textureUnit: 1
        file: "../../images/_SK57414_normal.png"
    }
    Texture {
        textureUnit: 2
        textureItem: kuvasEnv
        Image {
            id: kuvasEnv
            visible: false
            source: "../../images/area_lights.jpg"
        }
    }

    Texture {
        textureUnit: 3
        //file: "../../images/StarDust1.jpg"
        //file: "../../images/aalto.png"
        // file: "../../images/PinkMedusa.png"
        // textureRT: "prev"
        textureRT: "prev"
    }
    Texture {
        textureUnit: 4
        textureRT: "prevBlur"
        textureWrap: "repeat"
    }



    Shader { file: "smLuola" }
    //    Shader { file: "smCubeSurfEmit" }
    //  ShaderAtomicCounter { property string name: "sacCubes"; clear: false }
    //  Texture { textureUnit: 0; imageUnit: 0; textureRT: "emittedCubesPos" }

//    TextureImage {
//        textureUnit: 0
//        //file: "../../images/_SK57414.png"
//        file: (sync("bgTexture") === 0) ? "../../images/PinkMedusa.png" : "../../images/noiseb1.png"
//        //file: "../../images/noiseb1.png"
//        //file: "../../images/kivitex1s.png"
//    }

    TextureImage {
        enabled: sync("bgTexture") === 0
        textureUnit: 0
        //file: "../../images/_SK57414.png"
        file: "../../images/PinkMedusa_black.png"
        //file: "../../images/noiseb1.png"
        //file: "../../images/kivitex1s.png"
    }

    TextureImage {
        enabled: sync("bgTexture") === 1
        textureUnit: 0
        file: "../../images/noiseb1.png"
    }

    DrawMesh {
        Clear { cR: 0.0; cG: 0.0; cB: 0.0; }
        property string name: "mesh2"
        //  file: "mesh/Drill002.dae"
        //file: "mesh/halli.obj"
        //file: "mesh/ball5000.x"
        //file: "mesh/400x400.obj"
        file: "mesh/Cave.dae"
        Pos { x: 0.0; y: 0.0; z: 0.0; }
        //  Rot { d: 180; ax: 1.0; ay: 0.0; az: 0.0 }
        Sca { s: 2.50; x: 1.0; y: 1.0; z: 1.0 }
        ShaderParam { paramName: "g_uvScale"; paramValue: 0.10}
        ShaderParam { paramName: "g_texBrightness"; paramValue: 0.50 }
        ShaderParam { paramName: "g_prevAmount"; paramValue: 0.020 }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurFeed") }
        blendMode: "off"
        depthTest: true
        depthWrite: true
    }




    // Begin draw pixel emitters
    property int maxEmitLayers: 2

    property real surfEmitDiv: Math.max(sync("surfEmit.div"), 1.0)
    property real surfEmitDiv2: Math.max(sync("surfEmit.div2"), 1.0)


    Group {
        property string name: "surfCubesInst"
        enabled: sync(name+".ON")

        RenderTarget {
            RenderTargetLayer {
                textureRT: "emittedCubesPos"
                format: "RGBA16F"
                width: 1280*maxEmitLayers
                height: 720*maxEmitLayers
            }
        }
        RenderTarget {
            RenderTargetLayer {
                textureRT: "emittedCubesNormal"
                format: "RGBA16F"
                width: 1280*maxEmitLayers
                height: 720*maxEmitLayers
            }
        }
        RenderTarget {
            RenderTargetLayer {
                textureRT: "emittedCubesVar" // size, etc..
                format: "RGBA16F"
                width: 1280*maxEmitLayers
                height: 720*maxEmitLayers
            }
        }

        ShaderAtomicCounter { property string name: "sacCubes"; clear: true }
        Texture { textureUnit: 0; imageUnit: 0; textureRT: "emittedCubesPos" }
        Texture { textureUnit: 0; imageUnit: 1; textureRT: "emittedCubesNormal" }
        Texture { textureUnit: 0; imageUnit: 2; textureRT: "emittedCubesVar" }
        TextureImage {
            textureUnit: 0
            file: "../../images/aalto.png"
            //file: "../../images/kivitex1s.png"
            //file: "../../images/zeppo.png"
        }
        Shader { file: sceneDir+"smCubeSurfEmit" }

        DrawMesh {
            // Clear { cR: 0.0; cG: 0.0; cB: 0.0 }
            property string name: "mesh2"
            //file: "mesh/cube.x"
            file: "mesh/tc.dae"
            //  file: "mesh/ball5000.x"
            //file: "mesh/hand1b.x"
            //file: "mesh/kolkkus.x"
            //file: "mesh/aivob.x"
            // file: "mesh/pillarman.obj"
            //file: "mesh/Drill002.dae"
            //file: "mesh/ah1.x"
            // file: "mesh/seitti2.x"
            //  file: "mesh/lootikhe2.lwo"
            // file: "mesh/adaptlogo.obj"
            //file: "mesh/LowPolyPallo.lwo"

//            smoothNormals: false
//            flipNormals: true


            depthTest: true
            depthWrite: true
            blendMode: "off"

            ShaderParam { paramName: "g_uvScale"; paramValue: 0.50 }
            ShaderParam { paramName: "g_texBrightness"; paramValue: sync("surfEmit.texBright") }
            ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
            ShaderParam { paramName: "g_prevBlurAmount"; paramValue: 0.70 }
            ShaderParam { paramName: "g_cubesDiv"; paramValue: surfEmitDiv }
            ShaderParam { paramName: "g_spread"; paramValue: sync("surfEmit.spread") }
            ShaderParam { paramName: "g_worldPos"; paramValue: 1.0 }
            ShaderParam { paramName: "g_drawSurf"; paramValue: sync("surfEmit.drawSurf") }
            ShaderParam { paramName: "g_stretch"; paramValue: sync("surfEmit.surfStretch") }



            Pos { x: 2.0; y: 1.50; z: -1.50; }
            Rot { d: 90; ax: 0.0; ay: 1.0; az: 0.0 }
            Rot { d: time()*0.0+130; ax: 1.0; ay: 0.0; az: 0.0 }
            Rot { d: sync("surfEmit.rotY"); ax: 0.0; ay: 1.0; az: 0.0 }
            Sca { s: 15.0; x: 1.0; y: 1.0; z: 1.0 }

            SavePoint {
                target: "cen"
                x: 0.0; y: 0.0; z: 0.0;
            }


        }

        //        RenderTarget {
        //            RenderTargetLayer {
        //                textureRT: "emittedCubesPos2"
        //                format: "RGBA16F"
        //                width: 1280*maxEmitLayers
        //                height: 720*maxEmitLayers
        //            }
        //        }
        //        RenderTarget {
        //            RenderTargetLayer {
        //                textureRT: "emittedCubesNormal2"
        //                format: "RGBA16F"
        //                width: 1280*maxEmitLayers
        //                height: 720*maxEmitLayers
        //            }
        //        }
        //        RenderTarget {
        //            RenderTargetLayer {
        //                textureRT: "emittedCubesVar2"
        //                format: "RGBA16F"
        //                width: 1280*maxEmitLayers
        //                height: 720*maxEmitLayers
        //            }
        //        }

        //        Texture { textureUnit: 0; imageUnit: 0; textureRT: "emittedCubesPos" }
        //        Texture { textureUnit: 0; imageUnit: 1; textureRT: "emittedCubesNormal" }
        //        Texture { textureUnit: 0; imageUnit: 2; textureRT: "emittedCubesVar" }

        //        Texture { textureUnit: 0; imageUnit: 3; textureRT: "emittedCubesPos2" }
        //        Texture { textureUnit: 0; imageUnit: 4; textureRT: "emittedCubesNormal2" }
        //        Texture { textureUnit: 0; imageUnit: 5; textureRT: "emittedCubesVar2" }

        ShaderAtomicCounter { property string name: "sacCubes"; clear: false }
        ShaderAtomicCounter { property string name: "sacCubes2"; clear: true; bind: 1 }
        Shader { file: sceneDir+"smSurfInst" }
        TextureImage {
            textureUnit: 0
            file: "../../images/aalto.png"
            //file: "../../images/kivitex1s.png"
            //file: "../../images/lione3.png"
        }
        // Texture { textureUnit: 0; imageUnit: 0; textureRT: "emittedPartPos" }
        DrawMesh {
            enabled: sync("surfEmit.size") > 0.0
            property string name: "mesh333"
            //file: "mesh/cube.x"
            //file: "mesh/ball5000.x"
            // file: "mesh/kolkkus.x"
            //file: "mesh/aivob.x"
            //file: "mesh/seitti.x"
            //file: "mesh/hand1b.x"
            //file: "mesh/pillarman.obj"
            //file: "mesh/lootikhe2.lwo"
            file: "mesh/box1m.lwo"
            //file: "mesh/rinkula.obj"
            //file: "mesh/LowPolyPallo.lwo"
            depthTest: true
            depthWrite: true
            blendMode: "normal"
            instanceVBO: sceneName+wp.name
            instanceCount: 6000
            tfVaryings: shaderVaryings

            ShaderParam { paramName: "g_uvScale"; paramValue: 0.070 }
            ShaderParam { paramName: "g_texBrightness"; paramValue: 0.20 }
            ShaderParam { paramName: "g_emitNew"; paramValue: 1.0 }
            ShaderParam { paramName: "g_instLayer"; paramValue: 0.0 }
            ShaderParam { paramName: "g_worldPos"; paramValue: 1.0 }

            ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
            ShaderParam { paramName: "g_prevBlurAmount"; paramValue: 1.0 }

            ShaderParam { paramName: "g_spread"; paramValue: sync("surfEmit.spread2") }
            ShaderParam { paramName: "g_cubesDiv"; paramValue: surfEmitDiv2 }

            property real surfEmitSpread: sync("surfEmit.spread")

            Pos { x: 0.0; y: 0.0; z: 0.0; }
            // Sca { s: 0.50; x: 5.0; y: 5.0; z: 0.3 }
            //Sca { s: 1.0*surfEmitDiv/12.0; }
            //Sca { s: 0.50*surfEmitDiv/12.0*(1.0/(parent.surfEmitSpread*0.01+0.50)); x: 0.50; y: 0.50; z: 27.05;}
            Sca { s: sync("surfEmit.size")*surfEmitDiv/12.0*(1.0/(parent.surfEmitSpread*0.01+0.50)); x: 0.50; y: 0.50; z: 0.5;}
            // Rot { d: 0.0; ax: 0.0; ay: 1.0; az: 0.0 }
        }

        //        // 2nd set of cubes over the first ones
        //            Texture { textureUnit: 0; imageUnit: 0; textureRT: "emittedCubesPos" }
        //            Texture { textureUnit: 0; imageUnit: 1; textureRT: "emittedCubesNormal" }
        //            Texture { textureUnit: 0; imageUnit: 2; textureRT: "emittedCubesVar" }
        //            ShaderAtomicCounter { property string name: "sacCubes2"; clear: false; bind: 0 }
        //            Shader { file: sceneDir+"smSurfInst" }
        //            TextureImage {
        //                textureUnit: 0
        //                //file: "../../images/aalto.png"
        //                file: "../../images/kivitex1s.png"
        //                //file: "../../images/PinkMedusaB.png"
        //            }
        //            // Texture { textureUnit: 0; imageUnit: 0; textureRT: "emittedPartPos" }
        //            DrawMesh {
        //                //property string name: "mesh444"
        //                //file: "mesh/cube.x"
        //                //file: "mesh/ball5000.x"
        //                //file: "mesh/kolkkus.x"
        //                //file: "mesh/aivob.x"
        //                //file: "mesh/seitti.x"
        //                //file: "mesh/hand1b.x"
        //                //file: "mesh/pillarman.obj"
        //                //file: "mesh/lootikhe2.lwo"
        //             //   file: "mesh/box1m.lwo"
        //                file: "mesh/rinkula.obj"
        //                depthTest: true
        //                depthWrite: true
        //                blendMode: "normal"
        //                instanceVBO: sceneName+wp.name
        //                instanceCount: 16000
        //                tfVaryings: shaderVaryings

        //                ShaderParam { paramName: "g_uvScale"; paramValue: 0.020 }
        //                ShaderParam { paramName: "g_texBrightness"; paramValue: 0.20 }
        //                ShaderParam { paramName: "g_emitNew"; paramValue: 0.0 }
        //                ShaderParam { paramName: "g_instLayer"; paramValue: 1.0 }

        //                ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
        //                ShaderParam { paramName: "g_prevBlurAmount"; paramValue: 0.70 }


        //                 Pos { x: 0.0; y: 0.0; z: -9.0; }
        //                //Sca { s: 0.250; x: 2.0; y: 1.0; z: 1.0 }
        //                Sca { s: 0.50; x: 1.0; y: 1.0; z: 64.0 }
        //                // Rot { d: 0.0; ax: 0.0; ay: 1.0; az: 0.0 }
        //            }


    }







    property real cornerBallsSize: 0.05;

    Group {
        property string name: "emitWaterPart"
        enabled: sync("waterPart.ON")

        RenderTarget {
            RenderTargetLayer {
                textureRT: "emittedPartPos"
                format: "RGBA16F"
                width: 1280*maxEmitLayers
                height: 720*maxEmitLayers
            }
        }
        ShaderAtomicCounter { property string name: "sac1"; clear: true }
        Texture { textureUnit: 0; imageUnit: 0; textureRT: "emittedPartPos" }
        Shader { file: sceneDir+"smEmitter" }

        TextureImage {
            textureUnit: 0
            file: "../../images/gas1.png"
        }
        DrawMesh {
            property string name: "mesh2"
            //file: "mesh/ball5000.x"
            file: "mesh/kolkkus.x"
            //file: "mesh/cube.x"
            //file: "mesh/adaptlogo.obj"
            depthTest: true
            depthWrite: true
            blendMode: "off"

            // Shader params for particle emitting
            ShaderParam { paramName: "g_emitPercent"; paramValue: sync("waterPart.g_emitPercent"); }

            // Shader params for mesh surface
            ShaderParam { paramName: "g_uvScale"; paramValue: 0.20 }
            ShaderParam { paramName: "g_texBrightness"; paramValue: 0.0 }
            ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
            ShaderParam { paramName: "g_prevBlurAmount"; paramValue: 0.0 }

            //  property string num: index+1
            Pos { x: 2.0; y: 6.0; z: 0.50; }
            Rot { d: 0.0; ax: 1.0; ay: 0.0; az: 0.0 }
            Sca { s: sync("waterPart.g_emitterSize"); x: 1.0; y: 1.0; z: 1.0 }
        }

        Shader { file: sceneDir+"smPlastic" }
        TextureImage {
            textureUnit: 0
            //file: "../../images/_SK57414.png"
            //file: "../../images/PinkMedusa.png"
            //file: "../../images/noiseb1.png"
            //file: "../../images/kivitex1s.png"
            file: "../../images/gas1.png"
        }

        TextureImage {
            textureUnit: 2
            //file: "../../images/_SK57414.png"
            //file: "../../images/PinkMedusa.png"
            //file: "../../images/noiseb1.png"
            //file: "../../images/kivitex1s.png"
            //file: "../../images/prismainsideA-7.jpg"
            file: "../../images/aalto.png"
        }

        Texture {
            textureUnit: 3
            //file: "../../images/StarDust1.jpg"
            //file: "../../images/aalto.png"
            // file: "../../images/PinkMedusa.png"
            // textureRT: "prev"
            textureRT: "prev"
        }
        Texture {
            textureUnit: 4
            textureRT: "prevBlur"
            textureWrap: "repeat"
        }

        DrawMesh {
           // enabled: false
            property string name: "mesh2"
            //  file: "mesh/Drill002.dae"
            // file: "mesh/halli.obj"
            file: "mesh/ball5000.x"
            //file: "mesh/400x400.obj"
            //file: "mesh/Cave.dae"
            Pos { x: 2.0; y: 6.0; z: 0.50; }
            //  Rot { d: 180; ax: 1.0; ay: 0.0; az: 0.0 }
            Sca { s: 3.50*(1.0+sync("whiteBall.scaleMul")); x: 1.0; y: 1.0; z: 1.0 }
            ShaderParam { paramName: "g_uvScale"; paramValue: 0.50}
            ShaderParam { paramName: "g_texBrightness"; paramValue: 0.002+sync("whiteBall.texBright") }
            ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
            ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurFeed") }
            ShaderParam { paramName: "g_writeCollisionDepth"; paramValue: 0.0 }
            blendMode: "normal"
            depthTest: true
            depthWrite: true
        }
    }

    property int totalParticleCount: wp.particleCount // + wp2.particleCount

    onTotalParticleCountChanged: {
        particleCountText.text = "particles: "+totalParticleCount
    }

    /// Deferred instanced light draw starts here
    Blit { textureRT: "depth"; blitRT: 1; }
    Blit { textureRT: "pos"; blitRT: 2; }

    Texture { textureUnit: 0; textureRT: "color" }
    Texture { textureUnit: 1; textureRT: "depth" }
    Texture { textureUnit: 2; textureRT: "pos" }
    Shader { file: "smDeferredInst" }
    DrawMesh {
        enabled: sync("defLights.ON");
        property string name: "lightMesh"
        //file: "mesh/cube.x"
        file: "mesh/LowPolyPallo.lwo"
        //file: "mesh/kolkkus.x"
        //file: "mesh/aivob.x"
        //file: "mesh/rinkula.obj"
        //file: "mesh/seitti.x"
        //file: "mesh/hand1b.x"
        //file: "mesh/pillarman.obj"
        depthTest: false
        depthWrite: false
        blendMode: "add"
        instanceVBO: sceneName+wp.name
        instanceCount: totalParticleCount
        tfVaryings: shaderVaryings
        cull: true
        cullBack: false
        drawBuffers: 1 // draw only to the primary color buffer
        Pos { x: 0.0; y: 0.0; z: 0.0; }
        Sca { s: 1.0; }
    }

    //  Blit { textureRT: "depth"; blitRT: 1; }


    ShaderAtomicCounter { property string name: "sac1" }
    Texture { textureUnit: 0; imageUnit: 0; textureRT: "emittedPartPos" }
    WaterPartikles { id: wp; name: "waterPart"; drawEnabled: sync(name+".drawEnabled") }


    Blit { textureRT: "depth"; blitRT: 1; }


    //    ShaderAtomicCounter { property string name: "sac2" }
    //    Texture { textureUnit: 0; imageUnit: 0; textureRT: "emittedPartPos2" }
    //    WaterPartikles { id: wp2; name: "waterPart2"; }

    //    // Deformes shaders begin
    //        Texture {
    //            textureUnit: 3
    //            textureRT: "bg"
    //        }
    //        Texture {
    //            textureUnit: 4
    //            textureRT: "depth"
    //        }
            BlurDepth {
            }
    //        TextureImage {
    //            textureUnit: 0
    //            // file: "../../images/kivitex1s.png"
    //            //file: "../../images/PinkMedusa.png"
    //            //file: "../../images/aalto.png"
    //            //file: "../../images/huntualpha1.png"
    //            //file: "../../images/noisep1s.png"
    //            //file: "../../images/dust2.png"
    //            //file: "../../images/apoks.png"
    //            file: "../../images/m/apo7.png"
    //            //file: "../../images/m/bok.png"
    //        }

    //        Shader { file: "smPlasticInst" }
    //       // Texture { textureUnit: 0; imageUnit: 0; textureRT: "emittedPartPos" }
    //        DrawMesh {
    //            property string name: "mesh333"
    //            //file: "mesh/cube.x"
    //            file: "mesh/ball5000.x"
    //            //file: "mesh/kolkkus.x"
    //            //file: "mesh/aivob.x"
    //            //file: "mesh/rinkula.obj"
    //            //file: "mesh/seitti.x"
    //            //file: "mesh/hand1b.x"
    //            //file: "mesh/pillarman.obj"
    //            depthTest: true
    //            depthWrite: false
    //            blendMode: "add"
    //            instanceVBO: sceneName+wp.name
    //            instanceCount: 100
    //            tfVaryings: shaderVaryings

    //            ShaderParam { paramName: "g_uvScale"; paramValue: 1.0 }
    //            ShaderParam { paramName: "g_texBrightness"; paramValue: 1.10 }
    //            // Pos { x: 0.0; y: 0.0; z: 0.0; }
    //            Sca { s: 1.50; }
    //            // Rot { d: 0.0; ax: 0.0; ay: 1.0; az: 0.0 }
    //        }



    //    Shader { file: "smDeform" }
    //    TextureImage {
    //        textureUnit: 0
    //        // file: "../../images/kivitex1s.png"
    //        //  file: "../../images/PinkMedusa.png"
    //        file: "../../images/aalto.png"
    //        //file: "../../images/huntualpha1.png"
    //        //file: "../../images/noisep1s.png"
    //    }
    //    DrawMesh {
    //        //   Clear { cR: 0.0; cG: 0.0; cB: 0.0 }
    //        property string name: "mesh2"
    //        file: "mesh/cube.x"
    //        //file: "mesh/ball5000.x"
    //        //file: "mesh/kolkkus.x"
    //        //file: "mesh/aivob.x"
    //        //file: "mesh/pillarman.obj"
    //        depthTest: true
    //        depthWrite: true
    //        blendMode: "off"
    //        ShaderParam {
    //            paramName: "g_uvScale"; paramValue: 2.0
    //        }
    //        ShaderParam { paramName: "g_texBrightness"; paramValue: 0.30 }
    //        Pos { x: 2.0; y: -0.50; z: 1.0; }
    //        Sca { s: 3.0; x: 1.0; y: 1.0; z: 1.0 }
    //      //  Rot { d: time()*30.0; ax: 1.0; ay: 1.0; az: 0.0 }
    //    }

    //    DrawMesh {
    //        //   Clear { cR: 0.0; cG: 0.0; cB: 0.0 }
    //        property string name: "mesh2"
    //        //file: "mesh/cube.x"
    //        file: "mesh/ball5000.x"
    //        //file: "mesh/kolkkus.x"
    //        //file: "mesh/aivob.x"
    //        //file: "mesh/pillarman.obj"
    //        depthTest: true
    //        depthWrite: true
    //        blendMode: "off"
    //        ShaderParam {
    //            paramName: "g_uvScale"; paramValue: 2.0
    //        }
    //        Pos { x: 1.0; y: 1.50; z: 3.0; }
    //        Sca { s: 1.0; x: 1.0; y: 1.0; z: 1.0 }
    //        Rot { d: time()*30.0; ax: 1.0; ay: 1.0; az: 0.0 }
    //    }



    Reflect { }

    Group {
        enabled: sync("loading.ON")
        Blit {
            textureRT: "bg"
        }

        DrawOverlay {
            enabled: sync("loading.ON")
            overlayAlpha: sync("loading.alpha")
            overlayScale: sync("loading.scale")
            file: "loader.png"
        }
    }


    Group {
        enabled: sync("prevBlurStore.ON")
        /// Previous frame blur feedback lights'n'magix
        Blit { textureRT: "prev" }
        Blur { enabled: sync("prevBlurStore.ON"); textureWrap: "clamp" }
        Blit { textureRT: "prevBlur" }
        Texture {
            textureUnit: 0
            textureRT: "prev"
        }
        Shader {
            file: "drawRt"
        }
        DrawVB {
            type: "quad"
            depthTest: false
            depthWrite: false
            ShaderParam {
                paramName: "flip"
                paramValue: 1.0
            }
            blendMode: "off"
        }

    }

    DrawRT {
        enabled: sync("loading.ON")
        textureRT: "bg"
        blendMode: "off"
    }



    GodRay {
        // godRayX: sync("godray.x")
        // godRayY: sync("godray.y")
        godRayX: getSavePointX2D("cen")
        godRayY: getSavePointY2D("cen")
    }


    Tonemap { }


    DrawOverlayAdd {
        property string name: "ovl_many"
        enabled: sync("ovl_many.ON")
        overlayScale: sync(name+".scale")
        overlayAlpha: sync(name+".alpha")
        posX: sync(name+".posX")
        posY: sync(name+".posY")
        file: "ovl_many.png"
        flip: true
    }
    DrawOverlayAdd {
        property string name: "ovl_some"
        overlayScale: sync(name+".scale")
        overlayAlpha: sync(name+".alpha")
        posX: sync(name+".posX")
        posY: sync(name+".posY")
        file: "ovl_some.png"
    }
    DrawOverlayAdd {
        property string name: "ovl_leaking"
        enabled: sync("ovl_leaking.ON")
        overlayScale: sync(name+".scale")
        overlayAlpha: sync(name+".alpha")
        posX: sync(name+".posX")
        posY: sync(name+".posY")
        file: "ovl_leaking.png"
        flip: true
    }
    DrawOverlayAdd {
        property string name: "ovl_underground"
        overlayScale: sync(name+".scale")
        overlayAlpha: sync(name+".alpha")
        posX: sync(name+".posX")
        posY: sync(name+".posY")
        file: "ovl_underground.png"
    }

    Glow { }

    Vignette { }


    Blit { textureRT: "frame_A_some"; blitRT: 0; }

    //    Shader {
    //        file: "testEmits"
    //    }
    //    DrawVB {
    //        type: "quad"
    //        depthTest: false
    //        depthWrite: false
    //        //        ShaderParam {
    //        //            paramName: "flip"; paramValue: 0.0;
    //        //        }
    //        //        ShaderParam {
    //        //            paramName: "g_bgAmount"; paramValue: sync("bgAmount")
    //        //        }
    //    }

    Shader { file: "smCoords" }

    Coords { }

    DrawOverlay {
        enabled: sync("loading.ON")
        overlayAlpha: Math.max((sync("loading.alpha")-0.5)*2.0, 0.0)
        overlayScale: sync("loading.scale")
        file: "loader.png"
    }

    Item {
        visible: bDebugTexts
        enabled: bDebugTexts
        id: infoText
        layer.enabled: true
        width: 1280
        height: 720
        FastBlur {
            anchors.fill: texts
            source: texts
            radius: 32
        }
        Item {
            opacity: 1.0
            id: texts
            anchors.fill: parent
            Column {
                anchors.bottom: parent.bottom
                anchors.left: parent.left
                ShadowText {
                    id: particleCountText
                    text:"particleCount: 0"
                    // pixelSize: 32
                }
            }
        }
    }
    DrawRT {
        visible: bDebugTexts
        enabled: bDebugTexts
        textureItem: infoText
        flip: false
    }



}
