/////
// party edition
// author Pentan(@c5h12)
/////

#ifdef GL_ES
precision mediump float;
#endif

uniform float time;
uniform vec2 mouse;
uniform vec2 resolution;
uniform sampler2D backbuffer;

const float kTEMPO = 2.0;
const float kPI = 3.14159265358979;

float tempo() {
    return fract(time * kTEMPO);
}

float sphere(vec3 p, float r) {
    return length(p) - r;
}

float hash( float n )
{
    return fract(sin(n)*43758.5453123);
}

vec3 hash3( float n )
{
    return fract(sin(vec3(n,n+1.0,n+2.0))*vec3(43758.5453123,22578.1459123,19642.3490423));
}

vec3 noise3( in vec3 x )
{
    vec3 p = floor(x);
    vec3 f = fract(x);

    f = f*f*(3.0-2.0*f);

    float n = p.x + p.y*57.0 + 113.0*p.z;

    return mix(mix(mix( hash3(n+  0.0), hash3(n+  1.0),f.x),
                   mix( hash3(n+ 57.0), hash3(n+ 58.0),f.x),f.y),
               mix(mix( hash3(n+113.0), hash3(n+114.0),f.x),
                   mix( hash3(n+170.0), hash3(n+171.0),f.x),f.y),f.z);
}

float perlin(vec3 p) {
    vec3 i = floor(p);
    vec4 a = dot(i, vec3(1., 57., 21.)) + vec4(0., 57., 21., 78.);
    vec3 f = cos((p-i)*kPI)*(-.5)+.5;
    a = mix(sin(cos(a)*a),sin(cos(1.+a)*(1.+a)), f.x);
    a.xy = mix(a.xz, a.yw, f.y);
    return mix(a.x, a.y, f.z);
}

float fbm(vec3 p) {
    float f = 0.0;
    f += 0.5000 * perlin(p); p = p * 2.02;
    f += 0.2500 * perlin(p); p = p * 2.03;
    f += 0.1250 * perlin(p);
    return f;// / 0.9375;
}

vec3 fbm3(vec3 p) {
    vec3 f = vec3(0.0);
    f += 0.5000 * noise3(p); p = p * 2.02;
    f += 0.2500 * noise3(p); p = p * 2.03;
    f += 0.1250 * noise3(p);
    return f;// / 0.9375;
}

float map(vec3 p, out vec3 outp) {
    float d;
    float scale = 1.0 + (1.0 - tempo()) * 0.2;
    
    vec3 mp = mod(p, 5.0) - 2.5;
    mp *= scale;
    
    //
    vec2 angle = (vec2(sin(time * 1.3), sin(time * 0.9))) * kPI;
    mat3 tr = mat3(
        1.0, 0.0, 0.0,
        0.0, cos(angle.x), -sin(angle.x),
        0.0, sin(angle.x), cos(angle.x)
    ) * mat3(
        cos(angle.y), 0.0, sin(angle.y),
        0.0, 1.0, 0.0,
        -sin(angle.y), 0.0, cos(angle.y)
    );
    //mp = tr * mp;
    //
    
    mp = mp + fbm3(p * 2.0) * 0.4;
    d = sphere(mp, 1.0);
    d = min(d, sphere(mp + vec3(0.7, 0.0, 0.0), 1.0));
    d = min(d, sphere(mp + vec3(0.5, 0.3, 0.2), 1.0));
    d += fbm(p * 1.0) * 0.2;
    
    outp = mp;
    
    return d / scale;
}

vec3 normal(vec3 p) {
    vec3 EPS = vec3(1e-2, 0.0, 0.0);
    vec3 n, a;
    
    n.x = map(p + EPS.xyz, a) - map(p - EPS.xyz, a);
    n.y = map(p + EPS.zxy, a) - map(p - EPS.zxy, a);
    n.z = map(p + EPS.yzx, a) - map(p - EPS.yzx, a);
    
    return normalize(n);
}

vec3 shading(vec3 pos) {
    vec3 col;
    vec3 n = normal(pos);
    vec3 ns = fbm3(pos * 5.0) * 1.0 - 0.5;
    
    float nns = dot(n, ns);
    n = normalize(n + ns * 0.1);
    
    float ao = clamp(0.0, 1.0, pow(abs(nns), 0.5) * 0.5);
    float sp = clamp(0.0, 1.0, pow(max(0.0, ao), 4.0) * 12.0);
    
    float dfs = max(0.0, dot(n, normalize(vec3(0.0, 0.0, 1.0))));
    col = vec3(0.8, 0.3, 0.02) * (dfs * 0.8 + ao * vec3(0.2, 0.05, 0.0)) + sp * vec3(1.0, 0.9, 0.8);
    
    return col;
}

vec3 bg(vec2 uv, vec3 dir) {
    vec3 ret;
    float t;
    
    t = pow(abs(dir.y), 0.5);
    vec3 sky = mix(vec3(0.45, 0.4, 0.2), vec3(0.6, 0.4, 0.3), t);
    
    t = max(0.0, -dir.z);
    t = pow(t, 60.0 + tempo() * 60.0);
    vec3 sun = vec3(0.8, 0.7, 0.5) * max(0.0, t);
    
    ret = sky + sun;
    
    return ret;
}

vec3 raymarch() {
    vec2 uv = (gl_FragCoord.xy * 2.0 - resolution) / resolution.y;
    vec3 pos = vec3(0.0, 0.0, 10.0 - time * 2.0);
    vec3 dir = normalize(vec3(uv, -4.0));
    
#if 0
    vec2 angle = (vec2(-mouse.y, mouse.x) * 2.0 - 1.0) * kPI;
    mat3 tr = mat3(
        1.0, 0.0, 0.0,
        0.0, cos(angle.x), -sin(angle.x),
        0.0, sin(angle.x), cos(angle.x)
    ) * mat3(
        cos(angle.y), 0.0, sin(angle.y),
        0.0, 1.0, 0.0,
        -sin(angle.y), 0.0, cos(angle.y)
    );
    pos = tr * pos;
    dir = tr * dir;
#endif
    
    vec3 col = bg(uv, dir);
    
    float t = 0.0;
    for(int i = 0; i < 32; i++) {
        vec3 lpos;
        float d = map(pos, lpos);
        
        if(d < 1e-4) {
            col = shading(pos);
            break;
        }
        pos += dir * d;
        t += d;
    }
    
    return col;
}

vec3 framefx(vec3 col) {
    vec2 uv = (gl_FragCoord.xy * 2.0 - resolution) / resolution.y;
    
    //vignetting
    vec3 v = vec3(1.0, 0.97, 0.9) * smoothstep(3.0, 1.5, length(uv));
    
    // frame
    vec2 frm = abs((gl_FragCoord.xy * 2.0 - resolution) / resolution);
    float f = max(frm.x, frm.y);
    f = smoothstep(0.85, 1.5, f) * (1.0 - tempo());
    
    return col * v + f * vec3(1.0, 0.9, 0.7);
}

void main() {
    vec3 col = raymarch();
    col = framefx(col);
    gl_FragColor = vec4(pow(col, vec3(0.454545)), 1.0);
}
