/* 
This API Key will be disabled on the 5th of April.

Generate your own at https://cloud.google.com/translate
*/
var apiKey = "AIzaSyBsu3jbo1-hrCNXVSfA9vvJZsSy5GGHhWU";

var walkFunction = traverseWalk;

setInterval(function() { walkFunction(document.body) }, 2000);

function simpleWalk(node) {
    var items = node.querySelectorAll("p");
    
    for(var i in items) {
        trimText(items[i]);
    }
}

function traverseWalk(node) 
{
    // I stole this function from here:
    // http://is.gd/mwZp7E
    
    var child, next;

    switch ( node.nodeType )  
    {
        case 1:  // Element
        case 9:  // Document
        case 11: // Document fragment
            child = node.firstChild;
            while ( child ) 
            {
                next = child.nextSibling;
                traverseWalk(child);
                child = next;
            }
            break;

        case 3: // Text node
            trimText(node);
            break;
    }
}

function trimText(textNode) {
    if(textNode.parentNode.hasAttribute('t0z')) {
        return;
    }

    var nodeValue = textNode.nodeValue || textNode.innerText;
    
    if(nodeValue == null || nodeValue.length == 0) {
        return;
    }
    
    if(textNode.parentElement.nodeName.indexOf("SCRIPT") !== -1) {
        return;
    }
    
    var value = nodeValue.replace(/^\s+|\s+$/g, '');
    
    if(value.length == 0) {
        return;
    }
    
    handleText(textNode, value);
}

function handleText(textNode, inputText)
{
    textNode.parentNode.setAttribute('t0z', 1);
	translateText(textNode, inputText);
}

function translateText(textNode, inputText)
{
   var language = getRandomLanguage();
   var url = "https://www.googleapis.com/language/translate/v2?key=" 
               + apiKey
               + "&target=" + getRandomLanguage()
               + "&q=" + encodeURIComponent(inputText);
   var xmlhttp = new XMLHttpRequest();

   xmlhttp.onreadystatechange=function()
   {
      if (xmlhttp.readyState == 4 && xmlhttp.status == 200)
      {
         textNode.nodeValue = htmlDecode(getTranslationFromResponse(xmlhttp.responseText));
      }
   }
   xmlhttp.open("GET",url,true);
   xmlhttp.send();
   return true;
}

function htmlDecode(input) {
   var e = document.createElement('div');
   e.innerHTML = input;
   return e.childNodes.length === 0 ? "" : e.childNodes[0].nodeValue;
}

function getTranslationFromResponse(response)
{
   var data = JSON.parse(response);
   return data.data.translations[0].translatedText;
}

function getRandomLanguage()
{
   var kake = [
      'af','sq','ar','az',
      'eu','bn','be','bg',
      'ca','zh-CN','zh-TW',
      'hr','cs','da','nl',
           'eo','et','tl',
      'fi','fr','gl','ka',
      'de','el','gu','ht',
      'iw','hi','hu','is',
      'id','ga','it','ja',
      'kn','ko','la','lv',
      'lt','mk','ms','mt',
           'fa','pl','pt',
      'ro','ru','sr','sk',
      'sl','es','sw','sv',
      'ta','te','th','tr',
      'uk','ur','vi','cy',
      'yi'
   ];

   return kake[Math.round(Math.random() * (kake.length - 1))];
}
