﻿using UnityEngine;
using System.Collections;

public class GUIController : MonoBehaviour {
	public bool isPlayerDead = false;
	public static GUIController gui;
	public float Distance;
	public float Score;

	void Awake(){
		gui = this;
	}

	// Update is called once per frame
	void OnGUI () {
		if (isPlayerDead) {
			//START
			GUILayout.BeginArea(new Rect(Screen.width / 2 - 100, Screen.height / 2 - 100, 200, 500));

			//Text and score
			GUILayout.Label("You have died!");
			GUILayout.Label("Score: " + Score.ToString("N"));

			//Restart button
			if(GUILayout.Button("Retry")){
				Application.LoadLevel(0);
			}

			if(GUILayout.Button("Main menu")){
				Application.LoadLevel(0);
			}

			//END
			GUILayout.EndArea();
		}
	}
}
