#version 330 core

// Input data
in vec2 texCoord;
in vec3 ViewDirection;
in vec3 Normal;

////
in vec3 EyeDirection_cameraspace;
in vec3 LightDirection_cameraspace;
in vec3 Position_worldspace;
in vec3 LightDirection_tangentspace;
in vec3 EyeDirection_tangentspace;
////



// Output data
out vec4 color;

// Values that stay constant for the whole draw.
uniform vec4 Diffuse;
uniform vec4 Ambient;
uniform vec4 Specular;

uniform float SpecularPower;

uniform float Time;
uniform float Sync;

uniform sampler2D ambientMap;
uniform sampler2D bumpMap;
uniform sampler2D diffuseMap;
uniform sampler2D specularMap;

uniform bool ambientMapActive;
uniform bool bumpMapActive;
uniform bool diffuseMapActive;
uniform bool emissionMapActive;
uniform bool shininessMapActive;
uniform bool specularMapActive;
uniform bool transparencyMapActive;

vec4 ambientColor;
vec3 nNormal;
vec4 diffuseColor;
vec4 SpecularColor;


#define MAX_LIGHTS 10
in vec3 directions[MAX_LIGHTS];
in float distances[MAX_LIGHTS];

uniform int numLights;
uniform struct Light
{
	uint type; // 0=invalid - 1=Point Light - 2=Ambient Light - 3=Directional Light - 4=Spot Light
	vec3 position;
	vec3 direction;
	vec3 color;
	float intensity;
	float coneAngle;
	float penumbraAngle;	// see "http://buzzking.me/?p=486"
	float dropOff;
} allLights[MAX_LIGHTS];

vec4 calcLights(Light light, vec3 direction, float distance)
{
	float att;
	float constantAttenuation= -1.0;
	float linearAttenuation=0.02;
	float quadraticAttenuation=0.01;
    //att = constantAttenuation / ((1+linearAttenuation*distance)*(1+quadraticAttenuation*distance*distance));
	att = 1.0 / (1.0 + linearAttenuation * pow(distance, 2));

	vec3 tempLightDirection = normalize(direction);
	float dotLight = dot( nNormal, tempLightDirection );
	vec3 tempReflection = reflect(-tempLightDirection,nNormal);
	//vec3 tempReflection = normalize(((2.0 * nNormal) * dotLight) - tempLightDirection);
	// ViewDirection is calculated wrong!
	vec3 tempViewDirection = normalize(ViewDirection);



	// Distance to the light
	float Distance = length( light.position - Position_worldspace );
		
	// Normal of the computed fragment, in camera space
	vec3 n = nNormal;
	// Direction of the light (from the fragment to the light)	
	vec3 l = normalize(LightDirection_tangentspace);
		
	// Eye vector (towards the camera)
	vec3 E = normalize(EyeDirection_tangentspace);
	// Direction in which the triangle reflects the light
	vec3 R = reflect(-l,n);
	// Cosine of the angle between the Eye vector and the Reflect vector,
	// clamped to 0
	//  - Looking into the reflection -> 1
	//  - Looking elsewhere -> < 1
	float cosAlpha = clamp( dot( E,R ), 0,1 );

	//vec4 tempSpecularColor = SpecularColor * vec4(light.color, 1.0) * 40.0 * pow(cosAlpha,5) / (Distance*Distance);



	float tempRDotV = max(0.0, dot(tempReflection, tempViewDirection));

	vec4 tempDiffuseColor = diffuseColor * dotLight * light.intensity * vec4(light.color, 1.0);

	vec4 tempSpecularColor = SpecularColor * pow(tempRDotV, SpecularPower);
	

	//return tempSpecularColor;
	return tempDiffuseColor + tempSpecularColor;
	//return att*(tempDiffuseColor + tempSpecularColor);
}

void main(void)
{
	if(ambientMapActive)
	{
		ambientColor = texture(ambientMap, texCoord);
	}
	else
	{
		ambientColor = Ambient;
	}
	
	if(bumpMapActive)
	{
		nNormal = normalize( (texture(bumpMap, texCoord).xyz * 2.0) - 1.0);
    }
	else
	{
		nNormal = Normal;
	}

	if(diffuseMapActive)
	{
		diffuseColor = texture(diffuseMap, texCoord);
	}
	else
	{
		diffuseColor = Diffuse;
	}

	if(specularMapActive)
	{
		SpecularColor = texture(specularMap, texCoord);
    }
	else
	{
		SpecularColor = Specular;
	}
	vec4 AmbientColor = ambientColor * diffuseColor;

	vec4 tempColor = vec4(0);
	for(int i = 0; i < numLights; ++i)
	{
		tempColor += calcLights(allLights[i], directions[i], distances[i]);
    }

	color = tempColor + AmbientColor;
}