#version 330 core

// Input data
in vec2 texCoord;

// Output data
out vec4 color;

// Values that stay constant for the whole draw.
uniform vec4 Diffuse;

uniform sampler2D diffuseMap;
uniform bool diffuseMapActive;

void main(void)
{
	vec4 diffuseColor;
	

	if(diffuseMapActive)
	{
		color = texture(diffuseMap, texCoord);
	}
	else
	{
		color = Diffuse;
	}

	//color = vec4(0.0, 0.0, 0.8, 1.0);
}