#version 330 core

// Input data
layout(location = 0) in vec3 vertexPosition_modelspace;
layout(location = 1) in vec2 vertexUV;
layout(location = 2) in vec3 vertexNormal_modelspace;
layout(location = 3) in vec3 vertexTangent_modelspace;
layout(location = 4) in vec3 vertexBiTangent_modelspace;
layout(location = 5) in vec3 instancedPos;

// Output data
out vec2 texCoord;
out vec3 ViewDirection;
out vec3 Normal;

// Values that stay constant for the whole draw.
uniform mat4 MVP;
uniform mat4 V;
uniform mat4 M;

uniform vec3 fvEyePosition;
uniform float Time;

uniform bool bumpMapActive;


vec3 tangent;
vec3 binormal;
vec4 objectPosition;
vec3 nBinormal;
vec3 nTangent;
vec3 nViewDirection;
vec3 nLightDirection1;

#define MAX_LIGHTS 10
out vec3 directions[MAX_LIGHTS];

uniform int numLights;
uniform struct Light
{
	uint type; // 0=invalid - 1=Point Light - 2=Ambient Light - 3=Directional Light - 4=Spot Light
	vec3 position;
	vec3 direction;
	vec3 color;
	float intensity;
	float coneAngle;
	float penumbraAngle;	// see "http://buzzking.me/?p=486"
	float dropOff;
} allLights[MAX_LIGHTS];

vec3 calcLights(Light light)
{
	vec3 tempDirection;

	if(bumpMapActive)
	{
		nViewDirection = fvEyePosition - objectPosition.xyz;
		ViewDirection.x = dot(vertexTangent_modelspace, nViewDirection);
		ViewDirection.y = dot(nBinormal, nViewDirection);
		ViewDirection.z = dot(Normal, nViewDirection);		


		nLightDirection1 = (V * M * vec4(light.position, 1)).xyz - objectPosition.xyz;

		tempDirection.x = dot(nTangent, nLightDirection1);
		tempDirection.y = dot(nBinormal, nLightDirection1);
		tempDirection.z = dot(Normal, nLightDirection1);
    }	
	else
	{
		tempDirection = (V * M * vec4(light.position, 1)).xyz - objectPosition.xyz;
		ViewDirection = fvEyePosition - objectPosition.xyz;
    }

	return tempDirection;
}

void main(void)
{
	gl_Position =  MVP * vec4(vertexPosition_modelspace + instancedPos,1);
	texCoord = vertexUV;
	objectPosition = V * M * vec4(vertexPosition_modelspace + instancedPos,1);
	Normal = vec4((transpose(inverse(V * M))) *  vec4(vertexNormal_modelspace,0)).xyz;

	tangent = normalize(vertexTangent_modelspace);
	binormal = normalize(vertexBiTangent_modelspace);

	nBinormal = vec4((transpose(inverse(V * M))) * vec4(binormal,0)).xyz;
	nTangent = vec4((transpose(inverse(V * M))) * vec4(tangent,0)).xyz;

	for(int i = 0; i < numLights; ++i)
	{
		directions[i] = calcLights(allLights[i]);
    }
}