#version 330 core

// Input data
layout(location = 0) in vec3 vertexPosition_modelspace;
layout(location = 1) in vec2 vertexUV;
layout(location = 2) in vec3 vertexNormal_modelspace;

// Output data
out vec2 texCoord;
out vec3 ViewDirection;
out vec3 Normal;

// Values that stay constant for the whole draw.
uniform mat4 MVP;
uniform mat4 V;
uniform mat4 M;

uniform vec3 fvEyePosition;
uniform float time;
uniform vec2 Distort;
uniform vec2 DistortSpeed;

uniform sampler2D heightMap;

vec3 tangent;
vec3 binormal;
vec4 objectPosition;
vec3 nViewDirection;
vec3 nLightDirection1;

#define MAX_LIGHTS 10
out vec3 directions[MAX_LIGHTS];

uniform int numLights;
uniform struct Light
{
	uint type; // 0=invalid - 1=Point Light - 2=Ambient Light - 3=Directional Light - 4=Spot Light
	vec3 position;
	vec3 direction;
	vec3 color;
	float intensity;
	float coneAngle;
	float penumbraAngle;	// see "http://buzzking.me/?p=486"
	float dropOff;
} allLights[MAX_LIGHTS];

vec3 calcLights(Light light)
{
	vec3 tempDirection;

	tempDirection = (V * M * vec4(light.position, 1)).xyz - objectPosition.xyz;
	ViewDirection = fvEyePosition - objectPosition.xyz;

	return tempDirection;
}

void main(void)
{
	texCoord = vertexUV/2;
	objectPosition = V * M * vec4(vertexPosition_modelspace,1);
	Normal = vec4((transpose(inverse(V * M))) *  vec4(vertexNormal_modelspace,0)).xyz;

	for(int i = 0; i < numLights; ++i)
	{
		directions[i] = calcLights(allLights[i]);
    }

	vec4 height;
	float factor;	
	height = texture(heightMap, vertexUV);

	//factor = (0.30*height.x + 0.59*height.y + 0.11*height.z)*(sin(time/3.0)+1.0);
	factor = (0.30*height.x + 0.59*height.y + 0.11*height.z)+clamp(sin(time/3.0)*5, 0.0, 2.0);
	//newVertexPos = vec4(gl_Normal * df * 100.0, 0.0) + gl_Vertex;

    vec4 vertex = vec4(vertexPosition_modelspace,1) * factor; // Transform an homogeneous 4D vector, remember 

	vertex.x = vertex.x + cos(time * .2 + vertex.y)*.2;
	vertex.y = vertex.y + sin(time * .6 + vertex.x)*1.9;
	//vertex.z = vertex.z + sin(time * 3 + vertex.x)*1.4;

	gl_Position =  MVP * vertex;
}