THREE.ShaderChunk['example'] = "test 1\ntest 2";
THREE.ShaderChunk['flameFragment'] = "uniform float t;\nuniform vec3 c1;\nuniform vec3 c2;\n	\nvarying vec2 vUv;\n\nvarying vec3 N;\nvarying vec3 V;\n\nfloat ease(float t) {\n  return t * t * t;\n}\n\nvoid main() {\n	float ratio = dot(V, N);\n    vec3 c = mix(c1, c2, ease(ratio));\n\n	gl_FragColor = vec4(c * 1.1, 1.0);\n}";
THREE.ShaderChunk['flameVertex'] = "uniform float t;\nuniform float wiggle;\nuniform vec3 skew;\nvarying vec2 vUv;\n\nattribute vec3 fNormal;\nvarying vec3 N;\nvarying vec3 V;\n\n#define PI 3.141592653589793\n\nfloat ease(float t) {\n  return -0.5 * (cos(PI * t) - 1.0);\n}\n\nvoid main() {\n	vUv = uv;\n	\n	vec3 pos = position;\n	float uf = (0.000001 + pos.z) / 20.0;\n\n	pos.x += (sin(-wiggle * t + pos.z) * 0.7) * uf;\n	pos.y += (sin(-wiggle * t + pos.z) * 0.7) * uf;\n\n	pos += (skew * ease(uf));\n\n	N = normalize(normalMatrix * fNormal); \n	V = normalize(-vec3(modelViewMatrix * vec4(pos, 1.0)));\n\n	gl_Position = projectionMatrix * modelViewMatrix * vec4( pos, 1.0 );\n}";
THREE.ShaderChunk['nightclubScreen_effects'] = "uniform int flipUv;\nuniform float time;\n\nvec3 COLOR1 = vec3(0.0, 0.0, 0.3);\nvec3 COLOR2 = vec3(0.5, 0.0, 0.0);\nfloat BLOCK_WIDTH = 0.01;\n\nvoid main()\n{\n	vec2 uv = vUv;\n\n	if(flipUv == 1) {\n		uv.x = 1.0 - uv.x;\n	}\n	\n	// To create the BG pattern\n	vec3 final_color = vec3(1.0);\n	vec3 bg_color = vec3(0.0);\n	vec3 wave_color = vec3(0.0);\n	\n	float c1 = mod(uv.x, 2.0 * BLOCK_WIDTH);\n	c1 = step(BLOCK_WIDTH, c1);\n	\n	float c2 = mod(uv.y, 2.0 * BLOCK_WIDTH);\n	c2 = step(BLOCK_WIDTH, c2);\n	\n	bg_color = mix(uv.x * COLOR1, uv.y * COLOR2, c1 * c2);\n		\n	// To create the waves\n	float wave_width = 0.01;\n	uv  = -1.0 + 2.0 * uv;\n	uv.y += 0.1;\n	for(float i = 0.0; i < 10.0; i++) {\n		\n		uv.y += (0.07 * sin(uv.x + i / 7.0 + (time * 100.0) ));\n		wave_width = abs(1.0 / (150.0 * uv.y));\n		wave_color += vec3(wave_width * 1.9, wave_width, wave_width * 1.5);\n	}\n	\n	final_color = bg_color + wave_color;\n		\n	gl_FragColor = vec4(final_color, 1.0);\n}";
THREE.ShaderChunk['orig_LambertMaterial_fragment'] = "uniform float opacity;\nvarying vec3 vLightFront;\n#ifdef DOUBLE_SIDED\n	varying vec3 vLightBack;\n#endif\n#ifdef USE_COLOR\n\n	varying vec3 vColor;\n\n#endif\n\n#if defined( USE_MAP ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( USE_SPECULARMAP ) || defined( USE_ALPHAMAP )\n\n	varying vec2 vUv;\n\n#endif\n\n#ifdef USE_MAP\n\n	uniform sampler2D map;\n\n#endif\n#ifdef USE_ALPHAMAP\n\n	uniform sampler2D alphaMap;\n\n#endif\n\n#ifdef USE_LIGHTMAP\n\n	varying vec2 vUv2;\n	uniform sampler2D lightMap;\n\n#endif\n#ifdef USE_ENVMAP\n\n	uniform float reflectivity;\n	#ifdef ENVMAP_TYPE_CUBE\n		uniform samplerCube envMap;\n	#else\n		uniform sampler2D envMap;\n	#endif\n	uniform float flipEnvMap;\n\n	#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n\n		uniform float refractionRatio;\n\n	#else\n\n		varying vec3 vReflect;\n\n	#endif\n\n#endif\n\n#ifdef USE_FOG\n\n	uniform vec3 fogColor;\n\n	#ifdef FOG_EXP2\n\n		uniform float fogDensity;\n\n	#else\n\n		uniform float fogNear;\n		uniform float fogFar;\n	#endif\n\n#endif\n#ifdef USE_SHADOWMAP\n\n	uniform sampler2D shadowMap[ MAX_SHADOWS ];\n	uniform vec2 shadowMapSize[ MAX_SHADOWS ];\n\n	uniform float shadowDarkness[ MAX_SHADOWS ];\n	uniform float shadowBias[ MAX_SHADOWS ];\n\n	varying vec4 vShadowCoord[ MAX_SHADOWS ];\n\n	float unpackDepth( const in vec4 rgba_depth ) {\n\n		const vec4 bit_shift = vec4( 1.0 / ( 256.0 * 256.0 * 256.0 ), 1.0 / ( 256.0 * 256.0 ), 1.0 / 256.0, 1.0 );\n		float depth = dot( rgba_depth, bit_shift );\n		return depth;\n\n	}\n\n#endif\n#ifdef USE_SPECULARMAP\n\n	uniform sampler2D specularMap;\n\n#endif\n#ifdef USE_LOGDEPTHBUF\n\n	uniform float logDepthBufFC;\n\n	#ifdef USE_LOGDEPTHBUF_EXT\n\n		#extension GL_EXT_frag_depth : enable\n		varying float vFragDepth;\n\n	#endif\n\n#endif\nvoid main() {\n	gl_FragColor = vec4( vec3( 1.0 ), opacity );\n#if defined(USE_LOGDEPTHBUF) && defined(USE_LOGDEPTHBUF_EXT)\n\n	gl_FragDepthEXT = log2(vFragDepth) * logDepthBufFC * 0.5;\n\n#endif\n#ifdef USE_MAP\n\n	vec4 texelColor = texture2D( map, vUv );\n\n	#ifdef GAMMA_INPUT\n\n		texelColor.xyz *= texelColor.xyz;\n\n	#endif\n\n	gl_FragColor = gl_FragColor * texelColor;\n\n#endif\n#ifdef USE_ALPHAMAP\n\n	gl_FragColor.a *= texture2D( alphaMap, vUv ).g;\n\n#endif\n\n#ifdef ALPHATEST\n\n	if ( gl_FragColor.a < ALPHATEST ) discard;\n\n#endif\n\nfloat specularStrength;\n\n#ifdef USE_SPECULARMAP\n\n	vec4 texelSpecular = texture2D( specularMap, vUv );\n	specularStrength = texelSpecular.r;\n\n#else\n\n	specularStrength = 1.0;\n\n#endif\n	#ifdef DOUBLE_SIDED\n		if ( gl_FrontFacing )\n			gl_FragColor.xyz *= vLightFront;\n		else\n			gl_FragColor.xyz *= vLightBack;\n	#else\n		gl_FragColor.xyz *= vLightFront;\n	#endif\n#ifdef USE_LIGHTMAP\n\n	gl_FragColor = gl_FragColor * texture2D( lightMap, vUv2 );\n\n#endif\n#ifdef USE_COLOR\n\n	gl_FragColor = gl_FragColor * vec4( vColor, 1.0 );\n\n#endif\n#ifdef USE_ENVMAP\n\n	#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n\n		vec3 cameraToVertex = normalize( vWorldPosition - cameraPosition );\n\n		// http://en.wikibooks.org/wiki/GLSL_Programming/Applying_Matrix_Transformations\n		// Transforming Normal Vectors with the Inverse Transformation\n\n		vec3 worldNormal = normalize( vec3( vec4( normal, 0.0 ) * viewMatrix ) );\n\n		#ifdef ENVMAP_MODE_REFLECTION\n\n			vec3 reflectVec = reflect( cameraToVertex, worldNormal );\n\n		#else\n\n			vec3 reflectVec = refract( cameraToVertex, worldNormal, refractionRatio );\n\n		#endif\n\n	#else\n\n		vec3 reflectVec = vReflect;\n\n	#endif\n\n	#ifdef DOUBLE_SIDED\n		float flipNormal = ( -1.0 + 2.0 * float( gl_FrontFacing ) );\n	#else\n		float flipNormal = 1.0;\n	#endif\n\n	#ifdef ENVMAP_TYPE_CUBE\n		vec4 envColor = textureCube( envMap, flipNormal * vec3( flipEnvMap * reflectVec.x, reflectVec.yz ) );\n\n	#elif defined( ENVMAP_TYPE_EQUIREC )\n		vec2 sampleUV;\n		sampleUV.y = clamp( flipNormal * reflectVec.y * 0.5 + 0.5, 0.0, 1.0);\n		sampleUV.x = atan( flipNormal * reflectVec.z, flipNormal * reflectVec.x ) * 0.15915494309189533576888376337251 + 0.5; // reciprocal( 2 PI ) + 0.5\n		vec4 envColor = texture2D( envMap, sampleUV );\n		\n	#elif defined( ENVMAP_TYPE_SPHERE )\n		vec3 reflectView = flipNormal * normalize((viewMatrix * vec4( reflectVec, 0.0 )).xyz + vec3(0.0,0.0,1.0));\n		vec4 envColor = texture2D( envMap, reflectView.xy * 0.5 + 0.5 );\n	#endif\n\n	#ifdef GAMMA_INPUT\n\n		envColor.xyz *= envColor.xyz;\n\n	#endif\n\n	#ifdef ENVMAP_BLENDING_MULTIPLY\n\n		gl_FragColor.xyz = mix( gl_FragColor.xyz, gl_FragColor.xyz * envColor.xyz, specularStrength * reflectivity );\n\n	#elif defined( ENVMAP_BLENDING_MIX )\n\n		gl_FragColor.xyz = mix( gl_FragColor.xyz, envColor.xyz, specularStrength * reflectivity );\n\n	#elif defined( ENVMAP_BLENDING_ADD )\n\n		gl_FragColor.xyz += envColor.xyz * specularStrength * reflectivity;\n\n	#endif\n\n#endif\n\n#ifdef USE_SHADOWMAP\n\n	#ifdef SHADOWMAP_DEBUG\n\n		vec3 frustumColors[3];\n		frustumColors[0] = vec3( 1.0, 0.5, 0.0 );\n		frustumColors[1] = vec3( 0.0, 1.0, 0.8 );\n		frustumColors[2] = vec3( 0.0, 0.5, 1.0 );\n\n	#endif\n\n	#ifdef SHADOWMAP_CASCADE\n\n		int inFrustumCount = 0;\n\n	#endif\n\n	float fDepth;\n	vec3 shadowColor = vec3( 1.0 );\n\n	for( int i = 0; i < MAX_SHADOWS; i ++ ) {\n\n		vec3 shadowCoord = vShadowCoord[ i ].xyz / vShadowCoord[ i ].w;\n\n				// if ( something && something ) breaks ATI OpenGL shader compiler\n				// if ( all( something, something ) ) using this instead\n\n		bvec4 inFrustumVec = bvec4 ( shadowCoord.x >= 0.0, shadowCoord.x <= 1.0, shadowCoord.y >= 0.0, shadowCoord.y <= 1.0 );\n		bool inFrustum = all( inFrustumVec );\n\n				// don't shadow pixels outside of light frustum\n				// use just first frustum (for cascades)\n				// don't shadow pixels behind far plane of light frustum\n\n		#ifdef SHADOWMAP_CASCADE\n\n			inFrustumCount += int( inFrustum );\n			bvec3 frustumTestVec = bvec3( inFrustum, inFrustumCount == 1, shadowCoord.z <= 1.0 );\n\n		#else\n\n			bvec2 frustumTestVec = bvec2( inFrustum, shadowCoord.z <= 1.0 );\n\n		#endif\n\n		bool frustumTest = all( frustumTestVec );\n\n		if ( frustumTest ) {\n\n			shadowCoord.z += shadowBias[ i ];\n\n			#if defined( SHADOWMAP_TYPE_PCF )\n\n						// Percentage-close filtering\n						// (9 pixel kernel)\n						// http://fabiensanglard.net/shadowmappingPCF/\n\n				float shadow = 0.0;\n\n		/*\n						// nested loops breaks shader compiler / validator on some ATI cards when using OpenGL\n						// must enroll loop manually\n\n				for ( float y = -1.25; y <= 1.25; y += 1.25 )\n					for ( float x = -1.25; x <= 1.25; x += 1.25 ) {\n\n						vec4 rgbaDepth = texture2D( shadowMap[ i ], vec2( x * xPixelOffset, y * yPixelOffset ) + shadowCoord.xy );\n\n								// doesn't seem to produce any noticeable visual difference compared to simple texture2D lookup\n								//vec4 rgbaDepth = texture2DProj( shadowMap[ i ], vec4( vShadowCoord[ i ].w * ( vec2( x * xPixelOffset, y * yPixelOffset ) + shadowCoord.xy ), 0.05, vShadowCoord[ i ].w ) );\n\n						float fDepth = unpackDepth( rgbaDepth );\n\n						if ( fDepth < shadowCoord.z )\n							shadow += 1.0;\n\n				}\n\n				shadow /= 9.0;\n\n		*/\n\n				const float shadowDelta = 1.0 / 9.0;\n\n				float xPixelOffset = 1.0 / shadowMapSize[ i ].x;\n				float yPixelOffset = 1.0 / shadowMapSize[ i ].y;\n\n				float dx0 = -1.25 * xPixelOffset;\n				float dy0 = -1.25 * yPixelOffset;\n				float dx1 = 1.25 * xPixelOffset;\n				float dy1 = 1.25 * yPixelOffset;\n\n				fDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx0, dy0 ) ) );\n				if ( fDepth < shadowCoord.z ) shadow += shadowDelta;\n\n				fDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( 0.0, dy0 ) ) );\n				if ( fDepth < shadowCoord.z ) shadow += shadowDelta;\n\n				fDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx1, dy0 ) ) );\n				if ( fDepth < shadowCoord.z ) shadow += shadowDelta;\n\n				fDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx0, 0.0 ) ) );\n				if ( fDepth < shadowCoord.z ) shadow += shadowDelta;\n\n				fDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy ) );\n				if ( fDepth < shadowCoord.z ) shadow += shadowDelta;\n\n				fDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx1, 0.0 ) ) );\n				if ( fDepth < shadowCoord.z ) shadow += shadowDelta;\n\n				fDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx0, dy1 ) ) );\n				if ( fDepth < shadowCoord.z ) shadow += shadowDelta;\n\n				fDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( 0.0, dy1 ) ) );\n				if ( fDepth < shadowCoord.z ) shadow += shadowDelta;\n\n				fDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx1, dy1 ) ) );\n				if ( fDepth < shadowCoord.z ) shadow += shadowDelta;\n\n				shadowColor = shadowColor * vec3( ( 1.0 - shadowDarkness[ i ] * shadow ) );\n\n			#elif defined( SHADOWMAP_TYPE_PCF_SOFT )\n\n						// Percentage-close filtering\n						// (9 pixel kernel)\n						// http://fabiensanglard.net/shadowmappingPCF/\n\n				float shadow = 0.0;\n\n				float xPixelOffset = 1.0 / shadowMapSize[ i ].x;\n				float yPixelOffset = 1.0 / shadowMapSize[ i ].y;\n\n				float dx0 = -1.0 * xPixelOffset;\n				float dy0 = -1.0 * yPixelOffset;\n				float dx1 = 1.0 * xPixelOffset;\n				float dy1 = 1.0 * yPixelOffset;\n\n				mat3 shadowKernel;\n				mat3 depthKernel;\n\n				depthKernel[0][0] = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx0, dy0 ) ) );\n				depthKernel[0][1] = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx0, 0.0 ) ) );\n				depthKernel[0][2] = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx0, dy1 ) ) );\n				depthKernel[1][0] = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( 0.0, dy0 ) ) );\n				depthKernel[1][1] = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy ) );\n				depthKernel[1][2] = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( 0.0, dy1 ) ) );\n				depthKernel[2][0] = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx1, dy0 ) ) );\n				depthKernel[2][1] = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx1, 0.0 ) ) );\n				depthKernel[2][2] = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx1, dy1 ) ) );\n\n				vec3 shadowZ = vec3( shadowCoord.z );\n				shadowKernel[0] = vec3(lessThan(depthKernel[0], shadowZ ));\n				shadowKernel[0] *= vec3(0.25);\n\n				shadowKernel[1] = vec3(lessThan(depthKernel[1], shadowZ ));\n				shadowKernel[1] *= vec3(0.25);\n\n				shadowKernel[2] = vec3(lessThan(depthKernel[2], shadowZ ));\n				shadowKernel[2] *= vec3(0.25);\n\n				vec2 fractionalCoord = 1.0 - fract( shadowCoord.xy * shadowMapSize[i].xy );\n\n				shadowKernel[0] = mix( shadowKernel[1], shadowKernel[0], fractionalCoord.x );\n				shadowKernel[1] = mix( shadowKernel[2], shadowKernel[1], fractionalCoord.x );\n\n				vec4 shadowValues;\n				shadowValues.x = mix( shadowKernel[0][1], shadowKernel[0][0], fractionalCoord.y );\n				shadowValues.y = mix( shadowKernel[0][2], shadowKernel[0][1], fractionalCoord.y );\n				shadowValues.z = mix( shadowKernel[1][1], shadowKernel[1][0], fractionalCoord.y );\n				shadowValues.w = mix( shadowKernel[1][2], shadowKernel[1][1], fractionalCoord.y );\n\n				shadow = dot( shadowValues, vec4( 1.0 ) );\n\n				shadowColor = shadowColor * vec3( ( 1.0 - shadowDarkness[ i ] * shadow ) );\n\n			#else\n\n				vec4 rgbaDepth = texture2D( shadowMap[ i ], shadowCoord.xy );\n				float fDepth = unpackDepth( rgbaDepth );\n\n				if ( fDepth < shadowCoord.z )\n\n		// spot with multiple shadows is darker\n\n					shadowColor = shadowColor * vec3( 1.0 - shadowDarkness[ i ] );\n\n		// spot with multiple shadows has the same color as single shadow spot\n\n		// 					shadowColor = min( shadowColor, vec3( shadowDarkness[ i ] ) );\n\n			#endif\n\n		}\n\n\n		#ifdef SHADOWMAP_DEBUG\n\n			#ifdef SHADOWMAP_CASCADE\n\n				if ( inFrustum && inFrustumCount == 1 ) gl_FragColor.xyz *= frustumColors[ i ];\n\n			#else\n\n				if ( inFrustum ) gl_FragColor.xyz *= frustumColors[ i ];\n\n			#endif\n\n		#endif\n\n	}\n\n	#ifdef GAMMA_OUTPUT\n\n		shadowColor *= shadowColor;\n\n	#endif\n\n	gl_FragColor.xyz = gl_FragColor.xyz * shadowColor;\n\n#endif\n\n#ifdef GAMMA_OUTPUT\n\n	gl_FragColor.xyz = sqrt( gl_FragColor.xyz );\n\n#endif\n#ifdef USE_FOG\n\n	#ifdef USE_LOGDEPTHBUF_EXT\n\n		float depth = gl_FragDepthEXT / gl_FragCoord.w;\n\n	#else\n\n		float depth = gl_FragCoord.z / gl_FragCoord.w;\n\n	#endif\n\n	#ifdef FOG_EXP2\n\n		const float LOG2 = 1.442695;\n		float fogFactor = exp2( - fogDensity * fogDensity * depth * depth * LOG2 );\n		fogFactor = 1.0 - clamp( fogFactor, 0.0, 1.0 );\n\n	#else\n\n		float fogFactor = smoothstep( fogNear, fogFar, depth );\n\n	#endif\n	\n	gl_FragColor = mix( gl_FragColor, vec4( fogColor, gl_FragColor.w ), fogFactor );\n\n#endif\n}";
THREE.ShaderChunk['orig_LambertMaterial_vertex'] = "#define LAMBERT\nvarying vec3 vLightFront;\n#ifdef DOUBLE_SIDED\n	varying vec3 vLightBack;\n#endif\n#if defined( USE_MAP ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( USE_SPECULARMAP ) || defined( USE_ALPHAMAP )\n\n	varying vec2 vUv;\n	uniform vec4 offsetRepeat;\n\n#endif\n\n#ifdef USE_LIGHTMAP\n\n	varying vec2 vUv2;\n\n#endif\n#if defined( USE_ENVMAP ) && ! defined( USE_BUMPMAP ) && ! defined( USE_NORMALMAP ) && ! defined( PHONG )\n\n	varying vec3 vReflect;\n\n	uniform float refractionRatio;\n\n#endif\n\nuniform vec3 ambient;\nuniform vec3 diffuse;\nuniform vec3 emissive;\n\nuniform vec3 ambientLightColor;\n\n#if MAX_DIR_LIGHTS > 0\n\n	uniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\n	uniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n\n#endif\n\n#if MAX_HEMI_LIGHTS > 0\n\n	uniform vec3 hemisphereLightSkyColor[ MAX_HEMI_LIGHTS ];\n	uniform vec3 hemisphereLightGroundColor[ MAX_HEMI_LIGHTS ];\n	uniform vec3 hemisphereLightDirection[ MAX_HEMI_LIGHTS ];\n\n#endif\n\n#if MAX_POINT_LIGHTS > 0\n\n	uniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\n	uniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\n	uniform float pointLightDistance[ MAX_POINT_LIGHTS ];\n\n#endif\n\n#if MAX_SPOT_LIGHTS > 0\n\n	uniform vec3 spotLightColor[ MAX_SPOT_LIGHTS ];\n	uniform vec3 spotLightPosition[ MAX_SPOT_LIGHTS ];\n	uniform vec3 spotLightDirection[ MAX_SPOT_LIGHTS ];\n	uniform float spotLightDistance[ MAX_SPOT_LIGHTS ];\n	uniform float spotLightAngleCos[ MAX_SPOT_LIGHTS ];\n	uniform float spotLightExponent[ MAX_SPOT_LIGHTS ];\n\n#endif\n\n#ifdef WRAP_AROUND\n\n	uniform vec3 wrapRGB;\n\n#endif\n\n#ifdef USE_COLOR\n\n	varying vec3 vColor;\n\n#endif\n#ifdef USE_MORPHTARGETS\n\n	#ifndef USE_MORPHNORMALS\n\n	uniform float morphTargetInfluences[ 8 ];\n\n	#else\n\n	uniform float morphTargetInfluences[ 4 ];\n\n	#endif\n\n#endif\n#ifdef USE_SKINNING\n\n	uniform mat4 bindMatrix;\n	uniform mat4 bindMatrixInverse;\n\n	#ifdef BONE_TEXTURE\n\n		uniform sampler2D boneTexture;\n		uniform int boneTextureWidth;\n		uniform int boneTextureHeight;\n\n		mat4 getBoneMatrix( const in float i ) {\n\n			float j = i * 4.0;\n			float x = mod( j, float( boneTextureWidth ) );\n			float y = floor( j / float( boneTextureWidth ) );\n\n			float dx = 1.0 / float( boneTextureWidth );\n			float dy = 1.0 / float( boneTextureHeight );\n\n			y = dy * ( y + 0.5 );\n\n			vec4 v1 = texture2D( boneTexture, vec2( dx * ( x + 0.5 ), y ) );\n			vec4 v2 = texture2D( boneTexture, vec2( dx * ( x + 1.5 ), y ) );\n			vec4 v3 = texture2D( boneTexture, vec2( dx * ( x + 2.5 ), y ) );\n			vec4 v4 = texture2D( boneTexture, vec2( dx * ( x + 3.5 ), y ) );\n\n			mat4 bone = mat4( v1, v2, v3, v4 );\n\n			return bone;\n\n		}\n\n	#else\n\n		uniform mat4 boneGlobalMatrices[ MAX_BONES ];\n\n		mat4 getBoneMatrix( const in float i ) {\n\n			mat4 bone = boneGlobalMatrices[ int(i) ];\n			return bone;\n\n		}\n\n	#endif\n\n#endif\n\n#ifdef USE_SHADOWMAP\n\n	varying vec4 vShadowCoord[ MAX_SHADOWS ];\n	uniform mat4 shadowMatrix[ MAX_SHADOWS ];\n\n#endif\n#ifdef USE_LOGDEPTHBUF\n\n	#ifdef USE_LOGDEPTHBUF_EXT\n\n		varying float vFragDepth;\n\n	#endif\n\n	uniform float logDepthBufFC;\n\n#endif\nvoid main() {\n#if defined( USE_MAP ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( USE_SPECULARMAP ) || defined( USE_ALPHAMAP )\n\n	vUv = uv * offsetRepeat.zw + offsetRepeat.xy;\n\n#endif\n#ifdef USE_LIGHTMAP\n\n	vUv2 = uv2;\n\n#endif\n#ifdef USE_COLOR\n\n	#ifdef GAMMA_INPUT\n\n		vColor = color * color;\n\n	#else\n\n		vColor = color;\n\n	#endif\n\n#endif\n#ifdef USE_MORPHNORMALS\n\n	vec3 morphedNormal = vec3( 0.0 );\n\n	morphedNormal += ( morphNormal0 - normal ) * morphTargetInfluences[ 0 ];\n	morphedNormal += ( morphNormal1 - normal ) * morphTargetInfluences[ 1 ];\n	morphedNormal += ( morphNormal2 - normal ) * morphTargetInfluences[ 2 ];\n	morphedNormal += ( morphNormal3 - normal ) * morphTargetInfluences[ 3 ];\n\n	morphedNormal += normal;\n\n#endif\n#ifdef USE_SKINNING\n\n	mat4 boneMatX = getBoneMatrix( skinIndex.x );\n	mat4 boneMatY = getBoneMatrix( skinIndex.y );\n	mat4 boneMatZ = getBoneMatrix( skinIndex.z );\n	mat4 boneMatW = getBoneMatrix( skinIndex.w );\n\n#endif\n#ifdef USE_SKINNING\n\n	mat4 skinMatrix = mat4( 0.0 );\n	skinMatrix += skinWeight.x * boneMatX;\n	skinMatrix += skinWeight.y * boneMatY;\n	skinMatrix += skinWeight.z * boneMatZ;\n	skinMatrix += skinWeight.w * boneMatW;\n	skinMatrix  = bindMatrixInverse * skinMatrix * bindMatrix;\n\n	#ifdef USE_MORPHNORMALS\n\n	vec4 skinnedNormal = skinMatrix * vec4( morphedNormal, 0.0 );\n\n	#else\n\n	vec4 skinnedNormal = skinMatrix * vec4( normal, 0.0 );\n\n	#endif\n\n#endif\n\n#ifdef USE_SKINNING\n\n	vec3 objectNormal = skinnedNormal.xyz;\n\n#elif defined( USE_MORPHNORMALS )\n\n	vec3 objectNormal = morphedNormal;\n\n#else\n\n	vec3 objectNormal = normal;\n\n#endif\n\n#ifdef FLIP_SIDED\n\n	objectNormal = -objectNormal;\n\n#endif\n\nvec3 transformedNormal = normalMatrix * objectNormal;\n\n#ifdef USE_MORPHTARGETS\n\n	vec3 morphed = vec3( 0.0 );\n	morphed += ( morphTarget0 - position ) * morphTargetInfluences[ 0 ];\n	morphed += ( morphTarget1 - position ) * morphTargetInfluences[ 1 ];\n	morphed += ( morphTarget2 - position ) * morphTargetInfluences[ 2 ];\n	morphed += ( morphTarget3 - position ) * morphTargetInfluences[ 3 ];\n\n	#ifndef USE_MORPHNORMALS\n\n	morphed += ( morphTarget4 - position ) * morphTargetInfluences[ 4 ];\n	morphed += ( morphTarget5 - position ) * morphTargetInfluences[ 5 ];\n	morphed += ( morphTarget6 - position ) * morphTargetInfluences[ 6 ];\n	morphed += ( morphTarget7 - position ) * morphTargetInfluences[ 7 ];\n\n	#endif\n\n	morphed += position;\n\n#endif\n#ifdef USE_SKINNING\n\n	#ifdef USE_MORPHTARGETS\n\n	vec4 skinVertex = bindMatrix * vec4( morphed, 1.0 );\n\n	#else\n\n	vec4 skinVertex = bindMatrix * vec4( position, 1.0 );\n\n	#endif\n\n	vec4 skinned = vec4( 0.0 );\n	skinned += boneMatX * skinVertex * skinWeight.x;\n	skinned += boneMatY * skinVertex * skinWeight.y;\n	skinned += boneMatZ * skinVertex * skinWeight.z;\n	skinned += boneMatW * skinVertex * skinWeight.w;\n	skinned  = bindMatrixInverse * skinned;\n\n#endif\n\n#ifdef USE_SKINNING\n\n	vec4 mvPosition = modelViewMatrix * skinned;\n\n#elif defined( USE_MORPHTARGETS )\n\n	vec4 mvPosition = modelViewMatrix * vec4( morphed, 1.0 );\n\n#else\n\n	vec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\n\n#endif\n\ngl_Position = projectionMatrix * mvPosition;\n\n#ifdef USE_LOGDEPTHBUF\n\n	gl_Position.z = log2(max(1e-6, gl_Position.w + 1.0)) * logDepthBufFC;\n\n	#ifdef USE_LOGDEPTHBUF_EXT\n\n		vFragDepth = 1.0 + gl_Position.w;\n\n#else\n\n		gl_Position.z = (gl_Position.z - 1.0) * gl_Position.w;\n\n	#endif\n\n#endif\n#if defined( USE_ENVMAP ) || defined( PHONG ) || defined( LAMBERT ) || defined ( USE_SHADOWMAP )\n\n	#ifdef USE_SKINNING\n\n		vec4 worldPosition = modelMatrix * skinned;\n\n	#elif defined( USE_MORPHTARGETS )\n\n		vec4 worldPosition = modelMatrix * vec4( morphed, 1.0 );\n\n	#else\n\n		vec4 worldPosition = modelMatrix * vec4( position, 1.0 );\n\n	#endif\n\n#endif\n\n#if defined( USE_ENVMAP ) && ! defined( USE_BUMPMAP ) && ! defined( USE_NORMALMAP ) && ! defined( PHONG )\n\n	vec3 worldNormal = mat3( modelMatrix[ 0 ].xyz, modelMatrix[ 1 ].xyz, modelMatrix[ 2 ].xyz ) * objectNormal;\n	worldNormal = normalize( worldNormal );\n\n	vec3 cameraToVertex = normalize( worldPosition.xyz - cameraPosition );\n\n	#ifdef ENVMAP_MODE_REFLECTION\n\n		vReflect = reflect( cameraToVertex, worldNormal );\n\n	#else\n\n		vReflect = refract( cameraToVertex, worldNormal, refractionRatio );\n\n	#endif\n\n#endif\n\nvLightFront = vec3( 0.0 );\n\n#ifdef DOUBLE_SIDED\n\n	vLightBack = vec3( 0.0 );\n\n#endif\n\ntransformedNormal = normalize( transformedNormal );\n\n#if MAX_DIR_LIGHTS > 0\n\nfor( int i = 0; i < MAX_DIR_LIGHTS; i ++ ) {\n\n	vec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\n	vec3 dirVector = normalize( lDirection.xyz );\n\n	float dotProduct = dot( transformedNormal, dirVector );\n	vec3 directionalLightWeighting = vec3( max( dotProduct, 0.0 ) );\n\n	#ifdef DOUBLE_SIDED\n\n		vec3 directionalLightWeightingBack = vec3( max( -dotProduct, 0.0 ) );\n\n		#ifdef WRAP_AROUND\n\n			vec3 directionalLightWeightingHalfBack = vec3( max( -0.5 * dotProduct + 0.5, 0.0 ) );\n\n		#endif\n\n	#endif\n\n	#ifdef WRAP_AROUND\n\n		vec3 directionalLightWeightingHalf = vec3( max( 0.5 * dotProduct + 0.5, 0.0 ) );\n		directionalLightWeighting = mix( directionalLightWeighting, directionalLightWeightingHalf, wrapRGB );\n\n		#ifdef DOUBLE_SIDED\n\n			directionalLightWeightingBack = mix( directionalLightWeightingBack, directionalLightWeightingHalfBack, wrapRGB );\n\n		#endif\n\n	#endif\n\n	vLightFront += directionalLightColor[ i ] * directionalLightWeighting;\n\n	#ifdef DOUBLE_SIDED\n\n		vLightBack += directionalLightColor[ i ] * directionalLightWeightingBack;\n\n	#endif\n\n}\n\n#endif\n\n#if MAX_POINT_LIGHTS > 0\n\n	for( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\n\n		vec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\n		vec3 lVector = lPosition.xyz - mvPosition.xyz;\n\n		float lDistance = 1.0;\n		if ( pointLightDistance[ i ] > 0.0 )\n			lDistance = 1.0 - min( ( length( lVector ) / pointLightDistance[ i ] ), 1.0 );\n\n		lVector = normalize( lVector );\n		float dotProduct = dot( transformedNormal, lVector );\n\n		vec3 pointLightWeighting = vec3( max( dotProduct, 0.0 ) );\n\n		#ifdef DOUBLE_SIDED\n\n			vec3 pointLightWeightingBack = vec3( max( -dotProduct, 0.0 ) );\n\n			#ifdef WRAP_AROUND\n\n				vec3 pointLightWeightingHalfBack = vec3( max( -0.5 * dotProduct + 0.5, 0.0 ) );\n\n			#endif\n\n		#endif\n\n		#ifdef WRAP_AROUND\n\n			vec3 pointLightWeightingHalf = vec3( max( 0.5 * dotProduct + 0.5, 0.0 ) );\n			pointLightWeighting = mix( pointLightWeighting, pointLightWeightingHalf, wrapRGB );\n\n			#ifdef DOUBLE_SIDED\n\n				pointLightWeightingBack = mix( pointLightWeightingBack, pointLightWeightingHalfBack, wrapRGB );\n\n			#endif\n\n		#endif\n\n		vLightFront += pointLightColor[ i ] * pointLightWeighting * lDistance;\n\n		#ifdef DOUBLE_SIDED\n\n			vLightBack += pointLightColor[ i ] * pointLightWeightingBack * lDistance;\n\n		#endif\n\n	}\n\n#endif\n\n#if MAX_SPOT_LIGHTS > 0\n\n	for( int i = 0; i < MAX_SPOT_LIGHTS; i ++ ) {\n\n		vec4 lPosition = viewMatrix * vec4( spotLightPosition[ i ], 1.0 );\n		vec3 lVector = lPosition.xyz - mvPosition.xyz;\n\n		float spotEffect = dot( spotLightDirection[ i ], normalize( spotLightPosition[ i ] - worldPosition.xyz ) );\n\n		if ( spotEffect > spotLightAngleCos[ i ] ) {\n\n			spotEffect = max( pow( max( spotEffect, 0.0 ), spotLightExponent[ i ] ), 0.0 );\n\n			float lDistance = 1.0;\n			if ( spotLightDistance[ i ] > 0.0 )\n				lDistance = 1.0 - min( ( length( lVector ) / spotLightDistance[ i ] ), 1.0 );\n\n			lVector = normalize( lVector );\n\n			float dotProduct = dot( transformedNormal, lVector );\n			vec3 spotLightWeighting = vec3( max( dotProduct, 0.0 ) );\n\n			#ifdef DOUBLE_SIDED\n\n				vec3 spotLightWeightingBack = vec3( max( -dotProduct, 0.0 ) );\n\n				#ifdef WRAP_AROUND\n\n					vec3 spotLightWeightingHalfBack = vec3( max( -0.5 * dotProduct + 0.5, 0.0 ) );\n\n				#endif\n\n			#endif\n\n			#ifdef WRAP_AROUND\n\n				vec3 spotLightWeightingHalf = vec3( max( 0.5 * dotProduct + 0.5, 0.0 ) );\n				spotLightWeighting = mix( spotLightWeighting, spotLightWeightingHalf, wrapRGB );\n\n				#ifdef DOUBLE_SIDED\n\n					spotLightWeightingBack = mix( spotLightWeightingBack, spotLightWeightingHalfBack, wrapRGB );\n\n				#endif\n\n			#endif\n\n			vLightFront += spotLightColor[ i ] * spotLightWeighting * lDistance * spotEffect;\n\n			#ifdef DOUBLE_SIDED\n\n				vLightBack += spotLightColor[ i ] * spotLightWeightingBack * lDistance * spotEffect;\n\n			#endif\n\n		}\n\n	}\n\n#endif\n\n#if MAX_HEMI_LIGHTS > 0\n\n	for( int i = 0; i < MAX_HEMI_LIGHTS; i ++ ) {\n\n		vec4 lDirection = viewMatrix * vec4( hemisphereLightDirection[ i ], 0.0 );\n		vec3 lVector = normalize( lDirection.xyz );\n\n		float dotProduct = dot( transformedNormal, lVector );\n\n		float hemiDiffuseWeight = 0.5 * dotProduct + 0.5;\n		float hemiDiffuseWeightBack = -0.5 * dotProduct + 0.5;\n\n		vLightFront += mix( hemisphereLightGroundColor[ i ], hemisphereLightSkyColor[ i ], hemiDiffuseWeight );\n\n		#ifdef DOUBLE_SIDED\n\n			vLightBack += mix( hemisphereLightGroundColor[ i ], hemisphereLightSkyColor[ i ], hemiDiffuseWeightBack );\n\n		#endif\n\n	}\n\n#endif\n\nvLightFront = vLightFront * diffuse + ambient * ambientLightColor + emissive;\n\n#ifdef DOUBLE_SIDED\n\n	vLightBack = vLightBack * diffuse + ambient * ambientLightColor + emissive;\n\n#endif\n#ifdef USE_SHADOWMAP\n\n	for( int i = 0; i < MAX_SHADOWS; i ++ ) {\n\n		vShadowCoord[ i ] = shadowMatrix[ i ] * worldPosition;\n\n	}\n\n#endif\n}";
THREE.ShaderChunk['particleFragment'] = "uniform sampler2D texture;\nvarying vec3 p;\n\nvoid main() {\n	vec2 uv = vec2( gl_PointCoord.x, 1.0 - gl_PointCoord.y );\n	vec4 tex = texture2D( texture, uv );\n	gl_FragColor = vec4(p, tex.a);\n}";
THREE.ShaderChunk['particleVertex'] = "#define BOTTOM -0.08\n#define TOP 0.77\n\nuniform float t;\nuniform float e;\nvarying vec3 p;\n\n\nfloat cubicOut(float t) {\n  float f = t - 1.0;\n  return f * f * f + 1.0;\n}\n\nfloat cubicInOut(float t) {\n  return t < 0.5\n    ? 4.0 * t * t * t\n    : 0.5 * pow(2.0 * t - 2.0, 3.0) + 1.0;\n}\n\nvoid main() {\n\n	vec3 pos = position;\n\n	p = vec3(0.0, 1.0, 0.0);\n\n	float height = clamp((pos.y - BOTTOM) / (TOP - BOTTOM), 0.0, 1.0);\n	p.r = height;\n\n	vec3 explosionPoint = vec3( 0, pos.y, 0.0 );\n	vec3 movement = normalize(pos - explosionPoint);\n	float easedTime = cubicInOut(t);\n	float diff = (height - easedTime);\n\n	if(diff > 0.3) {\n		pos.y = -2.0;\n\n	} else if( diff > 0.0 && diff < 0.3 ) {\n		//pos.y -= 1.0 * (diff * (1.0 / 0.3));\n		pos += movement * (diff * (1.0 / 0.3)) * 0.6;\n	}\n\n	if(e > 0.00001) {\n		vec3 explodeFrom = vec3(-0.02, 0.35, 0.13);\n		vec3 epd = normalize(pos - explodeFrom);\n		float distanceFromExplosion = distance(explodeFrom, pos);\n		if(distanceFromExplosion < e) {\n			float diff2 = e - distanceFromExplosion;\n			pos += epd * diff2 * 1.5;\n		}\n	}\n\n	vec4 mvPosition = modelViewMatrix * vec4( pos, 1.0 );\n	gl_PointSize = 10.0 * ( 50.0 / length(mvPosition.xyz));\n	gl_Position = projectionMatrix * mvPosition;\n}";
THREE.ShaderChunk['platform_vertex_main'] = "vec3 pos = position;\nvec4 pos4;\nfloat anim = time;\n\nvec3 center = vec3(0.0, 0.0, 0.0);\n\nfloat distToCenter2 = distance(center, endPosition);\nfloat furthestAway = distance(center, lowestPoint);\n\nfloat pct = distToCenter/furthestAway;\n\nfloat transitionTime = 0.2;\n\n// Figure out in what sequence the spheres should come flying.\nfloat n = smoothstep(pct,pct+transitionTime,anim*(1.0+transitionTime));\n\nn = smoothstep(0.0, 1.0, n);\n\n//pos = pos + endPosition;\n\nfloat Angle = n*10.0;\n\nmat4 RotationMatrix = mat4( cos( Angle ), -sin( Angle ), 0.0, 0.0,\n	sin( Angle ),  cos( Angle ), 0.0, 0.0,\n	0.0, 0.0, 1.0, 0.0,\n	0.0, 0.0, 0.0, 1.0 );\n\n\n\npos4 = vec4(pos, 1.0);\n//pos4 = RotationMatrix * pos4;\n\n\n\n\n\n\npos4.y = pos4.y + ( endPosition.y*n + -150.0*(1.0-n) );\n\n\n\npos4.x = pos4.x + endPosition.x*n;\npos4.z = pos4.z + endPosition.z*n;\n\n//float rotx = sin(time*100.0 + pos.x*10.0)*2.0;\n//float rotz = cos(time*100.0 + pos.z*10.0)*2.0;\n\n//pos.x = pos.x + (endPosition.x*smoothstep(0.0,1.0,n));\n//pos.z = pos.z + (endPosition.z*smoothstep(0.0,1.0,n));\n\n//pos.x = pos.x + (endPosition.x*n + rotx*(1.0-n));\n//pos.z = pos.z + (endPosition.z*n + rotz*(1.0-n));\n\n//pos4 = vec4(pos, 1.0);\n\n//pos4 = RotationMatrix * pos4;\n\ngl_Position = projectionMatrix * modelViewMatrix * pos4;\n\nvColor = vec3(0.475, 0.221, 0.0);";
THREE.ShaderChunk['raymarchFragment-julia'] = "// Intersects a ray with the qj set w/ parameter mu and returns\n// the color of the phong shaded surface (estimate)\n// (Surface also colored by normal direction)\n\n//  Adapted by Nicolas Garcia Belmonte from original work by Keenan Crane (kcrane@uiuc.edu)\n\n#ifdef GL_ES\nprecision highp float;\n#endif\n\n// Some constants used in the ray tracing process.  (These constants\n// were determined through trial and error and are not by any means\n// optimal.)\n\n\n// radius of a bounding sphere for the set used to accelerate intersection\n#define BOUNDING_RADIUS_2  5.0\n\n// any series whose points' magnitude exceed this threshold are considered divergent\n#define ESCAPE_THRESHOLD   7.0\n\n// delta is used in the finite difference approximation of the gradient (to determine normals)\n#define DEL                0.0001\n\n#define MAX_ITERATIONS     10\n\n\n// --------- quaternion representation -----------------------------------------\n\n// Each quaternion can be specified by four scalars q = A + Bi + Cj + Dk, so are\n// stored as a vec4.  I've tried a struct containing a separate scalar and\n// 3-vector to avoid a lot of swizzling, but the vec4 representation ends up\n// using fewer instructions.  A matrix representation is also possible.\n\n\n\n// -------- quatMult() ----------------------------------------------------------\n\n// Returns the product of quaternions q1 and q2.\n// Note that quaternion multiplication is NOT commutative (i.e., q1 ** q2 != q2 ** q1 ).\n\n\nvec4 quatMult( vec4 q1, vec4 q2 ) {\n   vec4 r;\n\n   r.x   = q1.x * q2.x - dot( q1.yzw, q2.yzw );\n   r.yzw = q1.x * q2.yzw + q2.x * q1.yzw + cross( q1.yzw, q2.yzw );\n\n   return r;\n}\n\n// ------- quatSq() --------------------------------------------------------------\n\n// Returns the square of quaternion q.  This function is a special (optimized)\n// case of quatMult().\n\n\nvec4 quatSq( vec4 q ) {\n   vec4 r;\n\n   r.x   = q.x * q.x - dot( q.yzw, q.yzw );\n   r.yzw = 2.0 * q.x * q.yzw;\n\n   return r;\n}\n\n\n// ------- iterateIntersect() -----------------------------------------------------\n\n// Iterates the quaternion q for the purposes of intersection.  This function also\n// produces an estimate of the derivative at q, which is required for the distance\n// estimate.  The quaternion c is the parameter specifying the Julia set, and the\n// integer maxIterations is the maximum number of iterations used to determine\n// whether a point is in the set or not.\n\n// To estimate membership in the set, we recursively evaluate\n\n// q = q*q + c\n\n// until q has a magnitude greater than the threshold value (i.e., it probably\n// diverges) or we've reached the maximum number of allowable iterations (i.e.,\n// it probably converges).  More iterations reveal greater detail in the set.\n\n// To estimate the derivative at q, we recursively evaluate\n\n// q' = 2*q*q'\n\n// concurrently with the evaluation of q.\n\n\n\nvoid iterateIntersect( inout vec4 q, inout vec4 qp, vec4 c, int maxIterations ) {\n   for( int i = 0; i < MAX_ITERATIONS; i++ ) {\n      if ( i >= maxIterations ) {\n        break;\n      }\n      qp = 2.0 * quatMult(q, qp);\n      q = quatSq(q) + c;\n\n      if( dot( q, q ) > ESCAPE_THRESHOLD ) {\n         break;\n      }\n   }\n}\n\n// ----------- normEstimate() -------------------------------------------------------\n\n// Create a shading normal for the current point.  We use an approximate normal of\n// the isosurface of the potential function, though there are other ways to\n// generate a normal (e.g., from an isosurface of the potential function).\n\n\nvec3 normEstimate(vec3 p, vec4 c, int maxIterations ) {\n   vec3 N;\n   vec4 qP = vec4( p, 0.0 );\n   float gradX, gradY, gradZ;\n\n   vec4 gx1 = qP - vec4( DEL, 0.0, 0.0, 0.0 );\n   vec4 gx2 = qP + vec4( DEL, 0.0, 0.0, 0.0 );\n   vec4 gy1 = qP - vec4( 0.0, DEL, 0.0, 0.0 );\n   vec4 gy2 = qP + vec4( 0.0, DEL, 0.0, 0.0 );\n   vec4 gz1 = qP - vec4( 0.0, 0.0, DEL, 0.0 );\n   vec4 gz2 = qP + vec4( 0.0, 0.0, DEL, 0.0 );\n\n   for( int i = 0; i < MAX_ITERATIONS; i++ ) {\n      if ( i >= maxIterations ) {\n        break;\n      }\n      gx1 = quatSq( gx1 ) + c;\n      gx2 = quatSq( gx2 ) + c;\n      gy1 = quatSq( gy1 ) + c;\n      gy2 = quatSq( gy2 ) + c;\n      gz1 = quatSq( gz1 ) + c;\n      gz2 = quatSq( gz2 ) + c;\n   }\n\n   gradX = length(gx2) - length(gx1);\n   gradY = length(gy2) - length(gy1);\n   gradZ = length(gz2) - length(gz1);\n\n   N = normalize(vec3( gradX, gradY, gradZ ));\n\n   return N;\n}\n\n\n// ---------- intersectQJulia() ------------------------------------------\n\n// Finds the intersection of a ray with origin rO and direction rD with the\n// quaternion Julia set specified by quaternion constant c.  The intersection\n// is found using iterative sphere tracing, which takes a conservative step\n// along the ray at each iteration by estimating the minimum distance between\n// the current ray origin and the closest point in the Julia set.  The\n// parameter maxIterations is passed on to iterateIntersect() which determines\n// whether the current ray origin is in (or near) the set.\n\n\nfloat intersectQJulia( inout vec3 rO, inout vec3 rD, vec4 c, int maxIterations, float epsilon ) {\n   float dist; // the (approximate) distance between the first point along the ray within\n               // epsilon of some point in the Julia set, or the last point to be tested if\n               // there was no intersection.\n\n   for(int j = 0; j < 25; ++j) {\n      \n      vec4 z = vec4( rO, 0.0 );             // iterate on the point at the current ray origin.  We\n                                          // want to know if this point belongs to the set.\n\n      vec4 zp = vec4( 1, 0.0, 0.0, 0.0 );       // start the derivative at real 1.  The derivative is\n                                          // needed to get a lower bound on the distance to the set.\n\n      // iterate this point until we can guess if the sequence diverges or converges.\n      iterateIntersect( z, zp, c, maxIterations );\n\n      // find a lower bound on the distance to the Julia set and step this far along the ray.\n      float normZ = length( z );\n      dist = 0.5 * normZ * log( normZ ) / length( zp );  //lower bound on distance to surface\n\n      rO += rD * dist; // (step)\n\n      // Intersection testing finishes if we're close enough to the surface\n      // (i.e., we're inside the epsilon isosurface of the distance estimator\n      // function) or have left the bounding sphere.\n      if( dist < epsilon || dot(rO, rO) > BOUNDING_RADIUS_2 ) {\n         break;\n      }\n   }\n\n   // return the distance for this ray\n   return dist;\n}\n\n// ----------- Phong() --------------------------------------------------\n//\n// Computes the direct illumination for point pt with normal N due to\n// a point light at light and a viewer at eye.\n//\n\nvec3 Phong( vec3 light, vec3 eye, vec3 pt, vec3 N ) {\n   vec3 diffuse = vec3( 0.1, 0.45, 1.00 );     // base color of shading\n   float specularExponent = 10.0;             // shininess of shading\n   float specularity = 0.45;              // amplitude of specular highlight\n\n   vec3 L     = normalize( light - pt );  // find the vector to the light\n   vec3 E     = normalize( eye   - pt );  // find the vector to the eye\n   float  NdotL = dot( N, L );            // find the cosine of the angle between light and normal\n   vec3 R     = L - 2.0 * NdotL * N;        // find the reflected vector\n\n   diffuse += abs( N ) * 0.3;  // add some of the normal to the\n                             // color to make it more interesting\n\n   // compute the illumination using the Phong equation\n   return diffuse * max( NdotL, 0.0 ) + specularity * pow( max( dot( E, R ), 0.0 ), specularExponent );\n}\n\n// ---------- intersectSphere() ---------------------------------------\n//\n// Finds the intersection of a ray with a sphere with statically\n// defined radius BOUNDING_RADIUS centered around the origin.  This\n// sphere serves as a bounding volume for the Julia set.\n\nvec3 intersectSphere( vec3 rO, vec3 rD ) {\n   float B, C, d, t0, t1, t;\n\n   B = 2.0 * dot( rO, rD );\n   C = dot( rO, rO ) - BOUNDING_RADIUS_2;\n   d = sqrt( B * B - 4.0 * C );\n   t0 = ( -B + d ) * 0.5;\n   t1 = ( -B - d ) * 0.5;\n   t = min( t0, t1 );\n   rO += t * rD;\n\n   return rO;\n}\n\n// ------------ main() -------------------------------------------------\n\n// Each fragment performs the intersection of a single ray with\n// the quaternion Julia set.  In the current implementation\n// the ray's origin and direction are passed in on texture\n// coordinates, but could also be looked up in a texture for a\n// more general set of rays.\n\n// The overall procedure for intersection performed in main() is:\n\n// -move the ray origin forward onto a bounding sphere surrounding the Julia set\n// -test the new ray for the nearest intersection with the Julia set\n// -if the ray does include a point in the set:\n//   -estimate the gradient of the potential function to get a normal\n//   -use the normal and other information to perform Phong shading\n//   -cast a shadow ray from the point of intersection to the light\n//   -if the shadow ray hits something, modify the Phong shaded color to represent shadow\n// -return the shaded color if there was a hit and the background color otherwise\n\n\nvec3 rO; // cameraPosition;\nvarying vec3 rD;\nuniform float iGlobalTime;\n\nconst bool renderShadows = true;\n//const vec4 mu = vec4( -1, 0.2, 0, 0 );       		// quaternion constant specifying the particular set\nuniform vec4 mu;      // quaternion constant specifying the particular set\nconst float epsilon = 0.005;        				// specifies precision of intersection\nconst vec3 light = vec3(10.0, 10.0, -10.0);  		// location of a single point light\nconst int maxIterations = 8; \nconst vec4 backgroundColor = vec4(1.0, 0.0, 0.0, 1.0); 				//background color\n\n\nvoid main() {\n   vec4 color;  // This color is the final output of our program.\n   vec3 rayDirection;\n   vec3 rayOrigin;\n\n   rO = cameraPosition * vec3(-1, 1, 1);\n\n   // Initially set the output color to the background color.  It will stay\n   // this way unless we find an intersection with the Julia set.\n   \n   color = backgroundColor;\n\n   // First, intersect the original ray with a sphere bounding the set, and\n   // move the origin to the point of intersection.  This prevents an\n   // unnecessarily large number of steps from being taken when looking for\n   // intersection with the Julia set.\n\n   rayDirection = normalize( rD );  //the ray direction is interpolated and may need to be normalized\n   rayOrigin = intersectSphere( rO, rayDirection );\n\n   // Next, try to find a point along the ray which intersects the Julia set.\n   // (More details are given in the routine itself.)\n   \n   // + vec4(0.5 + cos(iGlobalTime * 0.6) * 0.4, 0, 0.5 + sin(iGlobalTime) * 0.6, 0)\n   float dist = intersectQJulia( rayOrigin, rayDirection, mu, maxIterations, epsilon );\n\n   // We say that we found an intersection if our estimate of the distance to\n   // the set is smaller than some small value epsilon.  In this case we want\n   // to do some shading / coloring.\n   \n   if( dist < epsilon ) {\n\n      // Determine a surface normal which we'll use for lighting calculations.\n      vec3 N = normEstimate( rayOrigin, mu, maxIterations );\n\n      // Compute the Phong illumination at the point of intersection.\n      color.rgb = Phong( light, rayDirection, rayOrigin, N );\n      color.a = 1.0;  // (make this fragment opaque)\n\n      // If the shadow flag is on, determine if this point is in shadow\n      if( renderShadows == true ) {\n         // The shadow ray will start at the intersection point and go\n         // towards the point light.  We initially move the ray origin\n         // a little bit along this direction so that we don't mistakenly\n         // find an intersection with the same point again.\n\n         vec3 L = normalize( light - rayOrigin );\n         rayOrigin += N * epsilon * 2.0;\n         dist = intersectQJulia( rayOrigin, L, mu, maxIterations, epsilon );\n\n         // Again, if our estimate of the distance to the set is small, we say\n         // that there was a hit.  In this case it means that the point is in\n         // shadow and should be given darker shading.\n         if( dist < epsilon )\n            color.rgb *= 0.4;  // (darkening the shaded value is not really correct, but looks good)\n      }\n   }\n\n   // Return the final color which is still the background color if we didn't hit anything.\n   gl_FragColor = color;\n}\n\n\n";
THREE.ShaderChunk['raymarchFragment'] = "#define ITERATIONS 6\n\nuniform float iGlobalTime;\n\nvarying vec2 vUv;\nvarying vec3 N;\nvarying vec3 V;\n\nconst float PI = 3.14159265;\nvec2 iResolution = vec2(10.0, 10.0);\n\nmat3 rotationMatrix(vec3 axis, float angle)\n{\n	axis = normalize(axis);\n	float s = sin(angle);\n	float c = cos(angle);\n	float oc = 1.0 - c;\n	\n	return mat3(oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s,  \n				oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s,  \n				oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c);\n}\n\nvec3 rotateY(vec3 p, float angle)\n{\n	return p * rotationMatrix(vec3(0.0, 1.0, 0.0), angle);\n}\n\n// Floor\nvec2 obj_floor(in vec3 p)\n{\n	return vec2(p.y+10.0,0);\n}\n\nvec2 obj_torus(in vec3 p)\n{\n	p = rotateY(p, iGlobalTime);\n	vec2 r = vec2(2.1,0.5);\n	vec2 q = vec2(length(p.xy)-r.x,p.z);\n	float d = length(q) - r.y;\n	return vec2(d,1);\n}\n\nvec2 obj_union(in vec2 obj0, in vec2 obj1)\n{\n	if (obj0.x < obj1.x)\n		return obj0;\n	else\n		return obj1;\n}\n\nfloat smin( float a, float b)\n{\n	float k = 3.5;\n	float h = clamp( 0.5+0.5*(b-a)/k, 0.0, 1.0 );\n	return mix( b, a, h ) - k*h*(1.0-h);\n}\n\nvec2 op_blend( vec3 p, vec2 objA, vec2 objB )\n{\n	//float d1 = primitiveA(p);\n	//float d2 = primitiveB(p);\n	return vec2(smin( objA.x, objB.x ), 1);\n}\n\nvec2 op_sub(vec2 a, vec2 b)\n{\n	float d = max(a.x, -b.x);\n	return vec2(d,1);\n}\n\nvec2 obj_sphere(in vec3 p, in vec3 pos, in float size)\n{\n	p += pos;\n	float d = length(p) - size;\n	return vec2(d,1);\n}\n\nvec2 obj_round_box(vec3 p)\n{\n	//float f = 2.0 + p.z / 10.0;\n	//p = vec3(p.x, p.y, p.z);\n	vec3 size = vec3(5.0,5.0,5.0);\n	//p = rotateY(p, (p.y / 10.0) + (sin(iGlobalTime + f) * 2.0 * p.y));\n	float d = length(max(abs(p) - size, 0.0)) - 1.0;\n	return vec2(d,1);\n}\n\nvec2 obj_Quaternion(vec3 p)\n{\n	vec4 c1 = vec4(-0.2, 0.8, 0, 0); //vec4(0.18, 0.88, 0.24, 0.16);\n	vec4 c2 = vec4(-0.213,-0.0410,-0.563,-0.560);\n	//vec4 c2 = vec4(-0.445, 0.339, -0.0889, -0.562);\n\n	vec4 c = mix(c1, c2, iGlobalTime);\n\n	vec4 v = vec4(p, 0.0);\n	vec4 d = vec4(1.0, 0.0, 0.0, 0.0);\n\n	for(int n = 1; n < ITERATIONS; n++)\n	{\n		d = 2.0 * vec4(v.x * d.x - dot(v.xzw, d.yzw), v.x * d.yzw + d.x * v.yzw + cross(v.yzw, d.yzw));\n		v = vec4(v.x * v.x - dot(v.yzw, v.yzw), vec3(2.0 * v.x * v.yzw)) + c;\n\n		float r = dot(v,v);\n\n		if(r > 10.0) break;\n  }\n\n  float r = length(v);\n\n  return vec2(0.5 * r * log(r) / length(d), 1);\n}\n\nvec2 distance_to_obj(in vec3 p)\n{\n	//return obj_union(obj_floor(p), obj_union(obj_torus(p), op_sub(obj_round_box(p), obj_sphere(p))));\n	//return obj_union(obj_floor(p), obj_union(obj_sphere(p), obj_torus(p)));\n	//return obj_union(obj_floor(p), op_sub(obj_round_box(p), obj_sphere(p)));\n	//vec2 sa = obj_sphere(p, vec3(sin(iGlobalTime * 0.9) * 9.0, 0.0, cos(iGlobalTime * 0.6) * 4.0), 3.0 + sin(iGlobalTime * 0.2) * 3.0);\n	//vec2 sb = obj_sphere(p, vec3(sin(iGlobalTime * 0.3) * 10.0, cos(iGlobalTime * 0.2) * 7.0, 0.0), 4.0 + sin(iGlobalTime * 0.8) * 1.0);\n	//return op_blend(p, sa, sb);\n	return vec2(obj_Quaternion(p / 30.0).x * 30.0, 1);\n	//return op_blend(p, obj_round_box(p), obj_sphere(p));\n}\n\n//Floor Color (checkerboard)\nvec3 floor_color(in vec3 p)\n{\n	if (fract(p.x*0.2)>0.2)\n	{\n		if (fract(p.z*0.2)>0.2)\n			return vec3(0,0.1,0.2);\n		else\n			return vec3(1,1,1);\n	}\n	else\n	{\n		if (fract(p.z*.2)>.2)\n			return vec3(1,1,1);\n		else\n			return vec3(0.3,0,0);\n	}\n}\n\n// Primitive color\nvec3 prim_c(in vec3 p)\n{\n	return vec3(0.2, 0.2, 0.9) * 1.2;\n}\n\nvoid main() {\n\n	//vec2 vPos = fragCoord.xy/iResolution.xy - 0.5;\n	vec2 vPos = vUv - 0.5;\n\n	// Camera up vector.\n	vec3 vuv=vec3(0,1,0); \n  \n	// Camera lookat.\n	vec3 vrp=vec3(0,0,0);\n\n	//float mx=iMouse.x/iResolution.x*PI*2.0;\n	//float my=iMouse.y/iResolution.y*PI/2.01;\n	//mx = mod(iGlobalTime, 2.0 * PI);\n	//vec3 prp=vec3(cos(my)*cos(mx),sin(my),cos(my)*sin(mx))*20.0; \n	//vec3 prp = vec3(0.0, -20.0, 10.0);\n	vec3 prp = cameraPosition * vec3(-1.0, 1.0, 1.0);\n\n	// Camera setup.\n	vec3 vpn=normalize(vrp-prp);\n	vec3 u=normalize(cross(vuv,vpn));\n	vec3 v=cross(vpn,u);\n	vec3 vcv=(prp+vpn);\n	vec3 scrCoord = vcv + vPos.x * u * iResolution.x/iResolution.y + vPos.y * v;\n	vec3 scp=normalize(scrCoord-prp);\n\n	// Raymarching.\n	const vec3 e=vec3(0.02,0,0);\n	const float maxd=400.0; //Max depth\n	vec2 d=vec2(0.1,0.0);\n	vec3 c,p,N;\n\n	float f=1.0;\n	for(int i=0;i<256;i++)\n	{\n		if ((abs(d.x) < .001) || (f > maxd)) \n			break;\n\n		f+=d.x;\n		p=prp+scp*f;\n		d = distance_to_obj(p);\n	}\n  \n	if (f < maxd)\n	{\n		// y is used to manage materials.\n		if (d.y==0.0) \n			c=floor_color(p);\n		else\n			c=prim_c(p);\n\n		vec3 n = vec3(d.x-distance_to_obj(p-e.xyy).x,\n				  d.x-distance_to_obj(p-e.yxy).x,\n				  d.x-distance_to_obj(p-e.yyx).x);\n\n		N = normalize(n);\n\n		//vec3 L = vec3(sin(iGlobalTime) * 20.0, 10.0, cos(iGlobalTime) * 20.0);\n\n		vec3 L = vec3(7.0, 40.0, -40.0);\n		float b=dot(N,normalize(prp-p+L));\n\n		//simple phong lighting, LightPosition = CameraPosition\n		gl_FragColor = vec4((b * c + pow(b, 16.0)) * (1.0 - f * .01), 1.0);\n\n	} else {\n		gl_FragColor = vec4(0.0, 0.0, 0.0, 0.0); //background color\n	}\n}";
THREE.ShaderChunk['raymarchVertex-julia'] = "varying vec3 rD;\n\nvoid main() {\n	rD = normalize(-vec3(modelViewMatrix * vec4(position, 1.0)));\n	\n	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}";
THREE.ShaderChunk['raymarchVertex'] = "uniform float iGlobalTime;\n\nvarying vec2 vUv;\nvarying vec3 N;\nvarying vec3 V;\n\nvarying vec3 rD;\n\nvoid main() {\n	vUv = uv;\n\n	rD = (projectionMatrix * vec4(position, 1.0)).xyz;\n	\n	N = normalize(normalMatrix * normal); \n	V = normalize(-vec3(modelViewMatrix * vec4(position, 1.0)));\n\n	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}";
