#define BOTTOM -0.08
#define TOP 0.77

uniform float t;
uniform float e;
varying vec3 p;


float cubicOut(float t) {
  float f = t - 1.0;
  return f * f * f + 1.0;
}

float cubicInOut(float t) {
  return t < 0.5
    ? 4.0 * t * t * t
    : 0.5 * pow(2.0 * t - 2.0, 3.0) + 1.0;
}

void main() {

	vec3 pos = position;

	p = vec3(0.0, 1.0, 0.0);

	float height = clamp((pos.y - BOTTOM) / (TOP - BOTTOM), 0.0, 1.0);
	p.r = height;

	vec3 explosionPoint = vec3( 0, pos.y, 0.0 );
	vec3 movement = normalize(pos - explosionPoint);
	float easedTime = cubicInOut(t);
	float diff = (height - easedTime);

	if(diff > 0.3) {
		pos.y = -2.0;

	} else if( diff > 0.0 && diff < 0.3 ) {
		//pos.y -= 1.0 * (diff * (1.0 / 0.3));
		pos += movement * (diff * (1.0 / 0.3)) * 0.6;
	}

	if(e > 0.00001) {
		vec3 explodeFrom = vec3(-0.02, 0.35, 0.13);
		vec3 epd = normalize(pos - explodeFrom);
		float distanceFromExplosion = distance(explodeFrom, pos);
		if(distanceFromExplosion < e) {
			float diff2 = e - distanceFromExplosion;
			pos += epd * diff2 * 1.5;
		}
	}

	vec4 mvPosition = modelViewMatrix * vec4( pos, 1.0 );
	gl_PointSize = 10.0 * ( 50.0 / length(mvPosition.xyz));
	gl_Position = projectionMatrix * mvPosition;
}