uniform float t;
uniform float wiggle;
uniform vec3 skew;
varying vec2 vUv;

attribute vec3 fNormal;
varying vec3 N;
varying vec3 V;

#define PI 3.141592653589793

float ease(float t) {
  return -0.5 * (cos(PI * t) - 1.0);
}

void main() {
	vUv = uv;
	
	vec3 pos = position;
	float uf = (0.000001 + pos.z) / 20.0;

	pos.x += (sin(-wiggle * t + pos.z) * 0.7) * uf;
	pos.y += (sin(-wiggle * t + pos.z) * 0.7) * uf;

	pos += (skew * ease(uf));

	N = normalize(normalMatrix * fNormal); 
	V = normalize(-vec3(modelViewMatrix * vec4(pos, 1.0)));

	gl_Position = projectionMatrix * modelViewMatrix * vec4( pos, 1.0 );
}