"use strict";

var Scene = (function() {
	var lerp = function(s, e, p) {
		return s - ((s - e) * p);
	}

	return {
		id: getIdForLastLoadedScript(),
		load: function()
		{
			this.scene = new THREE.Scene();
			this.sceneLasers = new THREE.Scene();

			this.composer = new THREE.EffectComposer(renderer);
/*
			var ambient = new THREE.AmbientLight(0xffffff);
			ambient.color.setHSL(0.1, 0.3, 0.2);
			this.scene.add(ambient);

			var dirLight = new THREE.DirectionalLight(0xffffff, 0.125);
			dirLight.position.set(0, 10, -20 ).normalize();
			dirLight.color.setHSL(0.1, 0.7, 0.7);
			this.scene.add(dirLight);
*/
			var light = new THREE.PointLight(0xffffff, 1.5, 150);
			light.color.setHSL( 0.55, 0.9, 0.5 );
			light.position.set( 0, 10, 320 );
			this.scene.add( light );

			this.camera = new THREE.PerspectiveCamera(45, 16/9, 0.1, 2000);
			this.camera.position.set(0, 55, -300);
			this.camera.lookAt(new THREE.Vector3(0, 0, 0));

			var matWalls = new THREE.MeshLambertMaterial({
				ambient: 0x000000,
				color: 0x777777,
				emissive: 0x000000,
				shading: THREE.FlatShading,
				side: THREE.BackSide
			});

			var matBlack = new THREE.MeshBasicMaterial({
				color: 0x000000,
				side: THREE.BackSide
			});

			var matStage = new THREE.MeshLambertMaterial({
				specular: 0xf535c0,
				color: 0x000000,
				shading: THREE.FlatShading
			});

			this.matScreenL = new THREE.ShaderMaterial({ 
				uniforms: THREE.UniformsUtils.clone(THREE.ShaderLib.nightclubScreen.uniforms),
				vertexShader: THREE.ShaderLib.nightclubScreen.vertexShader,
				fragmentShader: THREE.ShaderLib.nightclubScreen.fragmentShader
			});

			this.matScreenR = new THREE.ShaderMaterial({ 
				uniforms: THREE.UniformsUtils.clone(THREE.ShaderLib.nightclubScreen.uniforms),
				vertexShader: THREE.ShaderLib.nightclubScreen.vertexShader,
				fragmentShader: THREE.ShaderLib.nightclubScreen.fragmentShader
			});

			this.matScreenR.uniforms.flipUv.value = 1;

			var pigs = [];
			var num_pigs = 10;
			var merge_mesh = new THREE.Mesh();
			for(var i=0; i< num_pigs; i++){
				pigs[i] = new THREE.Pig({ "skin_emissive": 0x000000, "eye_emissive": 0x000000 });

				var pigScale = Math.random() * (1.2 - 2.5) + 2.5;
				var position = new THREE.Vector3(
					Math.random() * (-170 - 170) + 170,
					-(120/2) + (4.48 * pigScale),
					Math.random() * (-270 - 270) + 270
				);

				var rotation = new THREE.Vector3(0, Math.PI, 0);

				var scale = new THREE.Vector3(
					pigScale, pigScale, pigScale
				);

				var pigBox = pigs[i].computeBoundingBox();
				console.log(pigBox.min.y + " " + pigBox.max.y);
				pigs[i].position.y = -(120/2) + (4.48 * pigScale);

				pigs[i].scale.copy(scale);
				pigs[i].position.copy(position);

				pigs[i].lookAt(new THREE.Vector3(0,0,700/2))
				pigs[i].rotation.y = Math.PI;

				this.scene.add(pigs[i]);
			}

			var geomScreen = new THREE.PlaneGeometry(160, 90, 32);

			var meshScreenL = new THREE.Mesh(geomScreen, this.matScreenL);
			var meshScreenR = new THREE.Mesh(geomScreen, this.matScreenR);

			var geomRoom = new THREE.BoxGeometry( 400, 120, 700, 12, 12, 12);
			var meshRoom = new THREE.Mesh(geomRoom, matWalls);
			this.scene.add(meshRoom);

			var meshRoomMask = new THREE.Mesh(geomRoom, matBlack);
			this.sceneLasers.add(meshRoomMask);

			var geomStage = new THREE.BoxGeometry( 200, 30, 90, 12, 12, 12);
			var meshStage = new THREE.Mesh(geomStage, matStage);
			meshStage.position.z = (700-40/2)/2 - 10;
			meshStage.position.y = -100/2;
			this.scene.add(meshStage);

			meshScreenL.rotation.y = Math.PI / 2 * (Math.PI * Math.PI);
			meshScreenL.position.y += 14;
			meshScreenL.position.z = (700-40/2)/2 - 20;
			meshScreenL.position.x = -(400/2)/2 - 20;
			this.scene.add(meshScreenL);

			meshScreenR.rotation.y = Math.PI / 2 * -(Math.PI * Math.PI);
			meshScreenR.position.y += 14;
			meshScreenR.position.z = (700-40/2)/2 - 20;
			meshScreenR.position.x = (400/2)/2 + 20;
			this.scene.add(meshScreenR);


			var laser = new THREE.LaserProjector({ laserCount: 15, color: 0x00ff00, spread: 0.025 });
			laser.position.copy(new THREE.Vector3(160, 59.8, 310));
			laser.rotation.copy(new THREE.Vector3(-0.4, 0.4, 0));

			this.laser_g = laser.clone();
			this.scene.add(this.laser_g);

			this.blurLaser_g = laser.clone();
			this.sceneLasers.add(this.blurLaser_g);


			var laser = new THREE.LaserProjector({ laserCount: 15, color: 0xff0000, spread: 0.025 });
			laser.position.copy(new THREE.Vector3(-160, 59.8, 310));
			laser.rotation.copy(new THREE.Vector3(-0.3, 0, -0.4));

			this.laser_r = laser.clone();
			this.scene.add(this.laser_r);

			this.blurLaser_r = laser.clone();
			this.sceneLasers.add(this.blurLaser_r);


			this.controls = new THREE.OrbitControls(this.camera);
			this.controls.damping = 0.2;
			this.controls.addEventListener( 'change', render );

/*
			var axisHelper = new THREE.AxisHelper(25);
			this.scene.add( axisHelper );

			var axisHelper2 = new THREE.AxisHelper(25);
			this.sceneLasers.add( axisHelper2 );
*/
			var laserRenderPass = new THREE.RenderPass(this.sceneLasers, this.camera);
			this.composer.addPass(laserRenderPass);

			var auroraBlurH = new THREE.ShaderPass(THREE.HorizontalBlurShader);
			auroraBlurH.uniforms.h.value = 1 / 2048;
			
			var auroraBlurV = new THREE.ShaderPass(THREE.VerticalBlurShader);
			auroraBlurV.uniforms.v.value = 1 / 2048;

			this.composer.addPass(auroraBlurH);
			this.composer.addPass(auroraBlurV);

			var bloomPass = new THREE.BloomPass(1);
			this.composer.addPass(bloomPass);

			var copyPass = new THREE.SavePass(buffer2);
			this.composer.addPass(copyPass);

			this.renderPass = new THREE.RenderPass(this.scene, this.camera);
			this.composer.addPass(this.renderPass);

			var blendPass = new THREE.ShaderPass(THREE.AdditiveBlendShader);
			blendPass.uniforms['tDiffuse2'].value = buffer2;
			this.composer.addPass(blendPass);

			this.fxaaPass = new THREE.ShaderPass(THREE.FXAAShader);
			this.fxaaPass.uniforms[ 'resolution' ].value = new THREE.Vector2( 1 / wWidth, 1 / wHeight );
			this.composer.addPass(this.fxaaPass);

			this.composer.addPass(final_pass);
		},

		render: function(time, percent)
		{
			this.matScreenL.uniforms.time.value = percent;
			this.matScreenR.uniforms.time.value = percent;

			this.laser_g.rotation.x = this.blurLaser_g.rotation.x = -.2 + (Math.sin(percent * 10 * Math.PI) * -0.2);
			this.laser_g.rotation.y = this.blurLaser_g.rotation.y = 0.2 + Math.sin(percent * 2 * Math.PI) * 0.4;

			this.laser_r.rotation.x = this.blurLaser_r.rotation.x = -.3 + (Math.sin(percent * 7 * Math.PI) * -0.1);
			this.laser_r.rotation.z = this.blurLaser_r.rotation.z = (percent * 6 * Math.PI);

			this.composer.render();
		}
	};
})();

var scenes = scenes || [];
scenes[Scene.id] = Scene;

THREE.ShaderLib.nightclubScreen = {
	"uniforms": THREE.UniformsUtils.merge([
		{ 
			"time": 	{ type: "f", value: 0.0 },
			"flipUv": 	{ type: "i", value: 0 }
		}
	]),
	"vertexShader": [
		"varying vec2 vUv;",
		"void main() {",
			"vUv = uv;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );",	
		"}"

	].join("\n"),

	"fragmentShader": [
		"varying vec2 vUv;",
		
		THREE.ShaderChunk['nightclubScreen_effects']

	].join("\n")
}