var Scene = (function() {
	var lerp = function(s, e, p) {
		return s - ((s - e) * p);
	}

	return {
		id: getIdForLastLoadedScript(),
		load: function()
		{
			this.scene = new THREE.Scene();
/*
			var ambient = new THREE.AmbientLight( 0xffffff );
			ambient.color.setHSL( 0.1, 0.3, 0.2 );
			this.scene.add( ambient );

			var dirLight = new THREE.DirectionalLight( 0xffffff, 0.125 );
			dirLight.position.set( 0, 10, -20 ).normalize();
			dirLight.color.setHSL( 0.1, 0.7, 0.7 );
			this.scene.add( dirLight );

			var light = new THREE.PointLight( 0xffffff, 1.5, 4500 );
			light.color.setHSL( 0.55, 0.9, 0.5 );
			light.position.set( -10, 10, -10 );
			this.scene.add( light );
*/
			var light = new THREE.HemisphereLight( 0xdfe1fc, 0x000000, .5 );
			light.position.y = 100;
			this.scene.add( light );

			var dirLight = new THREE.DirectionalLight( 0xffffff, 0.125 );
			dirLight.position.set( 10, 10, -20 );
			dirLight.color.setHSL( 0.1, 0.7, 0.7 );

			dirLight.castShadow = true;
			dirLight.shadowMapWidth = 2048;
			dirLight.shadowMapHeight = 2048;

			var d = 20;
			dirLight.shadowCameraLeft = -d;
			dirLight.shadowCameraRight = d;
			dirLight.shadowCameraTop = d;
			dirLight.shadowCameraBottom = -d;

			dirLight.shadowCameraNear = 0;
			dirLight.shadowCameraFar = 200;
			dirLight.shadowBias = -0.0001;
			dirLight.shadowDarkness = 0.35;
			//dirLight.shadowCameraVisible = true;

			this.scene.add( dirLight );

			var mat = new THREE.MeshLambertMaterial({
				ambient: 0x999999,
				color: 0xfd7a7b,
				emissive: 0x6a2323,
				shading: THREE.FlatShading
			});

			var green = new THREE.MeshLambertMaterial({
				ambient: 0x999999,
				color: 0x80a93f,
				emissive: 0x394c1c,
				shading: THREE.FlatShading
			});
			

			var ground = new THREE.Mesh(
				new THREE.BoxGeometry( 100, .1, 100 ), 
				mat
			);
			ground.receiveShadow = true;

			this.scene.add(ground);

/*
			this.sphere = new THREE.Mesh(
				new THREE.IcosahedronGeometry(3, 0),
				green
			);
			this.sphere.scale.y = 1.3;
			this.sphere.position.y = 15;
			this.sphere.castShadow = true;

			this.scene.add(this.sphere);
*/
			this.composer = new THREE.EffectComposer(renderer);

			this.camera = new THREE.PerspectiveCamera(45, 16/9, 0.1, 100);
			this.camera.position.set(20, 20, -30);
			this.camera.lookAt(new THREE.Vector3(0, 0, 0));

			controls = new THREE.OrbitControls( this.camera );
			controls.addEventListener( 'change', render );

			this.tre = new THREE.Busk({ "seed": 11, "leafCount": 6 });
			this.scene.add(this.tre);

			var axisHelper = new THREE.AxisHelper( 5 );
			axisHelper.position.copy(this.tre.position);
			this.scene.add( axisHelper );

			//var material = new THREE.MeshPhongMaterial( { ambient: 0x333333, color: 0xffffff, specular: 0xffffff, shininess: 50 } )
			
			this.renderPass = new THREE.RenderPass(this.scene, this.camera);
			this.composer.addPass(this.renderPass);
/*
			this.blurPass1 = new THREE.ShaderPass(THREE.VerticalBlurShader);
			this.blurPass1.uniforms["v"].value = 1 / wHeight;
			this.composer.addPass(this.blurPass1);

			this.blurPass2 = new THREE.ShaderPass(THREE.HorizontalBlurShader);
			this.blurPass2.uniforms["h"].value = 1 / wWidth;
			this.composer.addPass(this.blurPass2);
*/
			this.composer.addPass(final_pass);

			renderer.shadowMapEnabled = true;
			renderer.shadowMapType = THREE.PCFSoftShadowMap;
		},

		render: function(time, percent) 
		{
/*
			this.sphere.rotation.x = getVal("var1");
			this.sphere.rotation.y = getVal("var2");
*/
			this.tre.setAge(getVal("var5"));



			this.composer.render();
		}
	};
})();

var scenes = scenes || [];
scenes[Scene.id] = Scene;