var Scene = (function() {
	var lerp = function(s, e, p) {
		return s - ((s - e) * p);
	}

	return {
		id: getIdForLastLoadedScript(),
		load: function()
		{
			this.scene = new THREE.Scene();
/*
			var ambient = new THREE.AmbientLight( 0xffffff );
			ambient.color.setHSL( 0.1, 0.3, 0.2 );
			this.scene.add( ambient );

			var dirLight = new THREE.DirectionalLight( 0xffffff, 0.125 );
			dirLight.position.set( 0, 10, -20 ).normalize();
			dirLight.color.setHSL( 0.1, 0.7, 0.7 );
			this.scene.add( dirLight );

			var light = new THREE.PointLight( 0xffffff, 1.5, 4500 );
			light.color.setHSL( 0.55, 0.9, 0.5 );
			light.position.set( -10, 10, -10 );
			this.scene.add( light );
*/
		
		
			//this.scene.fog = new THREE.Fog(0xd1f2e9, 300,700);
		
			this.skyGeo = new THREE.SphereGeometry(1000, 30,30);
			this.skyMat = new THREE.MeshBasicMaterial({
				color: 0xd1f2e9,
				side: THREE.BackSide
			});
			this.sky = new THREE.Mesh(this.skyGeo, this.skyMat);
			this.sky.customOverrideMaterial = new THREE.MeshBasicMaterial({color:0x000000,side:THREE.BackSide});
			this.scene.add(this.sky);
		

			var size = 700;

		
			this.nothingGeo = new THREE.PlaneGeometry(size*1000, size*1000, 10, 10);
			this.nothingMat = new THREE.MeshBasicMaterial({
				color: 0xd1f2e9,
				side: THREE.DoubleSide
			});
			this.nothing = new THREE.Mesh(this.nothingGeo, this.nothingMat);
			this.nothing.customOverrideMaterial = new THREE.MeshBasicMaterial({color:0x000000});
			this.nothing.rotation.x = deg2rad(-90);
			/*this.nothingGeo = new THREE.BoxGeometry(size*1.1,0.1, size*1.1,1,1,1);
			this.nothingMat = new THREE.MeshBasicMaterial({
				//color: 0xd1f2e9,
				color: 0xffff00,
			});
			this.nothing = new THREE.Mesh(this.nothingGeo, this.nothingMat);*/
			this.scene.add(this.nothing);
		
			/*
			this.axishelper = new THREE.AxisHelper(5);
			this.axishelper.position.y = 20;
			this.scene.add(this.axishelper);
			*/

			var light = new THREE.HemisphereLight( 0xffffff, 0x000000, 1 );
			light.position.y = 100;
			this.scene.add( light );

			var light2 = new THREE.PointLight( 0xffffff, 0.9, 5000);
			light.position.set(100,100,100);
			this.scene.add(light2);

			this.mat = new THREE.MeshPhongMaterial({
					//ambient: 0xADFFB2,
					ambient: 0x999999,
					//color: 0x099723,
					//emissive: 0x099723,
					shading: THREE.FlatShading,
					//side: THREE.DoubleSide,
					wireframe: false,
					vertexColors: THREE.FaceColors,
					shininess: 10,
				});
		

			
			this.planeGeometry = new THREE.PlaneGeometry(size,size, 50,50)

			// Flip the ground so it becomes the ground
			for (var i=0; i < this.planeGeometry.vertices.length; i++)
			{
				var dong = this.planeGeometry.vertices[i].z;
				this.planeGeometry.vertices[i].z = this.planeGeometry.vertices[i].y*-1;
				this.planeGeometry.vertices[i].y = dong;
			}
		
			// Add noise prior to simplification
			for (var i=0; i < this.planeGeometry.vertices.length; i++)
			{
				var xz = new THREE.Vector2(this.planeGeometry.vertices[i].x,this.planeGeometry.vertices[i].z);
				this.planeGeometry.vertices[i].x += noise.simplex2(xz.x/550,xz.y/550)*2;
				this.planeGeometry.vertices[i].z += noise.simplex2(xz.x/520,xz.y/570)*2;

				//this.planeGeometry.vertices[i].yAfterPop = 20 + noise.simplex2(xz.x/21,xz.y/26)*5;
			}

			//this.planeGeometry = reduceGeometry(this.planeGeometry,0.7);
			this.planeGeometry = reduceGeometry(this.planeGeometry,0.8);
			
			for (var i=0; i < this.planeGeometry.vertices.length; i++)
			{
				
				this.planeGeometry.vertices[i].yAfterPop = this.planePointHeight(this.planeGeometry.vertices[i].x,this.planeGeometry.vertices[i].z);
			}




			// Calculate when the vertex should do it's initial pop-up

			var growCenter = new THREE.Vector2(0,0);
			var growRadius = 200;
			var popOrder;
			var highI, highMax=0;
			for (var i=0; i < this.planeGeometry.vertices.length; i++)
			{
			
				var xz = new THREE.Vector2(this.planeGeometry.vertices[i].x,this.planeGeometry.vertices[i].z);

				var distToCenter = growCenter.distanceTo(xz);
				this.planeGeometry.vertices[i].distToCenter = distToCenter;

				if (distToCenter < growRadius)
				{
					popOrder = (growRadius - distToCenter) / growRadius;
					var n = noise.simplex2(xz.x/5, xz.y/5)*0.5+0.5;
					popOrder = (popOrder-0.5)*-0.9+0.5;

					if (popOrder > highMax)
					{
						highMax = popOrder;
						highI = i*1;
					}
					this.planeGeometry.vertices[i].popOrder = popOrder;
				} else
				{
					this.planeGeometry.vertices[i].popOrder = 1;
				}


			}



			// Add trees

			var numTrees = 50;
			this.trees = [];
			randSeed(234);

			// Temporarily removed because of changes in Busk
			/*for (var i=0; i < numTrees; i++)
			{
				//var x = noise.simplex2(i*100, i*50)*150;
				//var z = noise.simplex2(i*120, i*30)*120 + 50;
				var x = randGet(100)*150;
				var z = randGet(120)*120 + 50;
				this.trees.push(new THREE.Busk({seed:2234+i}));
				this.trees[i].position.y = this.planePointHeight(x, z) - 1;
				this.trees[i].position.x = x;
				this.trees[i].position.z = z;
				this.trees[i].scale.y = 2;
				this.trees[i].scale.z = 2;
				this.trees[i].scale.x = 2;
				this.scene.add(this.trees[i]);
			}*/

			var treeCoords = [
				//{x:35, z:20},
				//{x:40, z:30}
			];

			// Fuck det er mas å plassere trær. ny approach.
			Math.seedrandom(668); // 666 var ikke en bra seed :/
			var ii = 11;
			for (var i=0; i<10; i++)
			{
				//var a = Math.random()*Math.PI*2;
				var a = Math.PI*2*(i/ii);
				var l = Math.floor(Math.random()*6)*10;
				var x = Math.sin(a)*l;
				var z = Math.cos(a)*l;
				treeCoords.push({x:x, z:z});
			}
			Math.seedrandom(669);
			var ii = 11;
			for (var i=0; i<10; i++)
			{
				//var a = Math.random()*Math.PI*2;
				var a = Math.PI*2*(i/ii);
				var l = Math.floor(Math.random()*6)*10;
				var x = 80+Math.sin(a)*l;
				var z = 100+Math.cos(a)*l;
				treeCoords.push({x:x, z:z});
			}
			Math.seedrandom(670);
			var ii = 11;
			for (var i=0; i<10; i++)
			{
				//var a = Math.random()*Math.PI*2;
				var a = Math.PI*2*(i/ii);
				var l = Math.floor(Math.random()*6)*10;
				var x = -100+Math.sin(a)*l;
				var z = 90+Math.cos(a)*l;
				treeCoords.push({x:x, z:z});
			}

			for (var i=0; i<treeCoords.length; i++)
			{
				var xz = treeCoords[i];

				this.trees.push(new THREE.Busk({seed:2234+i, leafCount: 3+Math.floor(Math.random()*4)}));
				this.trees[i].position.y = this.planePointHeight(xz.x, xz.z) - 1;
				this.trees[i].position.x = xz.x;
				this.trees[i].position.z = xz.z;
				this.trees[i].scale.y = 2;
				this.trees[i].scale.z = 2;
				this.trees[i].scale.x = 2;
				this.trees[i].setAge(1);
				this.scene.add(this.trees[i]);
			}


			// Add some rocks
			var rseed = 69;
			this.rocks = [];
			for (var i=0; i<25; i++)
			{
				Math.seedrandom(rseed++);
				var x = (Math.random()-0.5)*2*120;
				var z = 80+(Math.random()-0.5)*2*80;
				this.rocks.push(makeRock(3,Math.floor(Math.random()*5),100+i));
				this.rocks[i].position.y = this.planePointHeight(x, z);
				this.rocks[i].position.x = x;
				this.rocks[i].position.z = z;
				this.rocks[i].visible = false;
				this.scene.add(this.rocks[i]);
			}

			// Add a couple of clouds

			Math.seedrandom(123);
			this.cloud1 = new THREE.Cloud(false);
			this.cloud1.scale.set(0.4, 0.4, 0.4);
			this.cloud1.position.set(-70,70,0);
			this.scene.add(this.cloud1);
			this.cloud1WF = new THREE.Cloud(this.cloud1);
			this.cloud1WF.setWireFrame(true);
			this.cloud1WF.scale.set(0.4,0.4,0.4);
			this.cloud1WF.position.set(-70,70,0);
			this.scene.add(this.cloud1WF);

			Math.seedrandom(124);
			this.cloud2 = new THREE.Cloud(false);
			this.cloud2.scale.set(0.4, 0.4, 0.4);
			this.cloud2.position.set(70,70,50);
			this.cloud2.rotation.y.set=deg2rad(90);
			this.scene.add(this.cloud2)
			this.cloud2WF = new THREE.Cloud(this.cloud2);
			this.cloud2WF.setWireFrame(true);
			this.cloud2WF.scale.set(0.4,0.4,0.4);
			this.cloud2WF.position.set(70,70,50);
			this.scene.add(this.cloud2WF);

		



		/*
			// Add noise prior to simplification
			for (var i=0; i < this.planeGeometry.vertices.length; i++)
			{
				var xz = new THREE.Vector2(this.planeGeometry.vertices[i].x,this.planeGeometry.vertices[i].z);
				this.planeGeometry.vertices[i].x += noise.simplex2(xz.x/25,xz.z/25)*0.5;
				this.planeGeometry.vertices[i].y += noise.simplex2(xz.x/21,xz.z/26)*0.5;
				this.planeGeometry.vertices[i].z += noise.simplex2(xz.x/22,xz.z/27)*0.5;
			}

			//this.planeGeometry = reduceGeometry(this.planeGeometry,0.7);

		*/

			this.mountains = [
				{
					position: new THREE.Vector2(-50,-100),
					apex: 100,
					radius: 40,
					easing: 'easeInOutSine',

				},
				{
					position: new THREE.Vector2(50,-130),
					apex: 160,
					radius: 50,
					easing: 'easeInQuart',
					
				},
				{
					position: new THREE.Vector2(120,-20),
					apex: 70,
					radius: 50,
					easing: 'easeOutCubic',
					
				},
			];


		
			// Add some fjells and some noise
			for (var i=0; i < this.planeGeometry.vertices.length; i++)
			{
				var xz = new THREE.Vector2(this.planeGeometry.vertices[i].x,this.planeGeometry.vertices[i].z);
				this.planeGeometry.vertices[i].fjells = [];

				var fjelloffset = 0;
				var height = 0;
				for (var f=0; f < this.mountains.length; f++)
				{					
					var dist = this.mountains[f].position.distanceTo(xz);
					if (dist < this.mountains[f].radius)
					{
						// null, current_time, start_value, end_value, total_time)
						height = jQuery.easing[this.mountains[f].easing](null, (this.mountains[f].radius-dist), 0, this.mountains[f].apex, this.mountains[f].radius);
						height = (this.mountains[f].radius-dist)/this.mountains[f].radius * this.mountains[f].apex;
						//height = (this.mountains[f].radius - dist);
					}
					if (height > fjelloffset)
					{
					//	fjelloffset = height;
					}
					fjelloffset += height;

					this.planeGeometry.vertices[i].fjells.push(height);
				}


				//console.log(fjelloffset);
				
				var n2 = noise.simplex2(xz.x/25,xz.y/25);
				//console.log('n2' + n2);

				this.planeGeometry.vertices[i].yFjell = fjelloffset ;//+ n2;

				//console.log(this.planeGeometry.vertices[i].y);

			}

			//console.log(this.planeGeometry);
			

			for (var i=0; i < this.planeGeometry.faces.length; i++)
			{
				//this.planeGeometry.faces[i].color.setRGB(Math.random(), Math.random(), Math.random());
				this.planeGeometry.faces[i].color.setHex(0x6f7e36);
			}

			//console.log(this.planeGeometry.faces[1]);

			//this.planeGeometry = reduceGeometry(this.planeGeometry,0.7);



			this.planeGeometry.computeFaceNormals();
			this.planeGeometry.computeVertexNormals();

			this.plane = new THREE.Mesh(
				this.planeGeometry,
				this.mat
				//groundMaterial
			);



			/*this.tre = new THREE.Busk();
			this.tre.position.y=20;
			this.tre.scale.y = 10;
			this.tre.scale.z = 10;
			this.tre.scale.x = 10;*/
			//this.scene.add(this.tre);


			var pigPos = {x: 7, z: 120};

			this.pig = new THREE.Pig({ center: false });
			this.pig.position.y = 40;
			this.pig.position.x = pigPos.x;
			this.pig.position.z = pigPos.z;
			this.pig.pop = 40;
			//this.pig.rotation.y = deg2rad(180);
			this.pig.ground = this.planePointHeight(this.pig.position.x, this.pig.position.z);
			this.scene.add(this.pig);


			this.plane.position.y = -0.6;

			this.scene.add(this.plane);



			this.poof = new THREE.Poff(5,15,40,1);
			this.poof.position.x = pigPos.x;
			this.poof.position.z = pigPos.z;
			this.poof.position.y = 40;
			this.scene.add(this.poof);



			this.composer = new THREE.EffectComposer(renderer);

			this.camera = new THREE.PerspectiveCamera(45, 16/9, 5, 1500);
			

			//this.camera.position.set(0, 300, -300);
			//this.camera.position.set(-256, 96, -181);
			this.camera.position.set(0, 96, 350);
			
			this.camera.lookAt(new THREE.Vector3(0, 0, 0));
/*
			// Set up the depth pass for the SSAO shader
			var depthShader = THREE.ShaderLib[ "depthRGBA" ];
			var depthUniforms = THREE.UniformsUtils.clone( depthShader.uniforms );
			this.depthMaterial = new THREE.ShaderMaterial( { fragmentShader: depthShader.fragmentShader, vertexShader: depthShader.vertexShader, uniforms: depthUniforms } );
			this.depthTarget = new THREE.WebGLRenderTarget( 512, 512, { minFilter: THREE.LinearFilter, magFilter: THREE.LinearFilter, format: THREE.RGBAFormat } );


			// Init the SSAO shader and set up the correct uniforms
			this.ssao = new THREE.ShaderPass(THREE.SSAOShader);
			this.ssao.uniforms[ 'tDepth' ].value = this.depthTarget;
			this.ssao.uniforms[ 'size' ].value.set( 512, 512 );
			this.ssao.uniforms[ 'cameraNear' ].value = this.camera.near;
			this.ssao.uniforms[ 'cameraFar' ].value = this.camera.far;
			this.ssao.uniforms[ 'onlyAO' ].value = 1;
			this.composer.addPass(this.ssao);
*/

			this.renderPass = new THREE.RenderPass(this.scene, this.camera);
			this.composer.addPass(this.renderPass);


			// SSAO Depth
			this.depthShader = THREE.ShaderLib[ "depthRGBA" ];
			this.depthUniforms = THREE.UniformsUtils.clone( this.depthShader.uniforms );

			this.depthMaterial = new THREE.ShaderMaterial({
				fragmentShader: this.depthShader.fragmentShader,
				vertexShader: this.depthShader.vertexShader,
				uniforms: this.depthUniforms
			});
			this.depthMaterial.blending = THREE.NoBlending;

			this.depthTarget = new THREE.WebGLRenderTarget( wWidth, wHeight, {
				minFilter: THREE.NearestFilter,
				magFilter: THREE.NearestFilter,
				format: THREE.RGBAFormat
			});

			// Bokeh Depth
			this.depthBokehShader = THREE.ShaderLib[ "depth" ];
			this.depthBokehUniforms = THREE.UniformsUtils.clone( this.depthBokehShader.uniforms );

			this.depthBokehMaterial = new THREE.ShaderMaterial({
				fragmentShader: this.depthBokehShader.fragmentShader,
				vertexShader: this.depthBokehShader.vertexShader,
				uniforms: this.depthBokehUniforms
			});
			this.depthBokehMaterial.uniforms['mNear'].value = this.camera.near;
			this.depthBokehMaterial.uniforms['mFar'].value = this.camera.far / 3.5;
			this.depthBokehMaterial.blending = THREE.NoBlending;

			this.depthBokehTarget = new THREE.WebGLRenderTarget( wWidth, wHeight, {
				minFilter: THREE.NearestFilter,
				magFilter: THREE.NearestFilter,
				format: THREE.RGBAFormat
			});


			this.SSAOPass = new THREE.ShaderPass( THREE.SSAOShader );
			this.SSAOPass.uniforms[ 'tDepth' ].value = this.depthTarget;
			this.SSAOPass.uniforms[ 'size' ].value.set( wWidth * 0.75, wHeight * 0.75 );
			this.SSAOPass.uniforms[ 'cameraNear' ].value = this.camera.near;
			this.SSAOPass.uniforms[ 'cameraFar' ].value = this.camera.far;
			this.SSAOPass.uniforms[ 'aoClamp' ].value = 0.5;
			this.SSAOPass.enabled = false;
			this.composer.addPass( this.SSAOPass );


			this.bokehPass = new THREE.ShaderPass( THREE.BokehShader );
			this.bokehPass.uniforms[ 'tDepth' ].value = this.depthBokehTarget;
			this.bokehPass.uniforms[ 'aperture' ].value = 0.009;
			this.bokehPass.enabled = true;
			this.bokehPass.uniforms['focus'].value = 5;
			this.composer.addPass( this.bokehPass );

/*			 THREE.UniformsUtils.clone( bokehShader.uniforms )

			this.bokehPass = new THREE.BokehPass( this.scene, this.camera, {
					//focus: 		1.0,
					//aperture:	0.025,
					//maxblur:	1.0,
					focus: 		1.2,
					aperture:	0.125,
					maxblur:	10.5,

					width: wWidth,
					height: wHeight
			} );
*/
			


			this.fxaaPass = new THREE.ShaderPass(THREE.FXAAShader);
			this.fxaaPass.uniforms[ 'resolution' ].value = new THREE.Vector2( 1 / wWidth, 1 / wHeight );
			this.composer.addPass(this.fxaaPass);

			this.glitchPass = new THREE.GlitchPass();
			this.composer.addPass(this.glitchPass);
			
			this.composer.addPass(final_pass);

			this.controls = new THREE.OrbitControls( this.camera );
			this.controls.addEventListener('change',render);

			
			//this.nothing.name="fitteanus";
		},

		render: function(time, percent) 
		{
			//this.bokehPass.uniforms.focus.value = getVal('var5');

			this.bokehPass.uniforms['focus'].value = getVal('lens');

			this.camera.position.x = getVal('camx');
			this.camera.position.y = getVal('camy');
			this.camera.position.z = getVal('camz');

			this.camera.lookAt(new THREE.Vector3(getVal('cam2x'),getVal('cam2y'),getVal('cam2z')));
			

			this.glitchPass.goWild = getVal('var7') > 0.5 ? true : false;

			/*for (var i=0; i<this.planeGeometry.vertices.length; i++)
			{
				this.planeGeometry.vertices[i].y = Math.sin(i*time*0.01)*5 + Math.sin(i*time*0.02)*5;
			}*/

			// ==================================================================
			// Animate the clouds

			var nCloudWF = getVal('var6');
			this.cloud1WF.animate(easeOne('easeOutElastic',segmentTransition(0.0, 0.7, nCloudWF)));
			this.cloud2WF.animate(easeOne('easeOutElastic',segmentTransition(0.3, 1.0, nCloudWF)));

			var nCloud = getVal('var5');
			this.cloud1.animate(easeOne('easeOutElastic',nCloud));
			this.cloud2.animate(easeOne('easeOutElastic',nCloud));


			// ==================================================================
			// Animate the ground and the mountains

			var easingTime = 0.1;
			var easingEnd, easingStart,e,f;
			var fjell = [], fjelly;

			//var pct = getVal('percent')/100;
			pct = percent;
			var var1 = getVal('var1');

			for (var i=0; i < this.planeGeometry.vertices.length; i++)
			{

				e = segmentTransition(this.planeGeometry.vertices[i].popOrder, this.planeGeometry.vertices[i].popOrder+0.05, pct);
				
				
				e = easeOne('easeOutBounce',e);

				
				fjell[0] = this.planeGeometry.vertices[i].fjells[0] * easeOne('easeOutBounce',segmentTransition(0,0.25, var1));
				fjell[1] = this.planeGeometry.vertices[i].fjells[1] * easeOne('easeOutBounce',segmentTransition(0.3,0.6, var1));
				fjell[2] = this.planeGeometry.vertices[i].fjells[2] * easeOne('easeOutBounce',segmentTransition(0.75,1, var1));
				fjelly = Math.max(fjell[0],fjell[1],fjell[2]);
				

				this.planeGeometry.vertices[i].y = this.planeGeometry.vertices[i].yAfterPop * e + fjelly;
			}

			for (var fi=0; fi < this.planeGeometry.faces.length; fi++)
			{
				f = this.planeGeometry.faces[fi];

				if (Math.min(this.planeGeometry.vertices[f.a].y, this.planeGeometry.vertices[f.b].y, this.planeGeometry.vertices[f.c].y ) < 1)
				{
					this.planeGeometry.faces[fi].color.setHex(0x684300); // #AF6200
					//this.planeGeometry.faces[fi].color.setHex(0xff0000);	
				//} else if (Math.min(this.planeGeometry.vertices[f.a].y, this.planeGeometry.vertices[f.b].y, this.planeGeometry.vertices[f.c].y ) > 80)
				} else if ((this.planeGeometry.vertices[f.a].y + this.planeGeometry.vertices[f.b].y + this.planeGeometry.vertices[f.c].y )/3 > 70)
				{
					this.planeGeometry.faces[fi].color.setHex(0xffffff);	
				} else if (Math.max(this.planeGeometry.vertices[f.a].y, this.planeGeometry.vertices[f.b].y, this.planeGeometry.vertices[f.c].y ) > 30)
				{
					this.planeGeometry.faces[fi].color.setHex(0x818181);	
				} else
				{
					this.planeGeometry.faces[fi].color.setHex(0x008503); // #009206
				}

				//this.planeGeometry.faces[i].color.setRGB(Math.random(), Math.random(), Math.random());
				
			}

			// ==================================================================
			// Animate the trees


			var treeTime = 0.7;

			for (var i=0; i < this.trees.length; i++)
			{
				var ipct = i/(this.trees.length);
				var treeN = segmentTransition(ipct, ipct + treeTime, getVal('var2'));
				this.trees[i].setAge(easeOne('easeOutBack',treeN));
			}

			var rockTime = 0.05;
			for (var i=0; i < this.rocks.length; i++)
			{
				var ipct = i/(this.rocks.length);
				var rockN = segmentTransition(ipct, ipct + rockTime, getVal('var2'));
				if (rockN > 0.0001)
				{
					var s = easeOne('easeInExpo',rockN);
					this.rocks[i].scale.set(s,s,s);
					this.rocks[i].visible = true;
				} else
				{
					this.rocks[i].visible = false;
				}
				
			}



			// ==================================================================
			// Animate the pig? wtf


			var pigscale = 0.00001 + segmentTransition(0.0, 0.7, getVal('var3'));

			pigscale = easeOne('easeOutElastic',pigscale);

			this.pig.scale.set(pigscale, pigscale, pigscale);

			this.poof.animate(segmentTransition(0.0, 1, getVal('var3')));

			this.pig.position.y = morph(this.pig.pop, this.pig.ground, easeOne('easeOutBounce',getVal('var4')));

			//this.tre.setAge(percent);
			
			this.planeGeometry.colorsNeedUpdate = true;
			this.planeGeometry.normalsNeedUpdate = true;
			this.planeGeometry.verticesNeedUpdate = true;
			this.planeGeometry.computeVertexNormals();
			this.planeGeometry.computeFaceNormals();
/*
			// Render the depth map of the scene
			this.scene.overrideMaterial = this.depthMaterial;
			renderer.render(this.scene, this.camera, this.depthTarget);

			// Do the actual render
			this.scene.overrideMaterial = null;
*/

			
			// Render scene to depth buffer with depth material
			this.poof.visible = false;
			
			this.scene.overrideMaterial = this.depthMaterial;
			renderer.render( this.scene, this.camera, this.depthTarget );

			this.scene.overrideMaterial = this.depthBokehMaterial;
			renderer.render( this.scene, this.camera, this.depthBokehTarget );

//			renderer.render( this.scene, this.camera);
			this.poof.visible = true;

			// Render scene with proper materials through composer
			this.scene.overrideMaterial = null;
			this.composer.render();
		},

		planePointHeight: function(x, z)
		{
				var xz = new THREE.Vector2(x,z);
				return 10 + noise.simplex2(xz.x/101,xz.y/106)*8;
		}
	};
})();

var scenes = scenes || [];
scenes[Scene.id] = Scene;

