var Scene = (function() {
	var lerp = function(s, e, p) {
		return s - ((s - e) * p);
	}

	return {
		id: getIdForLastLoadedScript(),
		load: function()
		{
			this.scene = new THREE.Scene();
/*
			var ambient = new THREE.AmbientLight( 0xffffff );
			ambient.color.setHSL( 0.1, 0.3, 0.2 );
			this.scene.add( ambient );

			var dirLight = new THREE.DirectionalLight( 0xffffff, 0.125 );
			dirLight.position.set( 0, 10, -20 ).normalize();
			dirLight.color.setHSL( 0.1, 0.7, 0.7 );
			this.scene.add( dirLight );

			var light = new THREE.PointLight( 0xffffff, 1.5, 4500 );
			light.color.setHSL( 0.55, 0.9, 0.5 );
			light.position.set( -10, 10, -10 );
			this.scene.add( light );
*/
			//this.axishelper = new THREE.AxisHelper(5);
			//this.scene.add(this.axishelper);

			/*
			var light = new THREE.HemisphereLight( 0xffffff, 0x000000, .5 );
			light.position.y = 100;
			this.scene.add( light );
			*/

			this.light2 = new THREE.PointLight(0xffffff, 1, 150);
			//this.light2.castShadow = true;
			this.light2.position.set(50,100,50);
			this.scene.add(this.light2);

			// Maybe this is better than mocking around with emissive colors and shit?
			this.dirLight1 = new THREE.DirectionalLight(0xffffff, 0.4);
			this.dirLight2 = new THREE.DirectionalLight(0xffffff, 0.4);
			this.dirLight1.position.set(1,1,1);
			this.dirLight2.position.set(-1,0,0);
			this.dirLight3 = new THREE.DirectionalLight(0xffffff, 0.1);
			this.dirLight4 = new THREE.DirectionalLight(0xffffff, 0.1);
			this.dirLight3.position.set(0,0,1);
			this.dirLight4.position.set(0,0,-1);
			this.scene.add(this.dirLight1);
			this.scene.add(this.dirLight2);
			this.scene.add(this.dirLight3);
			this.scene.add(this.dirLight4);


			// Create a mockup cave
			this.caveWallMat = new THREE.MeshLambertMaterial({
					color: 0x7E430E,
					shading: THREE.FlatShading,
					wireframe: false
			});
			this.caveWallMatWF = new THREE.MeshBasicMaterial({
					color: 0xFFAA0B,
					shading: THREE.FlatShading,
					side: THREE.DoubleSide,
					wireframe: true
			});


			tex.greet0 = load_texture(texture_dir+'greets/telc.png','Greets 7'); // Telc
			tex.greet1 = load_texture(texture_dir+'greets/indigo.png','Greets 1');
			tex.greet2 = load_texture(texture_dir+'greets/foxmoron.png','Greets 2');
			tex.greet3 = load_texture(texture_dir+'greets/f-joms.png','Greets 3');
			tex.greet4 = load_texture(texture_dir+'greets/sandsmark.png','Greets 4');
			tex.greet5 = load_texture(texture_dir+'greets/bitflavour.png','Greets 5');
			tex.greet6 = load_texture(texture_dir+'greets/darklite.png','Greets 6');



			/*this.caveGeo = new THREE.DodecahedronGeometry(100, 1);
			flipNormals(this.caveGeo);
			this.cave = new THREE.Mesh(this.caveGeo, this.caveWallMat);
			this.scene.add(this.cave);
			this.caveWF = new THREE.Mesh(new THREE.DodecahedronGeometry(100.1, 1), this.caveWallMatWF);
			this.scene.add(this.caveWF);
			*/

			this.cave = new THREE.Cave(100);
			this.scene.add(this.cave);
			


		
			this.caveContent = new THREE.CaveColumns();
			this.caveContent.position.y = -25;
			//this.caveContent.castShadow = true;
			//this.caveContent.receiveShadow = true;
			this.scene.add(this.caveContent);


			this.numGreets = 7;
			this.badges = [];
			for (var i=0; i<this.numGreets; i++)
			{
				var badge = new THREE.Badge(tex['greet'+i]);
				this.scene.add(badge);
				this.badges.push(badge);
			}	



/*
var rockMat = new THREE.MeshPhongMaterial({
		color: 0xA0A09F,
		//shading: THREE.FlatShading
	});
	var alterWidth = 100;
	var alterX = 15;
	var alterY = -20;
	var platformGeo = new THREE.BoxGeometry(140,50,alterWidth,10,2,5);
	//this.wiggleVertices(platformGeo, 0.2, 343434);
	platformGeo = bevelBoxEdges(platformGeo, 2);
	platformGeo.applyMatrix(new THREE.Matrix4().makeTranslation(-70,-25,0));
	platformGeo.computeFaceNormals();
	platformGeo.computeVertexNormals();
	platformGeo.normalsNeedUpdate = true;
	platformGeo.verticesNeedUpdate = true;
	var platform = new THREE.Mesh(platformGeo, rockMat);
	platform.position.set(alterX, alterY, 0);
	platform.receiveShadow = true;
	platform.castShadow = true;
	this.scene.add(platform);
*/

			this.scene.traverse( function( node ) { if ( node instanceof THREE.Mesh ) { node.castShadow = true; } } );


			this.composer = new THREE.EffectComposer(renderer);

			this.camera = new THREE.PerspectiveCamera(60, 16/9, 1, 4000);
			this.camera.position.x = 150;
			this.camera.position.y = 75;

			//this.controls = new THREE.OrbitControls( this.camera );
			//this.controls.addEventListener('change',render);
			
			// SSAO Depth
			this.depthShader = THREE.ShaderLib[ "depthRGBA" ];
			this.depthUniforms = THREE.UniformsUtils.clone( this.depthShader.uniforms );

			this.depthMaterial = new THREE.ShaderMaterial({
				fragmentShader: this.depthShader.fragmentShader,
				vertexShader: this.depthShader.vertexShader,
				uniforms: this.depthUniforms
			});
			this.depthMaterial.blending = THREE.NoBlending;

			this.depthTarget = new THREE.WebGLRenderTarget( wWidth, wHeight, {
				minFilter: THREE.NearestFilter,
				magFilter: THREE.NearestFilter,
				format: THREE.RGBAFormat
			});

			this.renderPass = new THREE.RenderPass(this.scene, this.camera);
			this.composer.addPass(this.renderPass);


			this.SSAOPass = new THREE.ShaderPass( THREE.SSAOShader );
			this.SSAOPass.uniforms[ 'tDepth' ].value = this.depthTarget;
			this.SSAOPass.uniforms[ 'size' ].value.set( wWidth * 0.75, wHeight * 0.75 );
			this.SSAOPass.uniforms[ 'cameraNear' ].value = this.camera.near;
			this.SSAOPass.uniforms[ 'cameraFar' ].value = this.camera.far;
			this.SSAOPass.uniforms[ 'aoClamp' ].value = 0.5;
			this.SSAOPass.enabled = true;
			this.composer.addPass( this.SSAOPass );

			this.composer.addPass(final_pass);


		},



		render: function(time, percent) 
		{
			this.cave.controlCamera(this.camera);
			
			this.caveContent.animate(time);

			//this.controls.update();


			var b = getVal('var5');
			
			this.cave.animatePig(getVal('var5'));

			// 33 - 63 is a certified pig flight path.



			var pigN = getVal('percent');

			var pigPosition = 33+pigN/100*30;

			this.cave.animatePig(pigPosition);

			var badgeScale = segmentTransition(0.2, 0.3, pigN/100) * segmentTransition(0.2, 0.3, 1-pigN/100) + 0.0000000000001;

			for (var i=0; i<this.numGreets; i++)
			{
				var badgeCamPos = new THREE.Vector3( this.camera.position.x, this.badges[i].position.y, this.camera.position.z );

				this.badges[i].position.set( this.cave.pig.position.x, this.cave.pig.position.y + 6, this.cave.pig.position.z );
				this.badges[i].lookAt(badgeCamPos);
				//this.badges[i].scale.set(badgeScale,badgeScale,badgeScale);
				this.badges[i].animate(badgeScale);


				if ( b > i-0.0000001 && b < i+0.0000001 )
				{
					this.badges[i].visible = true;
				} else
				{
					this.badges[i].visible = false;
				}
			}


			

			this.scene.overrideMaterial = this.depthMaterial;
			renderer.render( this.scene, this.camera, this.depthTarget );

			this.scene.overrideMaterial = null;
			this.composer.render();
		}
	};
})();

var scenes = scenes || [];
scenes[Scene.id] = Scene;

