var Scene = (function() {
	var lerp = function(s, e, p) {
		return s - ((s - e) * p);
	}

	return {
		id: getIdForLastLoadedScript(),
		load: function()
		{
			this.scene = new THREE.Scene();

			tex.test_pattern = load_texture(texture_dir+'genesis.png','Glitch in the matrix');

			this.composer = new THREE.EffectComposer(renderer);


			var width = 2;
			var height = 2;

			this.camera = new THREE.OrthographicCamera(width/-2, width/2, height/2, height/-2 , -100, 100);
			//this.camera.lookAt(new THREE.Vector3(0, 0, 0));

			var planeGeo = new THREE.PlaneGeometry(width, height);
			var planeMat = new THREE.MeshBasicMaterial({
				map: tex.test_pattern
			});
			var plane = new THREE.Mesh(planeGeo, planeMat);
			plane.position.z = -10;
			this.scene.add(plane)


			this.renderPass = new THREE.RenderPass(this.scene, this.camera);
			this.composer.addPass(this.renderPass);

			this.glitchPass = new THREE.GlitchPass();
			Math.seedrandom(1337);
			this.glitchPass.uniforms.seed.value = Math.random();
			this.glitchPass.uniforms.seed_x.value = Math.random();
			this.glitchPass.uniforms.seed_y.value = Math.random();
			this.composer.addPass(this.glitchPass);

			this.composer.addPass(final_pass);
		},

		render: function(time, percent) 
		{
			this.glitchPass.goWild = getVal('var1') > 0.5 ? true : false;

			this.composer.render();
		}
	};
})();

var scenes = scenes || [];
scenes[Scene.id] = Scene;