var Scene = (function() {
	var lerp = function(s, e, p) {
		return s - ((s - e) * p);
	}

	return {
		id: getIdForLastLoadedScript(),
		load: function()
		{
			this.scene = new THREE.Scene();

			/*var ambient = new THREE.AmbientLight( 0xffffff );
			ambient.color.setHSL( 0.1, 0.3, 0.2 );
			this.scene.add( ambient );

			var dirLight = new THREE.DirectionalLight( 0xffffff, 0.125 );
			dirLight.position.set( 0, 10, -20 ).normalize();
			//dirLight.color.setHSL( 0.1, 0.7, 0.7 );
			this.scene.add( dirLight );

			var light = new THREE.PointLight( 0xffffff, 1.5, 4500 );
			//light.color.setHSL( 0.55, 0.9, 0.5 );
			light.position.set( -10, 10, -10 );
			this.scene.add( light );
			*/

			this.dirLight1 = new THREE.DirectionalLight(0xffffff, 0.4);
			this.dirLight2 = new THREE.DirectionalLight(0xffffff, 0.4);
			this.dirLight1.position.set(1,1,1);
			this.dirLight2.position.set(-1,0,0);
			this.dirLight3 = new THREE.DirectionalLight(0xffffff, 0.1);
			this.dirLight4 = new THREE.DirectionalLight(0xffffff, 0.1);
			this.dirLight3.position.set(0,0,1);
			this.dirLight4.position.set(0,0,-1);
			this.scene.add(this.dirLight1);
			this.scene.add(this.dirLight2);
			this.scene.add(this.dirLight3);
			this.scene.add(this.dirLight4);


			this.axishelper = new THREE.AxisHelper(5);
			this.scene.add(this.axishelper);

			var light = new THREE.HemisphereLight( 0xffffff, 0x000000, .5 );
			light.position.y = 100;
			this.scene.add( light );

			var mat = new THREE.MeshLambertMaterial({
					ambient: 0xADFFB2,
					color: 0x099723,
					emissive: 0x099723,
					shading: THREE.FlatShading,
					side: THREE.DoubleSide,
					wireframe: false
				});


			var planeGeo = new THREE.PlaneGeometry(40,40,2,2);
			var plane = new THREE.Mesh(planeGeo, mat);
			plane.rotation.x = deg2rad(90);
			this.scene.add(plane);

			var platform = new THREE.FloatingIsland(0);
			platform.position.set(0,-2,0);
			//this.scene.add(platform);


			this.windmill = new THREE.Windmill();
			this.windmill.animate(1);
			this.scene.add(this.windmill);



			this.composer = new THREE.EffectComposer(renderer);

			this.camera = new THREE.PerspectiveCamera(45, 16/9, 0.1, 1000);
			this.camera.position.set(0, 30, 30);
			this.camera.lookAt(new THREE.Vector3(0, 0, 0));

			this.controls = new THREE.OrbitControls( this.camera );

			//var material = new THREE.MeshPhongMaterial( { ambient: 0x333333, color: 0xffffff, specular: 0xffffff, shininess: 50 } )
			
			this.renderPass = new THREE.RenderPass(this.scene, this.camera);
			this.composer.addPass(this.renderPass);
/*
			this.blurPass1 = new THREE.ShaderPass(THREE.VerticalBlurShader);
			this.blurPass1.uniforms["v"].value = 1 / wHeight;
			this.composer.addPass(this.blurPass1);

			this.blurPass2 = new THREE.ShaderPass(THREE.HorizontalBlurShader);
			this.blurPass2.uniforms["h"].value = 1 / wWidth;
			this.composer.addPass(this.blurPass2);
*/
			this.composer.addPass(final_pass);
		},

		render: function(time, percent) 
		{
			
			this.windmill.animate(getVal('var1'), time);
			

			this.controls.update();
			this.composer.render();
		}
	};
})();

var scenes = scenes || [];
scenes[Scene.id] = Scene;
