var Scene = (function() {
	var lerp = function(s, e, p) {
		return s - ((s - e) * p);
	}


	return {
		id: getIdForLastLoadedScript(),

		getGroundY: function(x,z)
		{
			var y = noise.perlin2(x/70+400, z/70+400)*5;
			y += noise.perlin2(x/10,z/10)*1.5;
			y -= 15;
			return y;
		},

		load: function()
		{
			this.scene = new THREE.Scene();
/*
			var ambient = new THREE.AmbientLight( 0xffffff );
			ambient.color.setHSL( 0.1, 0.3, 0.2 );
			this.scene.add( ambient );

			var dirLight = new THREE.DirectionalLight( 0xffffff, 0.125 );
			dirLight.position.set( 0, 10, -20 ).normalize();
			dirLight.color.setHSL( 0.1, 0.7, 0.7 );
			this.scene.add( dirLight );

			var light = new THREE.PointLight( 0xffffff, 1.5, 4500 );
			light.color.setHSL( 0.55, 0.9, 0.5 );
			light.position.set( -10, 10, -10 );
			this.scene.add( light );
*/
			/*
			this.axishelper = new THREE.AxisHelper(5);
			this.scene.add(this.axishelper);
			*/

			var groundGeo = new THREE.PlaneGeometry(220,220,30,30);
			groundGeo.applyMatrix( new THREE.Matrix4().makeRotationX(deg2rad(-90)) );

			for (var i=0; i<groundGeo.vertices.length; i++)
			{
				var x = groundGeo.vertices[i].x;
				var z = groundGeo.vertices[i].z;
				var y = this.getGroundY(x,z);
				groundGeo.vertices[i].y = y;
			}

			groundGeo.computeVertexNormals();
			groundGeo.computeFaceNormals();

			var matGround = new THREE.MeshLambertMaterial({
				//ambient: 0x999999,
				color: 0x198515,
				//emissive: 0x222222,
				shading: THREE.FlatShading,
				//side: THREE.DoubleSide,
				wireframe: false
			});

			this.ground = new THREE.Mesh(groundGeo, matGround);
			this.ground.position.y = -20;
			this.scene.add(this.ground);

			this.hand = new THREE.Hand();
			this.hand.position.set(0, -40, 0);
			this.hand.rotation.y = deg2rad(180);
			this.scene.add(this.hand);

			this.pig = new THREE.Pig();


			/*
			var light = new THREE.HemisphereLight( 0xffffff, 0x000000, .5 );
			light.position.y = 100;
			this.scene.add( light );
			*/

			this.light2 = new THREE.PointLight(0xffffff, 1, 150);
			//this.light2.castShadow = true;
			this.light2.position.set(50,100,50);
			this.scene.add(this.light2);

			// Maybe this is better than mocking around with emissive colors and shit?
			this.dirLight1 = new THREE.DirectionalLight(0xffffff, 0.4);
			this.dirLight2 = new THREE.DirectionalLight(0xffffff, 0.4);
			this.dirLight1.position.set(1,1,1);
			this.dirLight2.position.set(-1,0,0);
			this.dirLight3 = new THREE.DirectionalLight(0xffffff, 0.1);
			this.dirLight4 = new THREE.DirectionalLight(0xffffff, 0.1);
			this.dirLight3.position.set(0,0,1);
			this.dirLight4.position.set(0,0,-1);
			this.scene.add(this.dirLight1);
			this.scene.add(this.dirLight2);
			this.scene.add(this.dirLight3);
			this.scene.add(this.dirLight4);

			// Cave with tunnels
			this.cave = new THREE.Cave(100);
			this.scene.add(this.cave);

/*
			var fitteanalbanan = new THREE.Mesh(
				new THREE.BoxGeometry(20,20,20),
				new THREE.MeshLambertMaterial(
				{
					color: new THREE.Color(Math.random(),Math.random(),Math.random())
				})
			);
			fitteanalbanan.rotation.set(Math.random(),Math.random(),Math.random());
			this.scene.add(fitteanalbanan);
*/


			// Do the rendering shit
			this.composer = new THREE.EffectComposer(renderer);

			this.camera = new THREE.PerspectiveCamera(55, 16/9, 1, 4000);
			this.camera.position.x = 150;
			this.camera.position.y = 75;

			this.controls = new THREE.OrbitControls( this.camera );
			//this.controls.addEventListener('change',render);
			
			// SSAO Depth
			this.depthShader = THREE.ShaderLib[ "depthRGBA" ];
			this.depthUniforms = THREE.UniformsUtils.clone( this.depthShader.uniforms );

			this.depthMaterial = new THREE.ShaderMaterial({
				fragmentShader: this.depthShader.fragmentShader,
				vertexShader: this.depthShader.vertexShader,
				uniforms: this.depthUniforms
			});
			this.depthMaterial.blending = THREE.NoBlending;

			this.depthTarget = new THREE.WebGLRenderTarget( wWidth, wHeight, {
				minFilter: THREE.NearestFilter,
				magFilter: THREE.NearestFilter,
				format: THREE.RGBAFormat
			});

			this.renderPass = new THREE.RenderPass(this.scene, this.camera);
			this.composer.addPass(this.renderPass);


			this.SSAOPass = new THREE.ShaderPass( THREE.SSAOShader );
			this.SSAOPass.uniforms[ 'tDepth' ].value = this.depthTarget;
			this.SSAOPass.uniforms[ 'size' ].value.set( wWidth * 0.75, wHeight * 0.75 );
			this.SSAOPass.uniforms[ 'cameraNear' ].value = this.camera.near;
			this.SSAOPass.uniforms[ 'cameraFar' ].value = this.camera.far;
			this.SSAOPass.uniforms[ 'aoClamp' ].value = 0.5;
			this.SSAOPass.enabled = true;
			this.composer.addPass( this.SSAOPass );

			this.composer.addPass(final_pass);
		},

		render: function(time, percent) 
		{
			this.hand.animate(getVal("var3"), getVal("var2"));
			//this.controls.update();
			this.cave.animatePig(getVal("var1"));
			


			this.cave.controlCamera(this.camera);

			this.scene.overrideMaterial = this.depthMaterial;
			renderer.render( this.scene, this.camera, this.depthTarget );

			this.scene.overrideMaterial = null;
			this.composer.render();
		}
	};
})();

var scenes = scenes || [];
scenes[Scene.id] = Scene;

