/*
Makes a nice rock formation. n=number of smaller rocks joined with the main rock.
This doesn't need to be a three object.
*/
function makeRock (size, n, seed)
{
	Math.seedrandom(seed);
	var rockMat = new THREE.MeshLambertMaterial({
		//ambient: #999999,
		color: 0xA0A09F,
		//emissive: #222222,
		shading: THREE.FlatShading
	});

	var rockGeo = new THREE.IcosahedronGeometry(size, 0);
	rockGeo = rockWiggleVertices(rockGeo, size/4);

	for (var i=1; i<n; i++)
	{
		var smallRockGeo = new THREE.IcosahedronGeometry(size/4 + Math.random() ,0);
		smallRockGeo = rockWiggleVertices(smallRockGeo, size/12);
		var deg = Math.random()*Math.PI*2;
		var x = Math.sin(deg)*size;
		var z = Math.cos(deg)*size;
		smallRockGeo.applyMatrix(new THREE.Matrix4().makeTranslation(x, 0, z));
		rockGeo.merge(smallRockGeo);
	}

	var rock = new THREE.Mesh(rockGeo, rockMat);
	return rock;
}

function rockWiggleVertices (geo, amount)
{
	for (var i=0; i<geo.vertices.length; i++)
	{
		geo.vertices[i].x += (Math.random()-0.5*2)*amount;
		geo.vertices[i].y += (Math.random()-0.5*2)*amount;
		geo.vertices[i].z += (Math.random()-0.5*2)*amount;
	}

	return geo;
}