'use strict';

THREE.RaymarchingPlane = function (options) {

	options = options || {};

	//options.seed = typeof(options.seed) !== "undefined" ? options.seed : 100;

	THREE.Object3D.call( this );
	this.type = 'RaymarchingPlane';

	var geomPlane = new THREE.PlaneGeometry( 100, 100 );

	var raymarchShaderDetails = {
		"uniforms": THREE.UniformsUtils.merge([
			{ 
				"iGlobalTime": 	{ type: "f", value: 0.0 },
			}
		]),
		"vertexShader": THREE.ShaderChunk['raymarchVertex'],
		"fragmentShader": THREE.ShaderChunk['raymarchFragment']
	};

	this.matRaymarch = new THREE.ShaderMaterial({ 
		uniforms: THREE.UniformsUtils.clone(raymarchShaderDetails.uniforms),
		vertexShader: raymarchShaderDetails.vertexShader,
		fragmentShader: raymarchShaderDetails.fragmentShader,
		blending: THREE.NormalBlending,
    	transparent: true
	});

	this.mesh = new THREE.Mesh( geomPlane, this.matRaymarch );
	//this.mesh.rotation.y = deg2rad(180);
	this.add(this.mesh);
};

THREE.RaymarchingPlane.prototype = Object.create( THREE.Object3D.prototype);
THREE.RaymarchingPlane.prototype.constructor = THREE.RaymarchingPlane;

THREE.RaymarchingPlane.prototype.animate = function(percent) {
	this.matRaymarch.uniforms.iGlobalTime.value = percent;
}
