/**
 * Cloud 9
 * staalebk
 */
THREE.PoffPig = function(poofSize, poofLength, numpoof, dropHeight, seed) {

	seed = seed || 1;

	THREE.Object3D.call(this);

	this.type = 'PoffPig';

	this.pigOffsetY = 4;
	this.dropHeight = dropHeight;

	this.pig = new THREE.Pig();
	this.pig.position.y = dropHeight + this.pigOffsetY;

	this.poof = new THREE.Poff(poofSize, poofLength, numpoof, seed);
	this.poof.position.y = dropHeight + this.pigOffsetY;

	this.add(this.pig);
	this.add(this.poof);


	
	this.animate = function(n)
	{


		var poofN = segmentTransition(0.0, 0.4, n);
		var popN = segmentTransition(0.0, 0.5, n);
		var fallN = segmentTransition(0.2, 1.0, n);

		if (poofN > 0.000001 && poofN < 0.9999999)
		{
			//console.log('PoffPig pop: ' + poofN);
			this.poof.visible = true;
			this.poof.animate(poofN);
		} else
		{
			this.poof.visible = false;
		}

		if (popN > 0.000001)
		{
			this.pig.visible = true;
			var s = easeOne('easeOutElastic', popN);
			this.pig.scale.set(s,s,s);
		} else
		{
			this.pig.visible = false;
		}

		fallN = easeOne('easeOutBounce', fallN);

		this.pig.position.set(0, this.dropHeight*(1-fallN) + this.pigOffsetY ,0);
	}
};

THREE.PoffPig.prototype = Object.create(THREE.Object3D.prototype);
THREE.PoffPig.prototype.constructor = THREE.PoffPig;