/**
 * Cloud 9
 * staalebk
 */
THREE.Poff = function(poofSize, poofLength, numpoof, seed) {

	seed = seed || 1;

	THREE.Object3D.call(this);

	this.type = 'Poff';

	randSeed(seed);

	var getCloudGeometry = function(x, y, z) {
		var cloud = new THREE.BoxGeometry(x, y, z);
		cloud.mergeVertices();
		var modifier = new THREE.SubdivisionModifier(1);
		modifier.modify(cloud);
		return cloud;
	}

	

	/*this.cloudmaterialBig = new THREE.MeshLambertMaterial({
		ambient: 0x999999,
		color: 0xaaaaaa,
		emissive: 0x222222,
		shading: THREE.FlatShading,
		transparent: true
	});*/

	this.cloudmaterial = new THREE.MeshLambertMaterial({
		ambient: 0x999999,
		color: 0xaaaaaa,
		emissive: 0x222222,
		shading: THREE.FlatShading,
		transparent: true
	});

	/*this.bigpoofGeo = getCloudGeometry(size, size, size);
	this.bigpoof = new THREE.Mesh(this.bigpoofGeo, this.cloudmaterialBig);
	this.add(this.bigpoof);*/

	this.poofs = [];
	for (var i=0; i < numpoof; i++)
	{
		var params = {
			dirX: randGet(100),
			dirY: randGet(100),
			dirZ: randGet(100),
			len: poofLength + randGet(100)*0.5
		}

		var ps = poofSize + randGet(100)*poofSize/2;
		var poofGeo = getCloudGeometry(ps,ps,ps);
		var poof = new THREE.Mesh(poofGeo, this.cloudmaterial);
		poof.customOverrideMaterial = new THREE.MeshBasicMaterial({color:0x000000});
		poof.params = params;
		this.poofs.push(poof);
		this.add(this.poofs[i]);
	}

	this.animate = function(n)
	{
		//console.log(n);
		//console.log(easeOne('easeOutQuart',n));

		/*var bigN = segmentTransition(0.0, 0.6, n);
		var bigS = 0.000001+easeOne('easeOutQuart',bigN);
		console.log(bigS);
		this.bigpoof.scale.set(bigS, bigS, bigS);
		this.cloudmaterialBig.opacity = 1-bigS;
		//this.bigpoof.scale.set(0,0,0);
		*/

		this.cloudmaterial.opacity = 1-n;
		for (var i=0; i < this.poofs.length; i++)
		{
			var e = easeOne('easeOutQuart',n)
			e = easeOne('easeOutQuart',e)
			this.poofs[i].position.x = this.poofs[i].params.dirX*this.poofs[i].params.len*e;
			this.poofs[i].position.y = this.poofs[i].params.dirY*this.poofs[i].params.len*e;
			this.poofs[i].position.z = this.poofs[i].params.dirZ*this.poofs[i].params.len*e;
			this.poofs[i].rotation.x = this.poofs[i].position.z;
			this.poofs[i].rotation.y = this.poofs[i].position.x;
			this.poofs[i].rotation.z = this.poofs[i].position.y;

			var s = 0.0001+easeOne('easeOutQuart',n);
			//this.poofs[i].scale.set(s,s,s);
			this.poofs[i].scale.set(s,s,s);
			//console.log (this.poofs[i].params.scale);
			//console.log(s);
			

			//this.poofs[i].position.x = 10;
			//this.poofs[i].position.y = 10;
			//this.poofs[i].position.z = 10;
		}
	}

};

THREE.Poff.prototype = Object.create(THREE.Object3D.prototype);
THREE.Poff.prototype.constructor = THREE.Poff;