/**
* Cloud 9
* staalebk
*/

THREE.MeatGrinder = function () {
  
  THREE.Object3D.call( this );

  var getSlot = function(length) {
    var grinderblack = new THREE.MeshLambertMaterial({
      ambient: 0x999999,
      color: 0x111111,
      emissive: 0x000000,
      shading: THREE.FlatShading
    });
    var slot = new THREE.BoxGeometry(length,0.01,0.1);
    var slot_m = new THREE.Mesh(slot, grinderblack);
    slot_m.translateY(10);
    return slot_m;
  };

  this.type = 'MeatGrinder';

  var grindermaterial = new THREE.MeshLambertMaterial({
    ambient: 0x999999,
    color: 0xaaaaaa,
    emissive: 0x222222,
    shading: THREE.FlatShading
  });

  var barrel = new THREE.CylinderGeometry(1.5,1.5,6,8,1);
  var barrel_m = new THREE.Mesh(barrel, grindermaterial);
  barrel_m.translateY(7);
  barrel_m.castShadow = true;
  this.add(barrel_m);

  var crank = new THREE.CylinderGeometry(0.1,0.1,1,3,1);
  var crank_m = new THREE.Mesh(crank, grindermaterial);
  crank_m.translateY(4);
  crank_m.castShadow = true;
  this.add(crank_m);
  this.crank_m = crank_m;


  var arm = new THREE.BoxGeometry(5,0.5,0.5);
  arm.applyMatrix( new THREE.Matrix4().makeTranslation(1.7,0,0));
  var arm_m = new THREE.Mesh(arm, grindermaterial);
  arm_m.translateY(3.5);
  //arm_m.translateX(1.5);
  arm_m.castShadow = true;
  this.add(arm_m);
  this.arm_m = arm_m;


  var handle = new THREE.CylinderGeometry(0.1,0.1,1,3,1);
  handle.applyMatrix( new THREE.Matrix4().makeTranslation(3.4,0,0));
  var handle_m = new THREE.Mesh(handle, grindermaterial);
  handle_m.translateY(3);
  //arm_m.translateX(1.5);
  handle_m.castShadow = true;
  this.add(handle_m);
  this.handle_m = handle_m;

  var slot1 = getSlot(2.7);
  this.add(slot1);
  for(i = 0; i<5; i++){
    var slot = getSlot(2.5-0.2*i);
    var slot_c = slot.clone();
    slot.translateZ(0.2+0.2*i)
    slot_c.translateZ(-0.2-0.2*i);
    this.add(slot);
    this.add(slot_c);
  }


  var points = [];
  points.push( new THREE.Vector3( 1, 0, 0 ));
  points.push( new THREE.Vector3( 1.2, 0, 1 ));
  points.push( new THREE.Vector3( 1.4, 0, 2 ));
  points.push( new THREE.Vector3( 2 , 0, 4 ));
  points.push( new THREE.Vector3( 1.9 , 0, 4 ));
  points.push( new THREE.Vector3( 1.3 , 0, 2 ));
  points.push( new THREE.Vector3( 1.1 , 0, 1 ));
  points.push( new THREE.Vector3( 0.9 , 0, 0 ));
  var funnel = new THREE.LatheGeometry( points );
  var funnel_m = new THREE.Mesh( funnel, grindermaterial );
  funnel_m.rotation.y = +Math.PI/2;
  funnel_m.translateY(6);
  this.add( funnel_m );
  
  var points = [];
  points.push( new THREE.Vector3( 0.2, 0, 0 ));
  points.push( new THREE.Vector3( 0.3, 0, 1 ));
  points.push( new THREE.Vector3( 0.4, 0, 2 ));
  points.push( new THREE.Vector3( 0.5 , 0, 5 ));
  var holder = new THREE.LatheGeometry( points );
  var holder_m = new THREE.Mesh( holder, grindermaterial );
  holder_m.rotation.y = +Math.PI/2;
  //holder_m.rotation.x = +Math.PI/4;
  holder_m.translateY(5);
  var holder_m2 = holder_m.clone();
  var holder_m3 = holder_m.clone();
  var holder_m4 = holder_m.clone();
  holder_m.rotateOnAxis(new THREE.Vector3(0,1,0), -Math.PI/8);
  

  holder_m.translateZ(-6);
  
  holder_m2.rotateOnAxis(new THREE.Vector3(0,1,0), -Math.PI/8);
  holder_m2.translateY(2);
  holder_m2.translateZ(-6);


  holder_m3.rotateOnAxis(new THREE.Vector3(0,1,0), +Math.PI/8);
  holder_m3.translateY(2);
  holder_m3.translateZ(-6);
  holder_m4.rotateOnAxis(new THREE.Vector3(0,1,0), +Math.PI/8);
  holder_m4.translateZ(-6);

  this.add(holder_m);
  this.add(holder_m2);
  this.add(holder_m3);
  this.add(holder_m4);

};

THREE.MeatGrinder.prototype = Object.create(THREE.Object3D.prototype);
THREE.MeatGrinder.prototype.constructor = THREE.MeatGrinder;


THREE.MeatGrinder.prototype.animate = function( age ) {
  this.arm_m.rotation.y = Math.PI*age;
  this.handle_m.rotation.y = Math.PI*age;
  this.crank_m.rotation.y = Math.PI*age;
};
