/**
 * Cloud 9
 * staalebk
 */
THREE.Gravestone = function() {

	THREE.Object3D.call(this);

	this.type = 'Gravestone';

	var bottomSegment = new THREE.BoxGeometry(5.05, 5.05, .75);
	var topSegment = new THREE.CylinderGeometry( 2.65, 2.65, .75, 10, 1 );
	var textSegment = new THREE.TextGeometry("R I P", { size: 5, height: 1, curveSegments: 2, bevelEnabled: true, bevelThickness: 0.2, bevelSize: 0.2 });
/*
	var geomCrossH = new THREE.BoxGeometry(6.5, 1, 1);
	var geomCrossV = new THREE.BoxGeometry(1, 12.5, 1);
	var geomCircle = new THREE.TorusGeometry(2.5, .5, 5, 6);

	var topPlacement = new THREE.Matrix4().makeTranslation(0, 3, 0);
	this.geom = new THREE.Geometry();
	this.geom.merge(geomCrossH, topPlacement);
	this.geom.merge(geomCrossV);
	this.geom.merge(geomCircle, topPlacement);
*/
	var topTranslate = new THREE.Matrix4().makeTranslation(0, 2.0, 0);
	var topRotate = new THREE.Matrix4().makeRotationX(deg2rad(90));
	var topPlacement = topTranslate.multiply(topRotate);

	var textTranslate = new THREE.Matrix4().makeTranslation(-6, 2, 1.5);
	var textScaling = new THREE.Matrix4().makeScale(0.3, 0.3, 0.3);
	var textPlacement = textScaling.multiply(textTranslate);

	this.geom = new THREE.Geometry();
	this.geom.merge(bottomSegment);
	this.geom.merge(topSegment, topPlacement);
	this.geom.merge(textSegment, textPlacement);//, textScaling);

	this.material = new THREE.MeshLambertMaterial({
		//ambient: #999999,
		color: 0xA0A09F,
		//emissive: #222222,
		shading: THREE.FlatShading
	});

	this.mesh = new THREE.Mesh(this.geom, this.material);
	this.mesh.position.y = 2.5;
	this.add(this.mesh);

};

THREE.Gravestone.prototype = Object.create(THREE.Object3D.prototype);
THREE.Gravestone.prototype.constructor = THREE.Gravestone;