/**
 * Cave object
 * Pig statue
 */
THREE.CavePigStatue = function() {
	
	THREE.Object3D.call(this);

	this.type = 'CavePigStatue';


	// because == on floats...
	this.closeEnough = function(x, y)
	{
		if (x >= y-0.001 && x <= y+0.001)
			return true;
		return false;
	}

	this.wiggleVertices = function(geo, n, seed)
	{
		Math.seedrandom(seed);
		for (var i=0; i<geo.vertices.length; i++)
		{
			geo.vertices[i].x += (Math.random()*2-1)*n;
			geo.vertices[i].y += (Math.random()*2-1)*n;
			geo.vertices[i].z += (Math.random()*2-1)*n;
		}
		geo.computeFaceNormals();
		geo.computeVertexNormals();
		geo.normalsNeedUpdate = true;
		geo.verticesNeedUpdate = true;
	}

	var rockMat = new THREE.MeshPhongMaterial({
		color: 0xA0A09F,
		//shading: THREE.FlatShading
	});
	var rockMat2 = new THREE.MeshPhongMaterial({
		color: 0x5C5C5C,
		//shading: THREE.FlatShading
	});
	var caveWallMat = new THREE.MeshLambertMaterial({
			color: 0x7E430E,
			shading: THREE.FlatShading,
			side: THREE.BackSide,
			wireframe: false
	});

	
	// And got said, let there be light
	this.spotLight = new THREE.SpotLight(0xFFE766, 1, 150, deg2rad(10));
	this.add(this.spotLight);
	this.spotLight.position.set(-34,0,0);
	//this.spotLight.rotation.z = deg2rad(-30);
	


	// Make a floor
	var floorGeo = new THREE.PlaneGeometry(200,200,15,15);
	for (var i=0; i<floorGeo.vertices.length; i++)
	{
		floorGeo.vertices[i].z += noise.perlin2(floorGeo.vertices[i].x, floorGeo.vertices[i].y)*5;
	}
	floorGeo.computeFaceNormals();
	floorGeo.computeVertexNormals();
	floorGeo.normalsNeedUpdate = true;
	floorGeo.verticesNeedUpdate = true;
	var floor = new THREE.Mesh(floorGeo, caveWallMat);
	floor.position.set(0,-50,0);
	floor.rotation.set(deg2rad(90),0,0);
	this.add(floor);

	// Make the pig worshiping alter
	var alterWidth = 100;
	var alterX = 15;
	var alterY = -20;


	var platformGeo = new THREE.BoxGeometry(140,50,alterWidth,10,2,5);
	//this.wiggleVertices(platformGeo, 0.2, 343434);
	platformGeo = bevelBoxEdges(platformGeo, 2);
	platformGeo.applyMatrix(new THREE.Matrix4().makeTranslation(-70,-25,0));
	platformGeo.computeFaceNormals();
	platformGeo.computeVertexNormals();
	platformGeo.normalsNeedUpdate = true;
	platformGeo.verticesNeedUpdate = true;
	var platform = new THREE.Mesh(platformGeo, rockMat);
	platform.position.set(alterX, alterY, 0);
	platform.receiveShadow = true;
	platform.castShadow = true;
	this.add(platform);

	// Add stairs
	var stairDepth = 6;
	var stairHeight = 4;
	var stairWidth = alterWidth - 40;
	var stairGrow = 4;
	for (var i=0; i<7; i++)
	{
		var stairGeo = new THREE.BoxGeometry(stairDepth,50,stairWidth+stairGrow*i,1,1,1);
		stairGeo.applyMatrix(new THREE.Matrix4().makeTranslation(stairDepth/2,-25,0));
		var stair = new THREE.Mesh(stairGeo, rockMat);
		stair.position.set(alterX+i*stairDepth, alterY-(i+1)*stairHeight, 0);
		this.add(stair);

		var stairGeo = new THREE.BoxGeometry(stairDepth*1.3,50,stairDepth*1.3,1,1,1);
		stairGeo = bevelBoxEdges(stairGeo, 1);
		stairGeo.applyMatrix(new THREE.Matrix4().makeTranslation(stairDepth/2,-25,0));
		var stair = new THREE.Mesh(stairGeo, rockMat2);
		stair.position.set(alterX+i*stairDepth, alterY-(i+1)*stairHeight+3, stairWidth/2+stairGrow*i/2);
		this.add(stair);

		var stairGeo = new THREE.BoxGeometry(stairDepth*1.3,50,stairDepth*1.3,1,1,1);
		stairGeo = bevelBoxEdges(stairGeo, 1);
		stairGeo.applyMatrix(new THREE.Matrix4().makeTranslation(stairDepth/2,-25,0));
		var stair = new THREE.Mesh(stairGeo, rockMat2);
		stair.position.set(alterX+i*stairDepth, alterY-(i+1)*stairHeight+3, -stairWidth/2-stairGrow*i/2);
		this.add(stair);
	}

	// Add the podium and statue
	var podiumGeo = new THREE.BoxGeometry(32,30,27);
	podiumGeo = bevelBoxEdges(podiumGeo, 1);
	podiumGeo.applyMatrix(new THREE.Matrix4().makeTranslation(0,-15,0));
	var podium = new THREE.Mesh(podiumGeo, rockMat2);
	podium.receiveShadow = true;
	podium.castShadow = true;
	podium.position.set(-35,0,0);
	this.add(podium);

	this.pigStatue = new THREE.PigStatue();
	this.pigStatue.scale.set(0.2, 0.2, 0.2);
	this.pigStatue.rotation.set(0,deg2rad(90),0);
	this.pigStatue.position.set(-34,0,0);
	this.pigStatue.receiveShadow = true,
	this.pigStatue.castShadow = true;
	this.add(this.pigStatue);


	this.lights = [];
	this.makeLightColumn = function(x, y, z)
	{
		var columnGeo = new THREE.BoxGeometry(10,70,10,1,1,1);
		columnGeo = bevelBoxEdges(columnGeo,2);
		columnGeo.applyMatrix(new THREE.Matrix4().makeTranslation(0,-35,0));
		var column = new THREE.Mesh(columnGeo, rockMat2);
		column.position.set(x,y,z);
		this.add(column);
		var fire = new THREE.Fire({seed: x*2+y*3+z*4});
		fire.position.set(x,y-0.5,z);
		this.lights.push(fire);
		this.add(this.lights[this.lights.length-1]);
	}

	this.makeLightColumn(alterX, 7, alterWidth/2);
	this.makeLightColumn(alterX, 7, -alterWidth/2);

	this.makeLightColumn(alterX-70, 7, alterWidth/2);
	this.makeLightColumn(alterX-70, 7, -alterWidth/2);


	this.pigs = [];


	pigY = 3;
	pigZ = 4;
	
	// Place the pigs
	var pig = new THREE.Pig();
	pig.position.set(-2,alterY-3,0);
	pig.mesh.position.set(0,pigY,pigZ);
	pig.lookAt(new THREE.Vector3(-34,alterY+5,0));
	pig.castShadow = true;
	this.add(pig);
	this.pigs.push(pig);

	var pig = new THREE.Pig();
	pig.position.set(-4,alterY-3,15);
	pig.mesh.position.set(0,pigY,pigZ);
	pig.lookAt(new THREE.Vector3(-34,alterY+5,0));
	this.add(pig);
	this.pigs.push(pig);

	var pig = new THREE.Pig();
	pig.position.set(-4,alterY-3,-15);
	pig.mesh.position.set(0,pigY,pigZ);
	pig.lookAt(new THREE.Vector3(-34,alterY+5,0));
	this.add(pig);
	this.pigs.push(pig);

	var pig = new THREE.Pig();
	pig.position.set(-10,alterY-3,30);
	pig.mesh.position.set(0,pigY,pigZ);
	pig.lookAt(new THREE.Vector3(-34,alterY+5,0));
	this.add(pig);
	this.pigs.push(pig);

	var pig = new THREE.Pig();
	pig.position.set(-10,alterY-3,-30);
	pig.mesh.position.set(0,pigY,pigZ);
	pig.lookAt(new THREE.Vector3(-34,alterY+5,0));
	this.add(pig);
	this.pigs.push(pig);





	this.animate = function(t)
	{	
		for (var i=0; i<this.pigs.length; i++)
		{
			this.pigs[i].lookAt(new THREE.Vector3(-34,alterY+1 + (Math.sin(t*5) *0.5+0.5 )*20,0));
		}

		this.pigStatue.animate(getVal('percent'));
		for (var i=0; i<this.lights.length;i++)
		{
			this.lights[i].animate(t+i*60);
		}

	}

};

THREE.CavePigStatue.prototype = Object.create(THREE.Object3D.prototype);
THREE.CavePigStatue.prototype.constructor = THREE.CavePigStatue;