/**
 * Cave object
 * Columns
 */
THREE.CaveColumns = function() {
	
	THREE.Object3D.call(this);

	this.type = 'CavePigStatue';


	// because == on floats...
	this.closeEnough = function(x, y)
	{
		if (x >= y-0.001 && x <= y+0.001)
			return true;
		return false;
	}

	this.wiggleVertices = function(geo, n, seed)
	{
		Math.seedrandom(seed);
		for (var i=0; i<geo.vertices.length; i++)
		{
			geo.vertices[i].x += (Math.random()*2-1)*n;
			geo.vertices[i].y += (Math.random()*2-1)*n;
			geo.vertices[i].z += (Math.random()*2-1)*n;
		}
		geo.computeFaceNormals();
		geo.computeVertexNormals();
		geo.normalsNeedUpdate = true;
		geo.verticesNeedUpdate = true;
	}

	var rockMat = new THREE.MeshPhongMaterial({
		color: 0xA0A09F,
		//shading: THREE.FlatShading
	});
	var rockMat2 = new THREE.MeshPhongMaterial({
		color: 0x5C5C5C,
		//shading: THREE.FlatShading
	});

	this.sizeX = 200;
	this.sizeZ = 200;
	this.res = 17;
	this.spacing = 1;
	this.crack = 0.1;
	this.bevel = 1;
	this.floorLevel = -10;

	var center = new THREE.Vector3(0,0,0);

	this.columns = [];

	var columnGeo = new THREE.BoxGeometry((this.sizeX/this.res)-this.spacing*2, 150, (this.sizeZ/this.res)-this.spacing*2 );
	columnGeo = bevelBoxEdges(columnGeo, this.bevel);
	columnGeo.applyMatrix(new THREE.Matrix4().makeTranslation(0,-75,0));

	var floorCSG = new ThreeBSP(new THREE.BoxGeometry(250,150,250));
	var subtractGeo = new THREE.BoxGeometry(1,1,1);
	subtractGeo.applyMatrix(new THREE.Matrix4().makeTranslation(1000,1000,1000));

	for (var x=0; x<this.res; x++)
	{
		var cx = (this.sizeX/this.res)*x - this.sizeX/2 + (this.sizeX/this.res)/2;
		var sx = (this.sizeX/this.res) - this.spacing*2;

		for (var z=0; z<this.res; z++)
		{
			var cz = (this.sizeZ/this.res)*z - this.sizeZ/2 + (this.sizeZ/this.res)/2;
			var sz = (this.sizeZ/this.res) - this.spacing*2;

			var radius = center.distanceTo(new THREE.Vector3(cx, 0, cz));

			if (radius <= 80)
			{
				// Make a geometry to subtract from the floor
				var floorHoleGeo = new THREE.BoxGeometry(sx+this.crack*2, 180, sz+this.crack*2);
				floorHoleGeo = bevelBoxEdges(floorHoleGeo, this.bevel);
				floorHoleGeo.applyMatrix(new THREE.Matrix4().makeTranslation(cx,0,cz));
				subtractGeo.merge(floorHoleGeo);

				var mat = new THREE.MeshLambertMaterial({color: 0x5C5C5C});
				var mesh = new THREE.Mesh(columnGeo, mat);
				mesh.position.set(cx, this.floorLevel, cz);
				//this.add(mesh);

				this.columns.push({
					x: cx,
					z: cz,
					r: radius,
					mesh: mesh
				})
				this.add(this.columns[this.columns.length-1].mesh);

			}
		}
	}

	floorCSG = floorCSG.subtract(new ThreeBSP(subtractGeo));
	var floorGeo = floorCSG.toGeometry();
	floorGeo.applyMatrix(new THREE.Matrix4().makeTranslation(0,-75,0));
	var floor = new THREE.Mesh(floorGeo, rockMat);
	floor.position.set(0,this.floorLevel,0);
	this.add(floor);


	this.freqs = new Uint8Array(_analyzer.frequencyBinCount);

	this.lastTime = 0;
	this.sinusT = 0;

	this.animate = function(t)
	{

		var diff = t-this.lastTime;


		_analyzer.getByteFrequencyData(this.freqs);

		var offset = getVal('var1');
		var sinusWeight = getVal('var2');
		var sinusN = getVal('var3');
		var musicWeight = getVal('var4');

		this.sinusT += diff*sinusN;

		for (var i=0; i<this.columns.length; i++)
		{
			var sinus = (Math.sin(this.columns[i].r/20+this.sinusT)*0.5+0.5) * sinusWeight;
			var music = this.freqs[i]/10 * musicWeight/100;

			this.columns[i].mesh.position.y = this.floorLevel + sinus + music + offset;
		}		


		this.lastTime = t;
	}

};

THREE.CaveColumns.prototype = Object.create(THREE.Object3D.prototype);
THREE.CaveColumns.prototype.constructor = THREE.CaveColumns;