/**
 * Cloud 9
 * staalebk
 */
THREE.BlinkyBox = function(size) {
	THREE.Object3D.call(this);

	this.type = 'BlinkyBox';
	this.size = size;

	this.boxGeo = new THREE.BoxGeometry(size,size,size,1,1,1);

	this.sphereGeo = new THREE.SphereGeometry(size/3,15,15);

	//this.baseColor = 0x87609C; // indigo :p
	this.baseColor = 0x487EAB;
	this.pokeColor = 0xB631C6;

	this.boxMaterial = new THREE.MeshLambertMaterial({
		color: this.baseColor
	});

	this.pokeMaterial = new THREE.MeshLambertMaterial({
		color: this.pokeColor
	});

	this.glow = {};
	this.glow.neonColors = {
			true: {
				"inner": new THREE.Color(1.0, 1.0, 1.0),
				"outer": new THREE.Color(1.0, 1.0, 0.0)
			},
			false: {
				"inner": new THREE.Color(0.5, 0.5, 0.5),
				"outer": new THREE.Color(0.3, 0.3, 0.3)
			}
		}

	this.glow.neonMaterial = new THREE.ShaderMaterial({
			uniforms: {
				"OuterColor": { "type": "c", "value": this.glow.neonColors[true]["outer"] },
				"InnerColor": { "type": "c", "value": this.glow.neonColors[true]["inner"] }
			},
			vertexShader: shaders.vertexShader_microscope,
			fragmentShader: shaders.fragmentShader_microscope
		});
	this.glow.material = this.glow.neonMaterial;



	this.box = new THREE.Mesh(this.boxGeo, this.boxMaterial );
	this.add(this.box);


	// Poky things

	var pokyGeo = new THREE.BoxGeometry(size*0.7,size*1.5,size*0.7);
	pokyGeo = bevelBoxEdges(pokyGeo, size/6);
	this.poke1 = new THREE.Mesh(pokyGeo, this.pokeMaterial);
	this.add(this.poke1);
	this.poke2 = new THREE.Mesh(pokyGeo, this.pokeMaterial);
	this.poke2.rotation.x = deg2rad(90);
	this.add(this.poke2);


	this.sphereOffset = size/2;
	this.sphere1 = new THREE.Mesh(this.sphereGeo, this.glow.material);
	this.sphere1.position.x = size/2;
	this.add(this.sphere1);
	this.sphere2 = new THREE.Mesh(this.sphereGeo, this.glow.material);
	this.sphere2.position.x = -size/2;
	this.add(this.sphere2);


	this.light1 = new THREE.PointLight(0xFFFE90,1,100);
	this.light1.position.x = size*2;
	this.light2 = new THREE.PointLight(0xFFFE90,1,100);
	this.light2.position.x = -size*2;
	this.add(this.light1);
	this.add(this.light2);

	this.animate = function(n)
	{
		var colorInner = new THREE.Color(this.glow.neonColors[false]["inner"].r, this.glow.neonColors[false]["inner"].g, this.glow.neonColors[false]["inner"].b);
		var colorOuter = new THREE.Color(this.glow.neonColors[false]["outer"].r, this.glow.neonColors[false]["outer"].g, this.glow.neonColors[false]["outer"].b);

		this.glow.neonMaterial.uniforms.InnerColor.value = colorInner.lerp(this.glow.neonColors[true]["inner"], n);
		this.glow.neonMaterial.uniforms.OuterColor.value = colorOuter.lerp(this.glow.neonColors[true]["outer"], n);

		this.box.scale.set(1-n*0.1, 1-n*0.1, 1-n*0.1);
		this.poke1.scale.set(1, 1+n*0.5, 1);
		this.poke2.scale.set(1, 1+n*0.5, 1);
		this.sphere1.position.set(this.sphereOffset + size/2*n*0.2, this.sphere1.position.y ,this.sphere1.position.z);
		this.sphere2.position.set(-this.sphereOffset - size/2*n*0.2, this.sphere2.position.y ,this.sphere2.position.z);

		this.light1.intensity = n;
		this.light2.intensity = n;
	}

};

THREE.BlinkyBox.prototype = Object.create(THREE.Object3D.prototype);
THREE.BlinkyBox.prototype.constructor = THREE.BlinkyBox;