
THREE.Balloon = function () {

	THREE.Object3D.call( this );

	this.type = 'Balloon';


	var balloonmaterial = new THREE.MeshLambertMaterial({
		ambient: 0x999999,
		color: 0xFF0000,
		emissive: 0x222222,
		shading: THREE.FlatShading
	});

	var basketmaterial = new THREE.MeshLambertMaterial({
		ambient: 0x999999,
		color: 0xFFFF00,
		emissive: 0x222222,
		shading: THREE.FlatShading
	});

	var balloon = new THREE.DodecahedronGeometry(10,2);

	for (var i=0; i < balloon.vertices.length; i++) {

		if(balloon.vertices[i].y < 0){
			var fudge = (10 + balloon.vertices[i].y)/10;
			fudge = fudge - 1;
			fudge = ((fudge/1)*fudge*fudge)+1;
			if(balloon.vertices[i].y < -9){
				balloon.vertices[i].y = -9;
			}
			balloon.vertices[i].y = balloon.vertices[i].y * 1.8;
			balloon.vertices[i].x = balloon.vertices[i].x * fudge;
			balloon.vertices[i].z = balloon.vertices[i].z * fudge;

		}
		//stamme_g.applyAxisAngle(new THREE.Vector3(i,i,i), angle = Math.PI/i);
	}

	var balloon_m = new THREE.Mesh(balloon, balloonmaterial);
	balloon_m.castShadow = true;
	this.add(balloon_m);

	var basket = new THREE.BoxGeometry(1.5,1.5,1.5);
	var basket_m = new THREE.Mesh(basket, basketmaterial);
	basket_m.translateY(-20);
	this.add(basket_m);


	this.animate = function(n)
	{
		/* Animate object here */
	}

};

THREE.Balloon.prototype = Object.create( THREE.Object3D.prototype);
THREE.Balloon.prototype.constructor = THREE.Balloon;
