// This shader is applied as the last post processing pass on all scenes
// and controls fade to black and other common shader effects.

// Borrowed the layout from RGBShiftShader.js

var FinalPassShader, final_pass;

function load_final_pass_shader()
{

	FinalPassShader = {
		uniforms: {
			"tDiffuse": { type: "t", value: null },
			"demoTime": { type: "f", value: 0.0 },
			"fadeToBlack": { type: "f", value: 0.0 },
			"rgbShift": { type: "f", value: 0.0 },
			"lens": { type: "f", value: 0.0 },
			"vignette": { type: "f", value: 0.0 },
			"grain": { type: "f", value: 0.0 },
			"scanlines": { type: "f", value: 0.0 }
		},
		
		vertexShader: [

			"varying vec2 vUv;",

			"void main() {",

				"vUv = uv;",
				"gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );",

			"}"

		].join("\n"),

		fragmentShader: shaders.fragmentShader_final_pass
	}

	final_pass = new THREE.ShaderPass(FinalPassShader);
	final_pass.renderToScreen = true;
}