THREE.AdditiveBlendShader = {

	uniforms: {

		"tDiffuse": { type: "t", value: null },
		"tDiffuse2": { type: "t", value: null },
		"color":     { type: "c", value: new THREE.Color( 0xffffff ) }
	},

	vertexShader: [

		"varying vec2 vUv;",
		"void main() {",
			"vUv = uv;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );",
		"}"

	].join("\n"),

	fragmentShader: [

		"uniform sampler2D tDiffuse;",
		"uniform sampler2D tDiffuse2;",
		"uniform vec3 color;",
		"varying vec2 vUv;",

		"void main() {",
			"vec4 texel1 = texture2D( tDiffuse, vUv );",
			"vec4 texel2 = texture2D( tDiffuse2, vUv );",
			"gl_FragColor = texel1 + vec4(color, 1.0) * texel2 * 3.0;",
		"}"

	].join("\n")

};

THREE.AdditiveBlendShader2 = {

	uniforms: {

		"tDiffuse": { type: "t", value: null },
		"tDiffuse2": { type: "t", value: null },
		"color":     { type: "c", value: new THREE.Color( 0xffffff ) }
	},

	vertexShader: [

		"varying vec2 vUv;",
		"void main() {",
			"vUv = uv;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );",
		"}"

	].join("\n"),

	fragmentShader: [

		"uniform sampler2D tDiffuse;",
		"uniform sampler2D tDiffuse2;",
		"uniform vec3 color;",
		"varying vec2 vUv;",

		"void main() {",
			"vec4 texel1 = texture2D( tDiffuse, vUv );",
			"vec4 texel2 = texture2D( tDiffuse2, vUv );",
			"gl_FragColor = texel1 + vec4(color, 1.0) * texel2;",
		"}"

	].join("\n")

};

THREE.AdditiveBlendShader3 = {

	uniforms: {

		"tDiffuse": { type: "t", value: null },
		"tDiffuse2": { type: "t", value: null },
		"color":     { type: "c", value: new THREE.Color( 0xffffff ) }
	},

	vertexShader: [

		"varying vec2 vUv;",
		"void main() {",
			"vUv = uv;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );",
		"}"

	].join("\n"),

	fragmentShader: [

		"uniform sampler2D tDiffuse;",
		"uniform sampler2D tDiffuse2;",
		"uniform vec3 color;",
		"varying vec2 vUv;",

		"void main() {",
			"vec4 texel1 = texture2D( tDiffuse, vUv );",
			"vec4 texel2 = texture2D( tDiffuse2, vUv );",
			"gl_FragColor = texel1 + vec4(color, 1.0) * texel2 * 0.1;",
		"}"

	].join("\n")

};

THREE.RemoveNonTransparentShader = {

	uniforms: {

		"tDiffuse": { type: "t", value: null },
		"tDiffuse2": { type: "t", value: null },
	},

	vertexShader: [

		"varying vec2 vUv;",
		"void main() {",
			"vUv = uv;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );",
		"}"

	].join("\n"),

	fragmentShader: [

		"uniform sampler2D tDiffuse;",
		"uniform sampler2D tDiffuse2;",
		"varying vec2 vUv;",

		"void main() {",
			"vec4 texel1 = texture2D( tDiffuse, vUv );",
			"vec4 texel2 = texture2D( tDiffuse2, vUv );",
			"vec3 color = texel1.rgb*(1.0-texel2.a);",
			"gl_FragColor = vec4(color, 1.0);",
		"}"

	].join("\n")

};