import sys
sys.path.append("..")
import random, pprint, math
from coord import Coord
from connector import GameConnector
from world import World
from players import Players
from mapwindow import MapWindow, MapWindowThread

class Bot(object):
    debug = False
    gui = True
    name = "zomGbot"
    gc = None
    world = World(Coord(x=0, y=0), Coord(x=0, y=0), [], [], [])
    players = Players(None, 0)
    shells = []
    items = []
    me = None
    commands = { 'UP': 1 << 0, 'DOWN': 1 << 1, 'LEFT': 1 << 2, 'RIGHT': 1 << 3, 'DRIFT': 1<<4, 'USEITEM': 1<<5 }
    mapwindow = None
    frame = 0

    def __init__(self):
        self.gc = GameConnector(self.name)

        self.gc.handler_mapdata = self.mapUpdate
        self.gc.handler_updateself = self.updateSelf
        self.gc.handler_enemylist = self.enemyList
        self.gc.handler_commandrequest = self.makeChoice
        self.gc.handler_shelllist = self.shellList
        self.gc.handler_itemlist = self.itemList
        #self.gc.handler_endround = self.endOfRound


#        self.gc.connect("192.168.1.235", 31337) #axel
        self.gc.connect("localhost", 31337)
#        self.gc.connect("192.168.1.41", 31337)

        self.world.debug = self.debug
        self.world.setPlayers(self.players)

    def run(self):
        self.gc.parsingLoop()

    def endOfRound(self):
        if self.debug:
            print "Round is over"

    def shellList(self, shells):
        if self.debug:
            print "Shells: {0}".format(shells)

        self.world.updateShells(shells)

    def itemList(self, items):
        if self.debug:
            print "Items: {0}".format(items)

        self.world.updateItems(items)

    def makeChoice(self):
        self.frame += 1
        
        if self.debug:
            print "Making a choice"

        ownSpeed = self.me['velocity'].magnitude()

        targetIdx, targetTile = self.world.updateTarget(self.me['pos'])
        targetCoord = self.world.getCorneringPointForTile(targetTile, targetIdx, self.me['pos'], ownSpeed)

        if self.mapwindow != None:
            self.mapwindow.tileText(targetTile, "T")
            self.mapwindow.setLine(self.me['pos'], targetCoord)

        currentAngle = (math.atan2(self.me['direction'].y, self.me['direction'].x) * 180/math.pi) + 180

        targetVector = (targetCoord - self.me['pos']).normalize()
        targetAngle = (math.atan2(targetVector.y, targetVector.x) * 180/math.pi) + 180

        deltaAngle = targetAngle - currentAngle

        if deltaAngle > 180:
            deltaAngle -= 360
        elif deltaAngle < -180:
            deltaAngle += 360

        #if self.frame % 100 == 0:
        #    print "My angle: {0}, Target: {1}, Delta: {2}".format(currentAngle, targetAngle, deltaAngle)

        buttonsPressed = 0

        if math.fabs(deltaAngle) < 75: # and ownSpeed < 150:
            buttonsPressed |= self.commands['UP']
        else:
            print("Tuuurn around, do not speed up")

        if math.fabs(deltaAngle) > 95 and ownSpeed > 15:
            buttonsPressed |= self.commands['DOWN']

        if deltaAngle < -2:
            buttonsPressed |= self.commands['LEFT']
        elif deltaAngle > 2:
            buttonsPressed |= self.commands['RIGHT']

#        if self.world.isCorner(targetTile):
#            buttonsPressed |= self.commands['DRIFT']

        buttonsPressed |= self.commands['USEITEM']
        if ownSpeed > 150:
            print("OVERSPEED!")

        return str(buttonsPressed)

    def enemyList(self, enemies):
        if self.debug:
            print "Enemies: ", enemies

        self.players.update(enemies)

    def updateSelf(self, me):
        if self.debug:
            print "I am {0}".format(me)

        if me == None:
            return

        self.me = me
        self.players.update([me])
        self.players.own_id = me['id']

    def mapUpdate(self, mapSize, tileSize, checkpoints, mapTiles, modifiers):
        if self.debug:
            print "Map is {0}".format(mapSize)

        self.world.update(Coord(x=mapSize[1], y=mapSize[0]), Coord(x=tileSize[1], y=tileSize[0]), checkpoints, mapTiles, modifiers)

        
#        if self.mapwindow == None and self.gui:
#            print "Creating window"
#            self.mapwindow = MapWindow(self.world, self.players)
#            self.world.setMapwindow(self.mapwindow)


if __name__ == "__main__":
    bot = Bot()
    bot.run()