import logging
logging.basicConfig()
logger = logging.getLogger(__name__)
from coord import Coord
import socket
import time
import pprint
import json
import datetime

class GameConnector(object):
    handler_mapdata = None
    handler_updateself = None
    handler_enemylist = None
    handler_endround = None
    handler_commandrequest = None
    handler_itemlist = None

    sock = None
    ownName = None
    ownId = 0
    mapSize = Coord(x=0, y=0)
    inputbuf = ""
    initing = True

    def __init__(self, ownName):
        self.ownName = ownName

    def connect(self, host, port):
        self.sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        try:
            self.sock.settimeout(0.01)
            self.sock.connect((host, port))
            #self.sendLine("JSON")
            self.sendLine(self.ownName)

        except socket.error as e:
            pprint.pprint(e)
            exit()

    def readPacket(self):
        try:
            self.inputbuf += self.sock.recv(1024)
        except socket.timeout as s_timout:
            pass
        except socket.error as s_error:
            logger.error(s_error)
            if s_error.errno == 10054:
                print "Disconnected..."
                exit()

            return None

        try:
            characters_to_read = self.inputbuf.index("\n")
            line = self.inputbuf[0:characters_to_read]  # removing the newline
            self.inputbuf = self.inputbuf[characters_to_read + 1:len(self.inputbuf)]
            return line
        except ValueError as f:
            #logger.error(f)
            return None

    def parseJSONPacket(self, packet):
        #print "Get JSON data: {0}".format(packet)

        if self.initing == True:
            #print "Packet:\n{0}".format(json.dumps(packet))
            self.initing = False
            self.ownId = packet["id"]

            if "map" in packet:
                mapsize = (len(packet["map"]["tiles"]), len(packet["map"]["tiles"][0]))
                tilesize = (packet["map"]["tile_height"], packet["map"]["tile_width"])
                checkpoints = packet["map"]["path"]
            
                self.handler_mapdata( mapsize, tilesize, checkpoints, packet["map"]["tiles"], packet["map"]["modifiers"] )

            #time.sleep(10)
            # Kick off everything with a 1337 packet
            self.sendLine(str(1 << 0))

        else:
            me = None
            enemies = []
            #print "Packet:\n{0}".format(json.dumps(packet))

            for car in packet["cars"]:
                #print "Car is a {0} containing {1}".format(type(car), car)
                if type(car) is dict:
                    if car['id'] == self.ownId:
                        me = car
                    else:
                        enemies.append(car)

            self.handler_updateself( me )

            if "shells" in packet:
                self.handler_shelllist( packet["shells"] )

            if "items" in packet:
                self.handler_itemlist( packet["items"] )

            self.handler_enemylist( enemies )
            
            a = datetime.datetime.now()
            cmd = self.handler_commandrequest()
            b = datetime.datetime.now()

            timeused = (b - a).microseconds / 1000
            #print "Command request took: {0} ms".format(timeused)

            if cmd != None:
                self.sendLine(cmd)

    def parseLine(self, line):
        #print "SERVER: |{0}|".format(line)

        try:
            packet = json.loads(line)
        except ValueError as e:
            print("Error decoding JSON packet: {0}\nJSON: {1}".format(e, line))
        except AttributeError as e:
            print("Invalid message: %s" % e)
        else:
            self.parseJSONPacket(packet)

    def sendLine(self, line):
        self.previous_message = line
        #print "CLIENT: |{0}|".format(line)

        if self.sock.sendall(line + "\n") is not None:
            print("Error sending data!")

    def parsingLoop(self):
        try:        
            while True:
                line = self.readPacket()

                if line != None:
                    self.parseLine(line)

        except KeyboardInterrupt:
            print "OK, I'm quitting!"
            exit()
            # except Exception as e:
            # pprint.pprint(e)