/*
 * Decompiled with CFR 0.152.
 */
package com.petterroea.neural;

import com.petterroea.neural.INode;
import java.util.LinkedList;

public class CosNode
implements INode {
    INode in = null;
    LinkedList<INode> outputs = new LinkedList();
    private boolean hasSimulated = false;
    private float value = 0.0f;

    @Override
    public boolean canConnectInput() {
        return this.in == null;
    }

    @Override
    public void connectInput(INode n) {
        if (this.in == null) {
            this.in = n;
        }
    }

    @Override
    public void disconnectInput(INode n) {
        if (n.equals(this.in)) {
            this.in = null;
        }
    }

    @Override
    public int getNeededInputs() {
        return this.in == null ? 1 : 0;
    }

    @Override
    public boolean canSimulate() {
        return this.in != null && this.in.hasSimulated() && !this.hasSimulated();
    }

    @Override
    public void simulate() {
        if (this.canSimulate()) {
            this.value = (float)Math.cos(this.in.getOutput());
            this.hasSimulated = true;
            for (INode outputNode : this.outputs) {
                if (!outputNode.canSimulate()) continue;
                outputNode.simulate();
            }
        }
    }

    @Override
    public boolean hasSimulated() {
        return this.hasSimulated;
    }

    @Override
    public void connectOutput(INode n) {
        this.outputs.add(n);
    }

    @Override
    public boolean canConnectOutput() {
        return true;
    }

    @Override
    public void disconnectOutput(INode n) {
        this.outputs.remove(n);
    }

    @Override
    public float getOutput() {
        return this.value;
    }

    @Override
    public int getNeededOutputs() {
        return this.outputs.size() > 0 ? 0 : 1;
    }

    @Override
    public void reset() {
        this.hasSimulated = false;
    }
}

