package com.petterroea.neural;

import java.util.LinkedList;

public class InputNode implements INode{
	private float value = 0.0f;
	private String name = "UNKNOWN";
	private LinkedList<INode> outputs = new LinkedList<INode>();
	
	public InputNode(float value, String name)
	{
		this.value = value;
		this.name = name;
	}
	public String getName() {
		return name;
	}
	public void setInput(float value) {
		this.value = value;
	}

	@Override
	public boolean canConnectInput() {
		return false;
	}

	@Override
	public void connectInput(INode n) {
		//Do nothing, this is an input node
	}

	@Override
	public boolean canSimulate() {
		//We are technically not simulating, as we are not processing data
		return true;
	}

	@Override
	public void simulate() {
		for(INode output : outputs) {
			if(output.canSimulate()) {
				output.simulate();
			}
		}
	}

	@Override
	public void connectOutput(INode n) {
		outputs.add(n);
	}

	@Override
	public boolean canConnectOutput() {
		// This node is all about output! :D
		return true;
	}

	@Override
	public float getOutput() {
		return value;
	}

	@Override
	public boolean hasSimulated() {
		return true;
	}

	@Override
	public void reset() {
		//Does nothing
	}

	@Override
	public void disconnectInput(INode n) {
		//There is no input!
	}

	@Override
	public void disconnectOutput(INode n) {
		outputs.remove(n);
	}

	@Override
	public int getNeededInputs() {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public int getNeededOutputs() {
		// TODO Auto-generated method stub
		return outputs.size() > 0 ? 0 : 1;
	}

}
