package com.petterroea.neural;

public interface INode {
	public boolean canConnectInput();
	public void connectInput(INode n);
	public void disconnectInput(INode n);
	public int getNeededInputs();
	public boolean canSimulate();
	public void simulate();
	public boolean hasSimulated();
	public void connectOutput(INode n);
	public boolean canConnectOutput();
	public void disconnectOutput(INode n);
	public float getOutput();
	public int getNeededOutputs();
	public void reset();
}
