package com.petterroea.kartering.map;

import com.petterroea.kartering.Modifier;
import com.petterroea.kartering.math.IntVect;

public class MatchData {
	private int myId = 0;
	private int tile_width = 0;
	private int tile_height = 0;
	private int tileArrayWidth = 0;
	private int tileArrayHeight = 0;
	private Tile[] tiles = null;
	private Modifier[] modifiers = null;
	private IntVect[] path = null;
	public MatchData(int selfId, int tileWidth, int tileHeight, int tileArrayWidth, int tileArrayHeight, Tile[] tiles, Modifier[] modifiers, IntVect[] path)
	{
		this.myId = selfId;
		this.tile_width = tileWidth;
		this.tile_height = tileHeight;
		this.tileArrayWidth = tileArrayWidth;
		this.tileArrayHeight = tileArrayHeight;
		this.tiles = tiles;
		this.modifiers = modifiers;
		this.path = path;
	}
	//Getters
	public int getSelfId()
	{
		return myId;
	}
	public int getTileWidth()
	{
		return tile_width;
	}
	public int getTileHeight()
	{
		return tile_height;
	}
	public int getMapWidth()
	{
		return tileArrayWidth;
	}
	public int getMapHeight()
	{
		return tileArrayHeight;
	}
	public Tile getTile(int x, int y)
	{
		return tiles[x+(y*tileArrayWidth)];
	}
	public Tile[] getTileArray()
	{
		return tiles;
	}
	public Modifier[] getModifiers()
	{
		return modifiers;
	}
	public IntVect[] getPath()
	{
		return path;
	}
}
