package com.petterroea.kartering;

import com.petterroea.kartering.map.*;
import com.petterroea.kartering.math.*;

public class KarteringAi {
	public static void main(String[] args)
	{
		new KarteringAi();
	}
	
	private MatchData matchData = null;
	private AnalysisAStar astar = new AnalysisAStar();
	public KarteringAi() {
		System.out.println("We have started!");
		NetworkManager manager = new NetworkManager("127.0.0.1", 31337, "yoloman");
		matchData = manager.getMapData();
		manager.sendByte(0);
		int lastCheckpoint = -1;
		//This is where the fun comes
		while(manager.Connected()) {
			GameState state = manager.getGameState();
			//Update checkpoint position
			int checkpoint = state.getCheckpoint(matchData);
			if(checkpoint == lastCheckpoint+1) {
				lastCheckpoint = checkpoint;
				if(lastCheckpoint+1 >= matchData.getPath().length) {
					lastCheckpoint = -1;
				}
			}
			System.out.println("Target checkpoint: " + (lastCheckpoint+1));
			//get map of where we can drive
			boolean[] map = generateCollisionMap(matchData);
			IntVect currentCheckpoint = state.getTileCoord( state.getMyCar(matchData).getPosition().toIntVect(), matchData);
			System.out.println("Generating route from " + currentCheckpoint.getX() + ", " + currentCheckpoint.getY() + " to " + matchData.getPath()[lastCheckpoint+1].getX() + ", " + matchData.getPath()[lastCheckpoint+1].getY());
			AStarRoute route = astar.getRoute(map, matchData.getMapWidth(), currentCheckpoint, matchData.getPath()[lastCheckpoint+1] );
			if(route != null) {
				System.out.println("Closest route to desstination: ");
				for(int i = 0; i < route.getPoints().length; i++) {
					System.out.print("[" + route.getPoints()[i].getX() + ", " + route.getPoints()[i].getY() + "]");
				}
				System.out.println();
				manager.sendByte(steerTo(state.getCheckpointVector(route.getPoints()[1], matchData), state));
			} else {
				manager.sendByte(steerTo(state.getCheckpointVector(matchData.getPath()[lastCheckpoint+1], matchData), state));
			}
		}
	}
	private int steerTo(FloatVect checkpointVector, GameState state) {
		FloatVect mySpeed = state.getMyCar(matchData).getDirection();
		checkpointVector = new FloatVect(checkpointVector.getX()-state.getMyCar(matchData).getPosition().getX(), checkpointVector.getY()-state.getMyCar(matchData).getPosition().getY());
		float degrees = -1f*((float)Math.toDegrees(Math.atan2(mySpeed.dot(checkpointVector) , mySpeed.det(checkpointVector)))-90.0f);
		System.out.println("Got angle " + degrees);
		boolean steerLeft = false;
		if(degrees < 0f || degrees > 180f) {
			steerLeft = true;
		} else {
			steerLeft = false;
		}
		float abs = Math.abs(degrees);
		if(abs<10f) {
			return 1 + 32;
		} else if (abs > 70){
			return 16 + (steerLeft ? 4 : 8) + 32;
		} else {
			return 1 + (steerLeft ? 4 : 8) + 32;
		}
	}
	private boolean[] generateCollisionMap(MatchData matchData) {
		boolean[] map = new boolean[matchData.getMapWidth()*matchData.getMapHeight()];
		for(int x = 0; x < matchData.getMapWidth(); x++) {
			for(int y = 0; y < matchData.getMapHeight(); y++) {
				map[x+(y*matchData.getMapWidth())] = matchData.getTile(x, y).getType() == Tile.TileType.BLANK;
				System.out.print(map[x+(y*matchData.getMapWidth())] ? "1" : "0");
			}
			System.out.println();
		}
		return map;
	}
}
