should = require 'should'
Vec2 = require('rg.vec2')
main = require '../main'
mockData = require './main.spec.mock-data'

describe 'them tests', ->
  context.skip 'test setup', ->
    before ->
      main.setter(mockData.initData, 'initData')
      return
    it 'should be able to find the steering function', ->
      should.exist(main.formatMessage)
      return
    it 'should have initialized initData', ->
      should.exist(main.getter('initData'))
      return
  return
describe 'simple tests', ->
  it 'should handle flying left and needing to turn right-top', ->
    directionVec = new Vec2(-1, 0)

    console.log 'directionVec'
    console.log directionVec
    console.log main.convertToDegrees directionVec.angle()

    goalVec = new Vec2(-1, -1)
    console.log 'goalVec'
    console.log goalVec
    console.log main.convertToDegrees goalVec.angle()

    myCar = direction: {x: -1, y: 0}
    result = main.calculateAngleBetweenVectors(directionVec, goalVec, myCar)
    result.should.equal 45
    return
  it 'should handle flying bottom with goal to the bottom', ->
    directionVec = new Vec2(0, 1)
    goalVec = new Vec2(0, 1)
    myCar = direction: {x: 0, y: 1}
    result = main.calculateAngleBetweenVectors(directionVec, goalVec, myCar)
    result.should.equal 0
    return
  it 'should handle flying bottom with goal to the bottom-left', ->
    directionVec = new Vec2(0, 1)
    goalVec = new Vec2(-1, 1)
    myCar = direction: {x: 0, y: 1}
    result = main.calculateAngleBetweenVectors(directionVec, goalVec, myCar)
    result.should.equal 45
    return
  it 'should handle flying bottom-left with goal to the left-top', ->
    directionVec = new Vec2(-1, 1)
    goalVec = new Vec2(-1, -1)
    myCar = direction: {x: -1, y: 1}
    result = main.calculateAngleBetweenVectors(directionVec, goalVec, myCar)
    result.should.equal 90
    return

  it 'should handle flying downwards and needing to turn right', ->
    directionVec = new Vec2(0, 1)
    goalVec = new Vec2(-1, 0)
    myCar = direction: {x: 0, y: 1}
    result = main.calculateAngleBetweenVectors(directionVec, goalVec, myCar)
    result.should.equal 90
    return
  return
describe.skip 'the steering logic', ->
  before ->
    main.setter(mockData.initData, 'initData')
    return
  context 'the player is in the top path moving right and the goal is bottom right', ->
    before ->
      main.setter(2, 'currentTarget')
      return
    it 'should want to turn right', ->
      commands = main.calculateNextMove(mockData.carIsTopAndFacingRight)
      should.equal(commands[3], 1)
      return
    it 'should calculateNextMove', ->
      dataFromServer = mockData.carIsTopAndFacingRight
      myCar = dataFromServer.cars[0]
      myVector = new Vec2(myCar.velocity.x, myCar.velocity.y)
      goalPos = main.getPositionOfNextTile(main.getter('nextTarget'))
      goalVector = new Vec2(goalPos.center_x - myCar.pos.x, goalPos.center_y - myCar.pos.y)
      result = main.calculateAngleBetweenVectors(myVector, goalVector, myCar)
      should.equal(result > 0, true, 'the angle is not positive')
      return
    return
  context 'when the player is top right and the goal is bottom', ->
    before ->
      main.setter(3, 'currentTarget')
      return
    it.skip 'should want to go straight', ->
      commands = main.calculateNextMove(mockData.carIsTopRightAndFacingDown)
      should.deepEqual(commands, [1])
      return
    it 'should calculate the needed angle to be small', ->
      dataFromServer = mockData.carIsTopRightAndFacingDown
      myCar = dataFromServer.cars[0]
      myVector = new Vec2(myCar.velocity.x, myCar.velocity.y)
      goalPos = main.getPositionOfNextTile(main.getter('nextTarget'))
      goalVector = new Vec2(goalPos.center_x - myCar.pos.x, goalPos.center_y - myCar.pos.y)
      result = main.calculateAngleBetweenVectors(myVector, goalVector, myCar)
      should.equal(result < 20 and result > -20  , true, 'the angle is not almost straight')
    return
  context 'when the player is bottom, facing left and the goal is left-top', ->
    before ->
      main.setter(6, 'currentTarget')
      return
    it 'should want to go right', ->
      commands = main.calculateNextMove(mockData.carIsBottomAndFacingLeft)
      should.exist(commands[3], 'no turnRight command issued')
      return
    it.skip 'should calculate the needed angle to be small', ->
      dataFromServer = mockData.carIsBottomAndFacingLeft
      myCar = dataFromServer.cars[0]
      myVector = new Vec2(myCar.velocity.x, myCar.velocity.y)
      goalPos = main.getPositionOfNextTile(main.getter('nextTarget'))
      goalVector = new Vec2(goalPos.center_x - myCar.pos.x, goalPos.center_y - myCar.pos.y)
      result = main.calculateAngleBetweenVectors(myVector, goalVector, myCar)
      should.equal(result < 20 and result > -20  , true, 'the angle is not almost straight')
    return
  return
return

