net = require 'net'
Vec2 = require('rg.vec2')
exports = module.exports = {}

###

###

initData = null
currentTarget = null
nextTarget = null

connectToServer = false

console.log 'Connecting to server'
client = net.connect port: 31337,
  () ->
    console.log 'Connected to server'
    client.write '1\n'

client.on 'data', (data) ->
  console.log 'client on data'
  console.log data.toString()
  data = JSON.parse(data.toString())
  console.log data
  if initData is null
    console.log 'first run'
    initData = data
    client.write '1\n'
  else
    console.log 'going normal route'
    client.write formatMessage(calculateNextMove(data))
    #client.write '9\n'

client.on 'end', () ->
  console.log('disconnected from server');


calculateNextMove = (data) ->
  myPos = data.cars[initData.id]
  commands = accellerate([])
  currentTarget = 0 unless currentTarget?
  console.log "currentTarget is set to #{currentTarget}"
  nextTarget = currentTarget + 1
  goalPos = getPositionOfNextTile(nextTarget)

  if isInsideTarget(myPos, goalPos)
    console.log "We hit the target! Let's pick another one!"
    if currentTarget is initData.map.path.length - 2
      console.log 'were at the end of the map'
      currentTarget = 1
    else
      console.log 'still following the path'
      currentTarget = nextTarget
    calculateNextMove(data)
    return commands

  myVector = new Vec2 myPos.velocity.x, myPos.velocity.y
  x = goalPos.center_x - myPos.pos.x
  y = goalPos.center_y - myPos.pos.y
  goalVector = new Vec2(x, y)

  theAngleInDegrees = calculateAngleBetweenVectors myVector, goalVector, myPos

  console.log 'theAngleInDegrees'
  console.log theAngleInDegrees

  if theAngleInDegrees < 5 and theAngleInDegrees > -5
    console.log 'going straight'
    return commands
  if theAngleInDegrees < 0
    console.log 'time to turn left'
    commands = turnLeft(commands)
    return commands
  else if theAngleInDegrees >= 0
    console.log 'time to turn right'
    commands = turnRight(commands)
    console.log commands
    return commands

calculateAngleBetweenVectors = (myVector, goalVector, myCar) ->
  console.log 'myVector'
  console.log myVector
  console.log 'myVector normalized'
  myVector.normalize()
  console.log myVector
  console.log 'myVector angle'
  console.log myVector.angle() * (180/Math.PI)
  console.log 'goalVector'
  console.log goalVector
  console.log 'goalVector normalized'
  normalizedGoalVector = goalVector.copy()
  normalizedGoalVector.normalize()
  console.log normalizedGoalVector
  console.log 'angle of normalizedGoalVector'
  console.log convertToDegrees normalizedGoalVector.angle()

  modifier = 1  if goalVector.y >= 0 and goalVector.x >= 0
  modifier = 1  if goalVector.y >= 0 and goalVector.x <= 0
  modifier = -1 if goalVector.y < 0 and goalVector.x < 0
  modifier = -1 if goalVector.y < 0 and goalVector.x > 0

  console.log 'directionVec'
  directionVec = new Vec2(myCar.direction.x, myCar.direction.y)
  console.log directionVec
  console.log convertToDegrees directionVec.angle()

  # directionVecAngle = null
  # if directionVec.x <= 0 then directionVecAngle = (convertToDegrees (directionVec.angle() - Math.pi))
  # else directionVecAngle = convertToDegrees (directionVec.angle())

  # if directionVec.y <= 0 and directionVec.x >= 0
  #   console.log 'directionVec: doing ze magic flipping'
  #   directionVecAngle = directionVecAngle * -1
  #   console.log directionVecAngle

  console.log 'goalVector angle'
  goalVector.normalize()
  console.log goalVector
  console.log goalVector.angle() * (180/Math.PI)

  finalAngle = convertToDegrees (goalVector.angle()) - directionVec.angle()

  finalAngle = finalAngle % 360

  if finalAngle < 0 then finalAngle = finalAngle + 360

  # if goalVector.x < 0 and goalVector.y > 0
  #   console.log 'convertToDegrees goalVector.angle() - directionVec.angle()'
  #   finalAngle = convertToDegrees goalVector.angle() - directionVec.angle()
  # else if goalVector.x < 0 and goalVector.y < 0 and directionVec.x < 0 and directionVec.y > 0
  #   console.log 'convertToDegrees goalVector.angle() - directionVec.angle()'
  #   finalAngle = convertToDegrees goalVector.angle() - directionVec.angle()
  # else if goalVector.x < 0 and goalVector.y < 0
  #   console.log 'convertToDegrees directionVec.angle() - goalVector.angle()'
  #   finalAngle = convertToDegrees directionVec.angle() - goalVector.angle()
  # else
  #   console.log 'dont know what to do'
  #   console.log 'convertToDegrees goalVector.angle() - directionVec.angle()'
  #   finalAngle = convertToDegrees goalVector.angle() - directionVec.angle()


  console.log "final needed angle shift #{finalAngle}"

  return finalAngle

getPositionOfNextTile = (nextTarget) ->
  result = initData.map.path[nextTarget]
  result.x = initData.map.tile_width * initData.map.path[nextTarget].tile_x
  result.y = initData.map.tile_height * initData.map.path[nextTarget].tile_y
  result.center_x = result.x + initData.map.tile_width / 2
  result.center_y = result.y + initData.map.tile_height / 2
  result

isInsideTarget = (myPos, goalPos) ->
  map = initData.map
  isWithinX = () -> myPos.pos.x > goalPos.x and myPos.pos.x < goalPos.x + map.tile_width
  isWithinY = () -> myPos.pos.y > goalPos.y and myPos.pos.y < goalPos.y + map.tile_height
  if isWithinX() and isWithinY() then return true
  else return false

convertToDegrees = (radians) -> radians * (180 / Math.PI)

accellerate = (commands) ->
  commands[0] = 1
  commands
decellerate = (commands) ->
  commands[1] = 1
  commands
turnLeft = (commands) ->
  commands[2] = 1
  commands
turnRight = (commands) ->
  commands[3] = 1
  commands
drift = (commands) ->
  commands[4] = 1
  commands
powerUp = (commands) ->
  commands[5] = 1
  commands

formatMessage = (commands) ->
  console.log 'formatMessage'
  console.log commands
  result = 0
  if commands[0] then result += 1
  if commands[1] then result += 2
  if commands[2] then result += 4
  if commands[3] then result += 8
  if commands[4] then result += 16
  if commands[5] then result += 32
  return result + '\n'

exports.getter = (name) ->
  if name is 'initData' then initData
  else if name is 'currentTarget' then currentTarget
  else if name is 'nextTarget' then nextTarget

exports.setter = (value, name) ->
  if name is 'initData' then initData = value
  else if name is 'currentTarget' then currentTarget = value
  else if name is 'nextTarget' then nextTarget = value

exports.calculateNextMove = calculateNextMove
exports.formatMessage = formatMessage
exports.getPositionOfNextTile = getPositionOfNextTile
exports.calculateAngleBetweenVectors = calculateAngleBetweenVectors
exports.convertToDegrees = convertToDegrees