﻿#region License

// --------------------------------------------------
// Copyright © OKB. All Rights Reserved.
// 
// This software is proprietary information of OKB.
// USE IS SUBJECT TO LICENSE TERMS.
// --------------------------------------------------

#endregion

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Threading;

namespace Tasks
{
    public abstract class Logger
    {
        #region LogType enum

        public enum LogType
        {
            INFO = ConsoleColor.White,
            ERROR = ConsoleColor.Red
        }

        #endregion

        private readonly Stopwatch clock = new Stopwatch();
        public List<String> BackLogg = new List<string>();


        protected Logger()
        {
            this.clock.Start();
        }


        public void Line()
        {
            Console.WriteLine("-------------------------------------------------------------------------------");
        }


        public void Log(LogType type, string msg, string val)
        {
            //Console.ForegroundColor = (ConsoleColor) type;
            TableRow(type.ToString(),
                msg.Replace("\r", "").Replace("\n", " "),
                val,
                this.clock.ElapsedMilliseconds.ToString());
            //Console.ResetColor();
        }


        public void TableRow(string type, string msg, string val, string ms)
        {
            Console.WriteLine();

            this.BackLogg.Add(string.Format("| {0,-5} | {1,-30} | {2,-21} | {3,10} |",
                type,
                msg.Length > 30 ? msg.Substring(0, 30) : msg,
                val,
                ms + " ms"));

            //Reset the command timer
            this.clock.Reset();
            this.clock.Start();
        }
    }
}